/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.TreeUtils;
import java.nio.ByteBuffer;

public final class MapLN
extends LN {
    private static final String BEGIN_TAG = "<mapLN>";
    private static final String END_TAG = "</mapLN>";
    private DatabaseImpl databaseImpl;
    private boolean deleted;

    public MapLN(DatabaseImpl db) {
        super(new byte[0]);
        this.databaseImpl = db;
        this.deleted = false;
    }

    public MapLN() throws DatabaseException {
        this.databaseImpl = new DatabaseImpl();
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    void makeDeleted() {
        this.deleted = true;
    }

    public DatabaseImpl getDatabase() {
        return this.databaseImpl;
    }

    public void setDatabase(DatabaseImpl database) {
        this.databaseImpl = database;
    }

    public void postFetchInit(DatabaseImpl db) throws DatabaseException {
        this.databaseImpl.setEnvironmentImpl(db.getDbEnvironment());
    }

    protected long computeInMemorySize() {
        return 0L;
    }

    public String toString() {
        return this.dumpString(0, true);
    }

    public String beginTag() {
        return BEGIN_TAG;
    }

    public String endTag() {
        return END_TAG;
    }

    public String dumpString(int nSpaces, boolean dumpTags) {
        StringBuffer sb = new StringBuffer();
        sb.append(super.dumpString(nSpaces, dumpTags));
        sb.append('\n');
        sb.append(TreeUtils.indent(nSpaces));
        sb.append("<deleted val=\"").append(Boolean.toString(this.deleted));
        sb.append("\">");
        sb.append('\n');
        sb.append(this.databaseImpl.dumpString(nSpaces));
        return sb.toString();
    }

    protected LogEntryType getTransactionalLogType() {
        return LogEntryType.LOG_MAPLN_TRANSACTIONAL;
    }

    public LogEntryType getLogType() {
        return LogEntryType.LOG_MAPLN;
    }

    public int getLogSize() {
        return super.getLogSize() + this.databaseImpl.getLogSize() + LogUtils.getBooleanLogSize();
    }

    public void writeToLog(ByteBuffer logBuffer) {
        super.writeToLog(logBuffer);
        this.databaseImpl.writeToLog(logBuffer);
        LogUtils.writeBoolean(logBuffer, this.deleted);
    }

    public void readFromLog(ByteBuffer itemBuffer) throws LogException {
        super.readFromLog(itemBuffer);
        this.databaseImpl.readFromLog(itemBuffer);
        this.deleted = LogUtils.readBoolean(itemBuffer);
    }

    protected void dumpLogAdditional(StringBuffer sb) {
        this.databaseImpl.dumpLog(sb, true);
    }
}

