/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LogWritable;
import com.sleepycat.je.tree.TreeUtils;
import java.nio.ByteBuffer;

public final class Key
implements Comparable,
LogWritable,
LogReadable {
    public static boolean DUMP_BINARY = false;
    private byte[] key;

    public Key() {
        this.key = null;
    }

    public Key(byte[] key) {
        if (key == null) {
            this.key = null;
        } else {
            this.init(key, 0, key.length);
        }
    }

    public Key(DatabaseEntry dbt) {
        byte[] key = dbt.getData();
        if (key == null) {
            this.key = null;
        } else {
            this.init(key, dbt.getOffset(), dbt.getSize());
        }
    }

    private void init(byte[] key, int off, int len) {
        this.key = new byte[len];
        System.arraycopy(key, off, this.key, 0, len);
    }

    public byte[] getKey() {
        return this.key;
    }

    public byte[] copy() {
        int len = this.key.length;
        byte[] ret = new byte[len];
        System.arraycopy(this.key, 0, ret, 0, len);
        return ret;
    }

    public int compareTo(Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
        Key argKey = (Key)o;
        return Key.compareByteArray(this.key, argKey.key);
    }

    public static int compareByteArray(byte[] arg1, byte[] arg2) {
        int a1Len = arg1.length;
        int a2Len = arg2.length;
        int limit = Math.min(a1Len, a2Len);
        for (int i = 0; i < limit; ++i) {
            byte b1 = arg1[i];
            byte b2 = arg2[i];
            if (b1 == b2) continue;
            short s1 = (short)(b1 & 0x7F);
            short s2 = (short)(b2 & 0x7F);
            if (b1 < 0) {
                s1 = (short)(s1 | 0x80);
            }
            if (b2 < 0) {
                s2 = (short)(s2 | 0x80);
            }
            return s1 - s2;
        }
        return a1Len - a2Len;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<key v=\"");
        if (DUMP_BINARY) {
            if (this.key != null) {
                sb.append(TreeUtils.dumpByteArray(this.key));
            } else {
                sb.append("<null>");
            }
        } else {
            sb.append(this.key == null ? "" : new String(this.key));
        }
        sb.append("\"/>");
        return sb.toString();
    }

    public String getNoFormatString() {
        return "key=" + this.key;
    }

    String dumpString(int nspaces) {
        return TreeUtils.indent(nspaces) + this.toString();
    }

    public int getLogSize() {
        return LogUtils.getByteArrayLogSize(this.key);
    }

    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeByteArray(logBuffer, this.key);
    }

    public void readFromLog(ByteBuffer itemBuf) {
        this.key = LogUtils.readByteArray(itemBuf);
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<key val=\"");
        if (DUMP_BINARY) {
            sb.append(TreeUtils.dumpByteArray(this.key));
        } else {
            sb.append(this.key == null ? "" : new String(this.key));
        }
        sb.append("\"/>");
    }

    public boolean logEntryIsTransactional() {
        return false;
    }

    public long getTransactionId() {
        return 0L;
    }
}

