/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.StoredContainer;
import com.sleepycat.collections.StoredValueSet;
import com.sleepycat.je.Database;
import java.util.Comparator;
import java.util.SortedSet;

public class StoredSortedValueSet
extends StoredValueSet
implements SortedSet {
    public StoredSortedValueSet(Database database, EntityBinding valueEntityBinding, boolean writeAllowed) {
        super(new DataView(database, null, null, valueEntityBinding, writeAllowed, null));
        this.checkKeyDerivation();
    }

    StoredSortedValueSet(DataView valueSetView) {
        super(valueSetView);
        this.checkKeyDerivation();
    }

    private void checkKeyDerivation() {
        if (!this.view.canDeriveKeyFromValue()) {
            throw new IllegalArgumentException("Cannot derive key from value");
        }
    }

    public Comparator comparator() {
        return null;
    }

    public Object first() {
        return this.getFirstOrLast(true);
    }

    public Object last() {
        return this.getFirstOrLast(false);
    }

    public SortedSet headSet(Object toValue) {
        return this.subSet(null, false, toValue, false);
    }

    public SortedSet headSet(Object toValue, boolean toInclusive) {
        return this.subSet(null, false, toValue, toInclusive);
    }

    public SortedSet tailSet(Object fromValue) {
        return this.subSet(fromValue, true, null, false);
    }

    public SortedSet tailSet(Object fromValue, boolean fromInclusive) {
        return this.subSet(fromValue, fromInclusive, null, false);
    }

    public SortedSet subSet(Object fromValue, Object toValue) {
        return this.subSet(fromValue, true, toValue, false);
    }

    public SortedSet subSet(Object fromValue, boolean fromInclusive, Object toValue, boolean toInclusive) {
        try {
            return new StoredSortedValueSet(this.view.subView(fromValue, fromInclusive, toValue, toInclusive, null));
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }
}

