/*
 * Decompiled with CFR 0.152.
 */
package arq.cmdline;

import arq.cmdline.ArgDecl;
import arq.cmdline.ArgModuleGeneral;
import arq.cmdline.CmdArgModule;
import arq.cmdline.CmdGeneral;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.PrintUtils;
import java.io.OutputStream;

public class ModQueryOut
implements ArgModuleGeneral {
    protected final ArgDecl queryOutputSyntaxDecl = new ArgDecl(true, "out", "format");
    protected final ArgDecl queryNumberDecl = new ArgDecl(true, "num", "number");
    protected final ArgDecl queryPlainDecl = new ArgDecl(false, "plain");
    private Syntax outputSyntax = Syntax.syntaxSPARQL;
    private boolean lineNumbers = true;

    public void registerWith(CmdGeneral cmdLine) {
        cmdLine.getUsage().startCategory("Output");
        cmdLine.add(this.queryOutputSyntaxDecl, "--out, --format", "Output syntax");
        cmdLine.add(this.queryNumberDecl, "--num [on|off]", "Numbers");
        cmdLine.add(this.queryPlainDecl, "--plain", "Plain output");
    }

    public void processArgs(CmdArgModule cmdline) throws IllegalArgumentException {
        if (cmdline.contains(this.queryOutputSyntaxDecl)) {
            String s = cmdline.getValue(this.queryOutputSyntaxDecl);
            Syntax syn = Syntax.lookup((String)s);
            if (syn == null) {
                cmdline.cmdError("Unrecognized syntax: " + s);
            }
            this.outputSyntax = syn;
        }
        if (cmdline.contains(this.queryNumberDecl)) {
            this.lineNumbers = cmdline.getValue(this.queryNumberDecl).equalsIgnoreCase("on");
        }
        if (cmdline.contains(this.queryPlainDecl)) {
            this.lineNumbers = false;
        }
    }

    public Syntax getOutputSyntax() {
        return this.outputSyntax;
    }

    public void output(Query query2) {
        this.output(this.out(), query2);
    }

    public void output(IndentedWriter out, Query query2) {
        PrintUtils.printQuery((IndentedWriter)out, (Query)query2, (Syntax)this.outputSyntax);
    }

    public void outputOp(Query query2) {
        this.outputOp(this.out(), query2);
    }

    public void outputOp(IndentedWriter out, Query query2) {
        PrintUtils.printOp((IndentedWriter)out, (Query)query2);
    }

    public void outputQuad(Query query2) {
        this.outputQuad(this.out(), query2);
    }

    public void outputQuad(IndentedWriter out, Query query2) {
        PrintUtils.printQuad((IndentedWriter)out, (Query)query2);
    }

    private IndentedWriter out() {
        return new IndentedWriter((OutputStream)System.out, this.lineNumbers);
    }
}

