/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.op.Op0;
import com.hp.hpl.jena.sparql.algebra.op.Op1;
import com.hp.hpl.jena.sparql.algebra.op.Op2;
import com.hp.hpl.jena.sparql.algebra.op.OpAssign;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpDatasetNames;
import com.hp.hpl.jena.sparql.algebra.op.OpDiff;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpExt;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpGroupAgg;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpList;
import com.hp.hpl.jena.sparql.algebra.op.OpModifier;
import com.hp.hpl.jena.sparql.algebra.op.OpNull;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpProcedure;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.algebra.op.OpReduced;
import com.hp.hpl.jena.sparql.algebra.op.OpService;
import com.hp.hpl.jena.sparql.algebra.op.OpSlice;
import com.hp.hpl.jena.sparql.algebra.op.OpStage;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;

public class TransformCopy
implements Transform {
    public static final boolean COPY_ALWAYS = true;
    public static final boolean COPY_ONLY_ON_CHANGE = false;
    private boolean alwaysCopy = false;

    public TransformCopy() {
        this(false);
    }

    public TransformCopy(boolean alwaysDuplicate) {
        this.alwaysCopy = alwaysDuplicate;
    }

    public Op transform(OpTable opTable) {
        return this.xform(opTable);
    }

    public Op transform(OpBGP opBGP) {
        return this.xform(opBGP);
    }

    public Op transform(OpProcedure opProc, Op subOp) {
        return this.xform(opProc, subOp);
    }

    public Op transform(OpDatasetNames dsNames) {
        return this.xform(dsNames);
    }

    public Op transform(OpQuadPattern quadPattern) {
        return this.xform(quadPattern);
    }

    public Op transform(OpFilter opFilter, Op x) {
        return this.xform(opFilter, x);
    }

    public Op transform(OpGraph opGraph, Op x) {
        return this.xform(opGraph, x);
    }

    public Op transform(OpService opService, Op x) {
        return this.xform(opService, x);
    }

    public Op transform(OpJoin opJoin, Op left, Op right) {
        return this.xform(opJoin, left, right);
    }

    public Op transform(OpStage opStage, Op left, Op right) {
        return this.xform(opStage, left, right);
    }

    public Op transform(OpLeftJoin opLeftJoin, Op left, Op right) {
        return this.xform(opLeftJoin, left, right);
    }

    public Op transform(OpDiff opDiff, Op left, Op right) {
        return this.xform(opDiff, left, right);
    }

    public Op transform(OpUnion opUnion, Op left, Op right) {
        return this.xform(opUnion, left, right);
    }

    public Op transform(OpExt opExt) {
        return opExt.copy();
    }

    public Op transform(OpNull opNull) {
        return opNull.copy();
    }

    public Op transform(OpList opList, Op subOp) {
        return this.xform(opList, subOp);
    }

    public Op transform(OpOrder opOrder, Op subOp) {
        return this.xform(opOrder, subOp);
    }

    public Op transform(OpProject opProject, Op subOp) {
        return this.xform(opProject, subOp);
    }

    public Op transform(OpDistinct opDistinct, Op subOp) {
        return this.xform(opDistinct, subOp);
    }

    public Op transform(OpReduced opReduced, Op subOp) {
        return this.xform(opReduced, subOp);
    }

    public Op transform(OpAssign opAssign, Op subOp) {
        return this.xform(opAssign, subOp);
    }

    public Op transform(OpSlice opSlice, Op subOp) {
        return this.xform(opSlice, subOp);
    }

    public Op transform(OpGroupAgg opGroupAgg, Op subOp) {
        return this.xform(opGroupAgg, subOp);
    }

    private Op xform(Op0 op) {
        if (!this.alwaysCopy) {
            return op;
        }
        return op.copy();
    }

    private Op xform(Op1 op, Op subOp) {
        if (!this.alwaysCopy && op.getSubOp() == subOp) {
            return op;
        }
        return op.copy(subOp);
    }

    private Op xform(Op2 op, Op left, Op right) {
        if (!this.alwaysCopy && op.getLeft() == left && op.getRight() == right) {
            return op;
        }
        return op.copy(left, right);
    }

    private Op xform(OpModifier op, Op subOp) {
        if (!this.alwaysCopy && op.getSubOp() == subOp) {
            return op;
        }
        return op.copy(subOp);
    }
}

