/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.query.QueryFactory;
import com.hp.hpl.jena.query.QueryParseException;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.sparql.ARQConstants;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprEvalException;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.lang.sparql.ParseException;
import com.hp.hpl.jena.sparql.lang.sparql.SPARQLParser;
import com.hp.hpl.jena.sparql.lang.sparql.Token;
import com.hp.hpl.jena.sparql.lang.sparql.TokenMgrError;
import com.hp.hpl.jena.sparql.serializer.FmtExprARQ;
import com.hp.hpl.jena.sparql.serializer.SerializationContext;
import com.hp.hpl.jena.sparql.sse.SSE;
import com.hp.hpl.jena.sparql.sse.SSEParseException;
import com.hp.hpl.jena.sparql.sse.builders.ExprBuildException;
import com.hp.hpl.jena.sparql.util.FmtUtils;
import com.hp.hpl.jena.sparql.util.IndentedLineBuffer;
import com.hp.hpl.jena.sparql.util.IndentedWriter;
import com.hp.hpl.jena.sparql.util.NodeFactory;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ExprUtils {
    public static Expr nodeToExpr(Node n) {
        if (n.isVariable()) {
            return new ExprVar(n);
        }
        return NodeValue.makeNode(n);
    }

    public static String joinList(List args, String sep) {
        if (args == null) {
            return "<<Null list>>";
        }
        if (args.size() == 0) {
            return "<<Empty list>>";
        }
        StringBuffer s = new StringBuffer();
        boolean first = true;
        ListIterator iter = args.listIterator();
        while (iter.hasNext()) {
            Expr ex;
            if (!first) {
                s.append(sep);
            }
            if ((ex = (Expr)iter.next()) instanceof NodeValue) {
                NodeValue nv = (NodeValue)ex;
                s.append(nv.asQuotedString());
            } else {
                s.append(ex.toString());
            }
            first = false;
        }
        return s.toString();
    }

    public static Expr parse(String s) {
        return ExprUtils.parse(s, ARQConstants.getGlobalPrefixMap());
    }

    public static Expr parse(String s, PrefixMapping pmap) {
        Query query = QueryFactory.make();
        query.setPrefixMapping(pmap);
        return ExprUtils.parse(query, s, true);
    }

    public static Expr parse(Query query, String s, boolean checkAllUsed) {
        try {
            StringReader in = new StringReader(s);
            SPARQLParser parser = new SPARQLParser(in);
            parser.setQuery(query);
            Expr expr = parser.Expression();
            if (checkAllUsed) {
                Token t = parser.getNextToken();
                if (t.kind != 0) {
                    throw new QueryParseException("Extra tokens beginning \"" + t.image + "\" starting line " + t.beginLine + ", column " + t.beginColumn, t.beginLine, t.beginColumn);
                }
            }
            return expr;
        }
        catch (ParseException ex) {
            throw new QueryParseException(ex.getMessage(), ex.currentToken.beginLine, ex.currentToken.beginLine);
        }
        catch (TokenMgrError tErr) {
            throw new QueryParseException(tErr.getMessage(), -1, -1);
        }
        catch (Error err) {
            String tmp = err.getMessage();
            if (tmp == null) {
                throw new QueryParseException(err, -1, -1);
            }
            throw new QueryParseException(tmp, -1, -1);
        }
    }

    public static NodeValue parseNodeValue(String s) {
        Node n = NodeFactory.create(s);
        NodeValue nv = NodeValue.makeNode(n);
        return nv;
    }

    public static void fmtSPARQL(IndentedWriter iOut, Expr expr, SerializationContext sCxt) {
        FmtExprARQ v = new FmtExprARQ(iOut, sCxt);
        v.format(expr);
    }

    public static void fmtSPARQL(IndentedWriter iOut, Expr expr) {
        ExprUtils.fmtSPARQL(iOut, expr, FmtUtils.sCxt());
    }

    public static String fmtSPARQL(Expr expr) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        ExprUtils.fmtSPARQL(buff.getIndentedWriter(), expr);
        return buff.toString();
    }

    public static void fmtSPARQL(IndentedWriter iOut, ExprList exprs, SerializationContext pmap) {
        FmtExprARQ fmt = new FmtExprARQ(iOut, pmap);
        String sep = "";
        Iterator iter = exprs.iterator();
        while (iter.hasNext()) {
            Expr expr = (Expr)iter.next();
            iOut.print(sep);
            sep = " , ";
            fmt.format(expr);
        }
    }

    public static void fmtSPARQL(IndentedWriter iOut, ExprList exprs) {
        ExprUtils.fmtSPARQL(iOut, exprs, FmtUtils.sCxt());
    }

    public static String fmtSPARQL(ExprList exprs) {
        IndentedLineBuffer buff = new IndentedLineBuffer();
        ExprUtils.fmtSPARQL(buff.getIndentedWriter(), exprs);
        return buff.toString();
    }

    public static String strComparison(int cmp) {
        switch (cmp) {
            case 1: {
                return "GT";
            }
            case 0: {
                return "EQ";
            }
            case -1: {
                return "LT";
            }
            case 2: {
                return "indeterminate";
            }
        }
        return "??";
    }

    public static void expr(String exprStr) {
        ExprUtils.expr(exprStr, null);
    }

    public static void expr(String exprStr, Binding binding) {
        try {
            Expr expr = ExprUtils.parse(exprStr, ARQConstants.getGlobalPrefixMap());
            ExprUtils.evalPrint(expr, binding);
        }
        catch (QueryParseException ex) {
            System.err.println("Parse error: " + ex.getMessage());
            return;
        }
    }

    public static void exprPrefix(String exprStr) {
        ExprUtils.exprPrefix(exprStr, null);
    }

    public static void evalPrint(Expr expr, Binding binding) {
        try {
            ARQ.getContext().set(ARQConstants.sysCurrentTime, NodeFactory.nowAsDateTime());
            ExecutionContext env = new ExecutionContext(ARQ.getContext(), null, null);
            NodeValue r = expr.eval(binding, env);
            Node n = r.asNode();
            String s = FmtUtils.stringForNode(n);
            System.out.println(s);
        }
        catch (ExprEvalException ex) {
            System.out.println("Exception: " + ex.getMessage());
            return;
        }
        catch (ExprBuildException ex) {
            System.err.println("Build exception: " + ex.getMessage());
            return;
        }
    }

    public static void exprPrefix(String string, Binding binding) {
        try {
            Expr expr = SSE.parseExpr(string);
            ExprUtils.evalPrint(expr, binding);
        }
        catch (SSEParseException ex) {
            System.err.println("Parse error: " + ex.getMessage());
            return;
        }
    }
}

