/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.util;

import com.hp.hpl.jena.graph.Node;
import java.util.HashMap;
import java.util.Map;

public class NodeToLabelMap {
    int bNodeCounter = 0;
    Map bNodeStrings = new HashMap();
    boolean bNodesAsFakeURIs = false;
    String prefixString = "b";

    public NodeToLabelMap() {
        this("b");
    }

    public NodeToLabelMap(String prefix) {
        this(prefix, false);
    }

    public NodeToLabelMap(String prefix, boolean bNodesAsFakeURIs) {
        this.prefixString = "_:" + prefix;
        this.bNodesAsFakeURIs = bNodesAsFakeURIs;
    }

    public String asString(Node n) {
        if (!n.isBlank()) {
            return null;
        }
        return this.mapNode(n);
    }

    protected String mapNode(Node n) {
        String s = (String)this.bNodeStrings.get(n);
        if (s != null) {
            return s;
        }
        s = this.genStringForNode(n);
        this.bNodeStrings.put(n, s);
        return s;
    }

    protected String genStringForNode(Node n) {
        if (this.bNodesAsFakeURIs && n.isBlank()) {
            return "<_:" + n.getBlankNodeId().getLabelString() + ">";
        }
        return this.prefixString + this.bNodeCounter++;
    }
}

