/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.procedure;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.algebra.op.OpProcedure;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.pfunction.ProcedurePF;
import com.hp.hpl.jena.sparql.pfunction.PropFuncArg;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunction;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunctionFactory;
import com.hp.hpl.jena.sparql.pfunction.PropertyFunctionRegistry;
import com.hp.hpl.jena.sparql.procedure.Procedure;
import com.hp.hpl.jena.sparql.procedure.ProcedureFactory;
import com.hp.hpl.jena.sparql.procedure.ProcedureRegistry;
import com.hp.hpl.jena.sparql.util.Context;

public class ProcEval {
    public static Procedure build(OpProcedure opProc, ExecutionContext execCxt) {
        if (opProc.getArgs() != null) {
            return ProcEval.build(opProc.getProcId(), opProc.getArgs(), execCxt);
        }
        return ProcEval.build(opProc.getProcId(), opProc.getSubjectArgs(), opProc.getObjectArgs(), execCxt);
    }

    public static Procedure build(Node procId, ExprList args, ExecutionContext execCxt) {
        Context context = execCxt.getContext();
        ProcedureRegistry reg = ProcEval.chooseProcedureRegistry(context);
        ProcedureFactory f = reg.get(procId.getURI());
        Procedure proc = f.create(procId.getURI());
        args.prepareExprs(context);
        proc.build(procId, args, execCxt);
        return proc;
    }

    private static ProcedureRegistry chooseProcedureRegistry(Context context) {
        ProcedureRegistry registry = ProcedureRegistry.get(context);
        if (registry == null) {
            registry = ProcedureRegistry.get();
        }
        return registry;
    }

    public static Procedure build(Node procId, PropFuncArg subjArg, PropFuncArg objArg, ExecutionContext execCxt) {
        Context context = execCxt.getContext();
        PropertyFunctionRegistry reg = ProcEval.choosePropFuncRegistry(context);
        PropertyFunctionFactory f = reg.get(procId.getURI());
        PropertyFunction pf = f.create(procId.getURI());
        pf.build(subjArg, procId, objArg, execCxt);
        return new ProcedurePF(pf, subjArg, procId, objArg);
    }

    public static PropertyFunctionRegistry choosePropFuncRegistry(Context context) {
        PropertyFunctionRegistry registry = PropertyFunctionRegistry.get(context);
        if (registry == null) {
            registry = PropertyFunctionRegistry.get();
        }
        return registry;
    }

    public static QueryIterator eval(QueryIterator queryIterator, Procedure proc, ExecutionContext execCxt) {
        return proc.proc(queryIterator, execCxt);
    }
}

