/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.query.larq;

import com.hp.hpl.jena.query.larq.IndexBuilderBase;
import com.hp.hpl.jena.query.larq.IndexLARQ;
import com.hp.hpl.jena.rdf.listeners.StatementListener;
import com.hp.hpl.jena.rdf.model.Statement;
import com.hp.hpl.jena.rdf.model.StmtIterator;
import java.io.File;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;

public abstract class IndexBuilderModel
extends StatementListener {
    private Directory dir = null;
    private IndexBuilderBase base;

    public IndexBuilderModel() {
        this.base = new IndexBuilderBase();
    }

    public IndexBuilderModel(IndexWriter existingWriter) {
        this.base = new IndexBuilderBase(existingWriter);
    }

    public IndexBuilderModel(File fileDir) {
        this.base = new IndexBuilderBase(fileDir);
    }

    public IndexBuilderModel(String fileDir) {
        this.base = new IndexBuilderBase(fileDir);
    }

    protected IndexWriter getIndexWriter() {
        return this.base.getIndexWriter();
    }

    protected IndexReader getIndexReader() {
        return this.base.getIndexReader();
    }

    public void removedStatement(Statement s) {
        this.unindexStatement(s);
    }

    public void unindexStatement(Statement s) {
        throw new UnsupportedOperationException("unindexStatement");
    }

    public void addedStatement(Statement s) {
        this.indexStatement(s);
    }

    public void indexStatements(StmtIterator sIter) {
        while (sIter.hasNext()) {
            this.indexStatement(sIter.nextStatement());
        }
    }

    public abstract void indexStatement(Statement var1);

    public void closeForWriting() {
        this.base.closeForWriting();
    }

    public void flushWriter() {
        this.base.flushWriter();
    }

    public void closeWriter() {
        this.base.closeWriter();
    }

    public IndexLARQ getIndex() {
        return this.base.getIndex();
    }
}

