/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.bookkeeper.resources;

import com.codahale.metrics.annotation.Timed;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.security.PermitAll;
import javax.validation.Valid;
import javax.validation.constraints.Email;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.bookkeeper.api.Customer;
import org.dataone.bookkeeper.api.CustomerList;
import org.dataone.bookkeeper.jdbi.CustomerStore;
import org.dataone.bookkeeper.resources.BaseResource;
import org.dataone.bookkeeper.security.DataONEAuthHelper;
import org.jdbi.v3.core.Jdbi;

@Timed
@Path(value="/customers")
@Produces(value={"application/json"})
public class CustomersResource
extends BaseResource {
    private Log log = LogFactory.getLog(CustomersResource.class);
    private final CustomerStore customerStore;
    private final DataONEAuthHelper dataoneAuthHelper;

    public CustomersResource(Jdbi database, DataONEAuthHelper dataoneAuthHelper) {
        this.customerStore = (CustomerStore)database.onDemand(CustomerStore.class);
        this.dataoneAuthHelper = dataoneAuthHelper;
    }

    @Timed
    @GET
    @PermitAll
    @Produces(value={"application/json"})
    public CustomerList listCustomers(@Context SecurityContext context, @QueryParam(value="start") @DefaultValue(value="0") Integer start, @QueryParam(value="count") @DefaultValue(value="1000") Integer count, @QueryParam(value="email") @Email String email, @QueryParam(value="subject") String subject) throws WebApplicationException {
        Customer caller = (Customer)context.getUserPrincipal();
        Boolean isBkAdmin = this.dataoneAuthHelper.isBookkeeperAdmin(caller.getSubject());
        List<Object> customers = new ArrayList();
        if (subject != null && !subject.isEmpty()) {
            Customer customer = this.customerStore.findCustomerBySubject(subject);
            if (customer.getSubject().compareToIgnoreCase(caller.getSubject()) != 0 && !isBkAdmin.booleanValue()) {
                throw new WebApplicationException("Bookkeeper admin privilege is required list a customer other than the requestor's, " + caller.getSubject() + " is not authorized.", Response.Status.FORBIDDEN);
            }
            customers.add(customer);
        } else if (email != null && !email.isEmpty()) {
            Customer customer = this.customerStore.findCustomerByEmail(email);
            if (customer.getSubject().compareToIgnoreCase(caller.getSubject()) != 0 && !isBkAdmin.booleanValue()) {
                throw new WebApplicationException("Bookkeeper admin privilege is required list a customer other than the requestor's, " + caller.getSubject() + " is not authorized.", Response.Status.FORBIDDEN);
            }
            customers.add(customer);
        } else {
            if (!isBkAdmin.booleanValue()) {
                throw new WebApplicationException("Bookkeeper admin privilege is required list all customers, " + caller.getSubject() + " is not authorized.", Response.Status.FORBIDDEN);
            }
            customers = this.customerStore.listCustomers();
        }
        return new CustomerList(customers);
    }

    @Timed
    @POST
    @PermitAll
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Customer create(@Context SecurityContext context, @NotNull @Valid Customer customer) throws WebApplicationException {
        Customer caller = (Customer)context.getUserPrincipal();
        boolean isAdmin = this.dataoneAuthHelper.isAdmin(caller.getSubject());
        if (!isAdmin) {
            customer.setSubject(caller.getSubject());
        }
        Customer existing = null;
        try {
            existing = this.customerStore.findCustomerByEmail(customer.getEmail());
            if (existing != null) {
                throw new Exception("A customer exists with the given email.");
            }
            existing = this.customerStore.findCustomerBySubject(customer.getSubject());
            if (existing != null) {
                throw new Exception("A customer exists with the given subject.");
            }
            customer.setCreated(new Integer((int)Instant.now().getEpochSecond()));
            Integer id = this.customerStore.insert(customer);
            customer = this.customerStore.getCustomer(id);
        }
        catch (Exception e) {
            String message = "Couldn't insert the customer: " + e.getMessage();
            throw new WebApplicationException(message, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return customer;
    }

    @Timed
    @GET
    @PermitAll
    @Produces(value={"application/json"})
    @Path(value="{customerId: [0-9]+}")
    public Customer retrieve(@Context SecurityContext context, @PathParam(value="customerId") Integer customerId) throws WebApplicationException {
        Customer caller = (Customer)context.getUserPrincipal();
        boolean isAdmin = this.dataoneAuthHelper.isAdmin(caller.getSubject());
        Customer customer = null;
        try {
            if (customerId != null) {
                customer = this.customerStore.getCustomer(customerId);
            }
            if (!isAdmin && customer != null && !customer.getSubject().equals(caller.getSubject())) {
                throw new Exception("The caller and customer subject don't match.");
            }
        }
        catch (Exception e) {
            String message = "Couldn't get the customer: " + e.getMessage();
            throw new WebApplicationException(message, Response.Status.NOT_FOUND);
        }
        return customer;
    }

    @Timed
    @PUT
    @PermitAll
    @Produces(value={"application/json"})
    @Path(value="{customerId}")
    public Customer update(@Context SecurityContext context, @NotNull @Valid Customer customer) throws WebApplicationException {
        Customer caller = (Customer)context.getUserPrincipal();
        boolean isAdmin = this.dataoneAuthHelper.isAdmin(caller.getSubject());
        try {
            Customer existing = this.customerStore.getCustomer(customer.getId());
            if (!isAdmin && existing != null && !existing.getSubject().equals(caller.getSubject())) {
                throw new Exception("The caller and customer subject don't match.");
            }
            assert (existing != null);
            customer.setCreated(existing.getCreated());
            customer.setBalance(existing.getBalance());
            customer.setDelinquent(existing.isDelinquent());
            customer.setSubject(existing.getSubject());
            customer.setSubjectInfo(null);
            if (!isAdmin) {
                customer.setDiscount(existing.getDiscount());
            }
            Integer n = this.customerStore.update(customer);
        }
        catch (Exception e) {
            String message = "Couldn't update the customer: " + e.getMessage();
            throw new WebApplicationException(message, Response.Status.INTERNAL_SERVER_ERROR);
        }
        return customer;
    }

    @Timed
    @DELETE
    @PermitAll
    @Path(value="{customerId}")
    public Response delete(@Context SecurityContext context, @PathParam(value="customerId") @Valid Integer customerId) throws WebApplicationException {
        Customer caller = (Customer)context.getUserPrincipal();
        if (!this.dataoneAuthHelper.isBookkeeperAdmin(caller.getSubject())) {
            throw new WebApplicationException("Bookkeeper admin privilege is required to delete a customer, " + caller.getSubject() + " is not authorized.", Response.Status.FORBIDDEN);
        }
        String message = "The customerId cannot be null.";
        if (customerId == null) {
            throw new WebApplicationException(message, Response.Status.BAD_REQUEST);
        }
        try {
            this.customerStore.delete(customerId);
        }
        catch (Exception e) {
            message = "Deleting the customer with id " + customerId + " failed: " + e.getMessage();
            this.log.error((Object)message);
            e.printStackTrace();
            throw e;
        }
        return Response.ok().build();
    }
}

