/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.randomizedtesting;

import com.carrotsearch.randomizedtesting.Randomness;

public final class SeedUtils {
    private static final char[] HEX = "0123456789ABCDEF".toCharArray();

    private SeedUtils() {
    }

    public static long parseSeed(String seed) {
        long result = 0L;
        for (char chr : seed.toCharArray()) {
            chr = Character.toLowerCase(chr);
            result <<= 4;
            if (chr >= '0' && chr <= '9') {
                result |= (long)(chr - 48);
                continue;
            }
            if (chr >= 'a' && chr <= 'f') {
                result |= (long)(chr - 97 + 10);
                continue;
            }
            throw new IllegalArgumentException("Expected hexadecimal seed: " + seed);
        }
        return result;
    }

    public static String formatSeed(long seed) {
        StringBuilder b = new StringBuilder();
        do {
            b.append(HEX[(int)(seed & 0xFL)]);
        } while ((seed >>>= 4) != 0L);
        return b.reverse().toString();
    }

    public static long[] parseSeedChain(String chain) {
        if (!(chain = chain.replaceAll("[\\[\\]]", "")).matches("[0-9A-Fa-f\\:]+")) {
            throw new IllegalArgumentException("Not a valid seed chain: " + chain);
        }
        String[] splits = chain.split("[\\:]");
        long[] longs = new long[splits.length];
        for (int i = 0; i < splits.length; ++i) {
            longs[i] = SeedUtils.parseSeed(splits[i]);
        }
        return longs;
    }

    public static String formatSeedChain(Randomness ... randomnesses) {
        StringBuilder b = new StringBuilder();
        b.append("[");
        for (int i = 0; i < randomnesses.length; ++i) {
            if (i > 0) {
                b.append(":");
            }
            b.append(SeedUtils.formatSeed(randomnesses[i].getSeed()));
        }
        b.append("]");
        return b.toString();
    }
}

