/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.iterator;

import com.hp.hpl.jena.query.SortCondition;
import com.hp.hpl.jena.sparql.engine.ExecutionContext;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.binding.BindingComparator;
import com.hp.hpl.jena.sparql.engine.iterator.QueryIterDistinctReduced;
import java.util.ArrayList;
import org.apache.jena.atlas.data.BagFactory;
import org.apache.jena.atlas.data.DistinctDataNet;
import org.apache.jena.atlas.data.ThresholdPolicy;
import org.apache.jena.atlas.data.ThresholdPolicyFactory;
import org.apache.jena.riot.system.SerializationFactoryFinder;

public class QueryIterDistinct
extends QueryIterDistinctReduced {
    final DistinctDataNet<Binding> db;

    public QueryIterDistinct(QueryIterator qIter, ExecutionContext context) {
        super(qIter, context);
        ThresholdPolicy policy = ThresholdPolicyFactory.policyFromContext(context.getContext());
        BindingComparator comparator = new BindingComparator(new ArrayList<SortCondition>(), context);
        this.db = BagFactory.newDistinctNet(policy, SerializationFactoryFinder.bindingSerializationFactory(), comparator);
    }

    @Override
    protected void closeSubIterator() {
        this.db.close();
    }

    @Override
    protected void requestSubCancel() {
        this.db.close();
    }

    @Override
    protected boolean isFreshSighting(Binding binding) {
        return this.db.netAdd(binding);
    }
}

