/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.engine.index;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.engine.QueryIterator;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.engine.index.IndexTable;
import java.util.HashSet;
import java.util.Set;

public class SetIndexTable
implements IndexTable {
    private Var var;
    private Set<Node> values = new HashSet<Node>();

    public SetIndexTable(Set<Var> commonVars, QueryIterator data) {
        if (commonVars.size() != 1) {
            throw new IllegalArgumentException("Common Variables must be of size 1");
        }
        this.var = commonVars.iterator().next();
        while (data.hasNext()) {
            Binding binding = (Binding)data.next();
            Node value = binding.get(this.var);
            if (value == null) continue;
            this.values.add(value);
        }
    }

    @Override
    public boolean containsCompatibleWithSharedDomain(Binding binding) {
        Node value = binding.get(this.var);
        if (value == null) {
            return true;
        }
        return this.values.contains(value);
    }
}

