/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.core;

import com.hp.hpl.jena.query.ReadWrite;
import com.hp.hpl.jena.sparql.JenaTransactionException;
import com.hp.hpl.jena.sparql.SystemARQ;
import com.hp.hpl.jena.sparql.core.DatasetGraph;
import com.hp.hpl.jena.sparql.core.DatasetGraphTrackActive;
import com.hp.hpl.jena.sparql.util.Context;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.lib.Sync;

public class DatasetGraphWithLock
extends DatasetGraphTrackActive
implements Sync {
    private final ThreadLocalReadWrite readWrite = new ThreadLocalReadWrite();
    private final ThreadLocalBoolean inTransaction = new ThreadLocalBoolean();
    private DatasetGraph dsg;

    public DatasetGraphWithLock(DatasetGraph dsg) {
        this.dsg = dsg;
    }

    @Override
    protected DatasetGraph get() {
        return this.dsg;
    }

    @Override
    protected void checkActive() {
        if (!this.isInTransaction()) {
            throw new JenaTransactionException("Not in a transaction");
        }
    }

    @Override
    protected void checkNotActive() {
        if (this.isInTransaction()) {
            throw new JenaTransactionException("Currently in a transaction");
        }
    }

    @Override
    public boolean isInTransaction() {
        return (Boolean)this.inTransaction.get();
    }

    protected boolean isTransactionType(ReadWrite readWriteType) {
        return this.readWrite.get() == readWriteType;
    }

    @Override
    protected void _begin(ReadWrite readWrite) {
        this.readWrite.set(readWrite);
        boolean b = this.isTransactionType(ReadWrite.READ);
        this.get().getLock().enterCriticalSection(b);
        this.inTransaction.set(true);
    }

    @Override
    protected void _commit() {
        if (this.isTransactionType(ReadWrite.WRITE)) {
            this.sync();
        }
        this._end();
    }

    @Override
    protected void _abort() {
        if (this.isTransactionType(ReadWrite.WRITE) && !this.abortImplemented()) {
            this._end();
            throw new JenaTransactionException("Can't abort a write lock-transaction");
        }
        this._end();
    }

    protected boolean abortImplemented() {
        return false;
    }

    @Override
    protected void _end() {
        if (this.isInTransaction()) {
            this.get().getLock().leaveCriticalSection();
            this.clearState();
        }
    }

    @Override
    protected void _close() {
        if (this.get() != null) {
            this.get().close();
        }
    }

    private void clearState() {
        this.inTransaction.set(false);
        this.readWrite.set(null);
    }

    @Override
    public Context getContext() {
        return this.get().getContext();
    }

    @Override
    public void sync() {
        SystemARQ.sync(this.get());
    }

    public String toString() {
        try {
            return this.get().toString();
        }
        catch (Exception ex) {
            return Lib.className(this);
        }
    }

    static class ThreadLocalReadWrite
    extends ThreadLocal<ReadWrite> {
        ThreadLocalReadWrite() {
        }

        @Override
        protected ReadWrite initialValue() {
            return null;
        }
    }

    static class ThreadLocalBoolean
    extends ThreadLocal<Boolean> {
        ThreadLocalBoolean() {
        }

        @Override
        protected Boolean initialValue() {
            return false;
        }
    }
}

