/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.geometry;

import com.google.common.geometry.R2Vector;
import com.google.common.geometry.S2Point;

public strictfp final class S2 {
    public static final double M_PI = Math.PI;
    public static final double M_1_PI = 0.3183098861837907;
    public static final double M_PI_2 = 1.5707963267948966;
    public static final double M_PI_4 = 0.7853981633974483;
    public static final double M_SQRT2 = Math.sqrt(2.0);
    public static final double M_E = Math.E;
    public static final int SWAP_MASK = 1;
    public static final int INVERT_MASK = 2;
    private static final int EXPONENT_SHIFT = 52;
    private static final long EXPONENT_MASK = 0x7FF0000000000000L;
    private static final int[] POS_TO_ORIENTATION = new int[]{1, 0, 0, 3};
    private static final int[][] POS_TO_IJ = new int[][]{{0, 1, 3, 2}, {0, 2, 3, 1}, {3, 2, 0, 1}, {3, 1, 0, 2}};
    private static final int[][] IJ_TO_POS = new int[][]{{0, 1, 3, 2}, {0, 3, 1, 2}, {2, 3, 1, 0}, {2, 1, 3, 0}};

    static int exp(double v) {
        if (v == 0.0) {
            return 0;
        }
        long bits = Double.doubleToLongBits(v);
        return (int)((0x7FF0000000000000L & bits) >> 52) - 1022;
    }

    public static int posToOrientation(int position) {
        if (0 > position || position >= 4) {
            throw new IllegalArgumentException(String.format("Position should be in range [0,3] but got %d", position));
        }
        return POS_TO_ORIENTATION[position];
    }

    public static int posToIJ(int orientation, int position) {
        if (0 > orientation || orientation >= 4) {
            throw new IllegalArgumentException(String.format("Orientation should be in range [0,3] but got %d", orientation));
        }
        if (0 > position || position >= 4) {
            throw new IllegalArgumentException(String.format("Position should be in range [0,3] but got %d", position));
        }
        return POS_TO_IJ[orientation][position];
    }

    public static final int ijToPos(int orientation, int ijIndex) {
        if (0 > orientation || orientation >= 4) {
            throw new IllegalArgumentException(String.format("Orientation should be in range [0,3] but got %d", orientation));
        }
        if (0 > ijIndex || ijIndex >= 4) {
            throw new IllegalArgumentException(String.format("Index of ij should be in range [0,3] but got %d", ijIndex));
        }
        return IJ_TO_POS[orientation][ijIndex];
    }

    public static S2Point origin() {
        return new S2Point(0.0, 1.0, 0.0);
    }

    public static boolean isUnitLength(S2Point p) {
        return Math.abs(p.norm2() - 1.0) <= 1.0E-15;
    }

    public static boolean simpleCrossing(S2Point a, S2Point b, S2Point c, S2Point d) {
        S2Point ab = S2Point.crossProd(a, b);
        S2Point cd = S2Point.crossProd(c, d);
        double acb = -ab.dotProd(c);
        double cbd = -cd.dotProd(b);
        double bda = ab.dotProd(d);
        double dac = cd.dotProd(a);
        return acb * cbd > 0.0 && cbd * bda > 0.0 && bda * dac > 0.0;
    }

    public static S2Point robustCrossProd(S2Point a, S2Point b) {
        S2Point x = S2Point.crossProd(S2Point.add(b, a), S2Point.sub(b, a));
        if (!x.equals(new S2Point(0.0, 0.0, 0.0))) {
            return x;
        }
        return S2.ortho(a);
    }

    public static S2Point ortho(S2Point a) {
        return a.ortho();
    }

    static double area(S2Point a, S2Point b, S2Point c) {
        double sc;
        double sb;
        double sa = b.angle(c);
        double s = 0.5 * (sa + (sb = c.angle(a)) + (sc = a.angle(b)));
        if (s >= 3.0E-4) {
            double area;
            double s2 = s * s;
            double dmin = s - Math.max(sa, Math.max(sb, sc));
            if (dmin < 0.01 * s * s2 * s2 && dmin < s * (0.1 * (area = S2.girardArea(a, b, c)))) {
                return area;
            }
        }
        return 4.0 * Math.atan(Math.sqrt(Math.max(0.0, Math.tan(0.5 * s) * Math.tan(0.5 * (s - sa)) * Math.tan(0.5 * (s - sb)) * Math.tan(0.5 * (s - sc)))));
    }

    public static double girardArea(S2Point a, S2Point b, S2Point c) {
        S2Point ab = S2Point.crossProd(a, b);
        S2Point bc = S2Point.crossProd(b, c);
        S2Point ac = S2Point.crossProd(a, c);
        return Math.max(0.0, ab.angle(ac) - ab.angle(bc) + bc.angle(ac));
    }

    public static double signedArea(S2Point a, S2Point b, S2Point c) {
        return S2.area(a, b, c) * (double)S2.robustCCW(a, b, c);
    }

    public static S2Point planarCentroid(S2Point a, S2Point b, S2Point c) {
        return new S2Point((a.x + b.x + c.x) / 3.0, (a.y + b.y + c.y) / 3.0, (a.z + b.z + c.z) / 3.0);
    }

    public static S2Point trueCentroid(S2Point a, S2Point b, S2Point c) {
        double sina = S2Point.crossProd(b, c).norm();
        double sinb = S2Point.crossProd(c, a).norm();
        double sinc = S2Point.crossProd(a, b).norm();
        double ra = sina == 0.0 ? 1.0 : Math.asin(sina) / sina;
        double rb = sinb == 0.0 ? 1.0 : Math.asin(sinb) / sinb;
        double rc = sinc == 0.0 ? 1.0 : Math.asin(sinc) / sinc;
        S2Point x = new S2Point(a.x, b.x, c.x);
        S2Point y = new S2Point(a.y, b.y, c.y);
        S2Point z = new S2Point(a.z, b.z, c.z);
        S2Point r = new S2Point(ra, rb, rc);
        return new S2Point(0.5 * S2Point.crossProd(y, z).dotProd(r), 0.5 * S2Point.crossProd(z, x).dotProd(r), 0.5 * S2Point.crossProd(x, y).dotProd(r));
    }

    public static boolean simpleCCW(S2Point a, S2Point b, S2Point c) {
        return S2Point.crossProd(c, a).dotProd(b) > 0.0;
    }

    public static int robustCCW(S2Point a, S2Point b, S2Point c) {
        return S2.robustCCW(a, b, c, S2Point.crossProd(a, b));
    }

    public static int robustCCW(S2Point a, S2Point b, S2Point c, S2Point aCrossB) {
        double kMinAbsValue = 1.6E-15;
        double det = aCrossB.dotProd(c);
        if (det > 1.6E-15) {
            return 1;
        }
        if (det < -1.6E-15) {
            return -1;
        }
        return S2.expensiveCCW(a, b, c);
    }

    private static int expensiveCCW(S2Point a, S2Point b, S2Point c) {
        if (a.equals(b) || b.equals(c) || c.equals(a)) {
            return 0;
        }
        double sab = a.dotProd(b) > 0.0 ? -1.0 : 1.0;
        double sbc = b.dotProd(c) > 0.0 ? -1.0 : 1.0;
        double sca = c.dotProd(a) > 0.0 ? -1.0 : 1.0;
        S2Point vab = S2Point.add(a, S2Point.mul(b, sab));
        S2Point vbc = S2Point.add(b, S2Point.mul(c, sbc));
        S2Point vca = S2Point.add(c, S2Point.mul(a, sca));
        double dab = vab.norm2();
        double dbc = vbc.norm2();
        double dca = vca.norm2();
        double sign = dca < dbc || dca == dbc && a.lessThan(b) ? (dab < dbc || dab == dbc && a.lessThan(c) ? S2Point.crossProd(vab, vca).dotProd(a) * sab : S2Point.crossProd(vca, vbc).dotProd(c) * sca) : (dab < dca || dab == dca && b.lessThan(c) ? S2Point.crossProd(vbc, vab).dotProd(b) * sbc : S2Point.crossProd(vca, vbc).dotProd(c) * sca);
        if (sign > 0.0) {
            return 1;
        }
        if (sign < 0.0) {
            return -1;
        }
        int ccw = S2.planarOrderedCCW(new R2Vector(a.y, a.z), new R2Vector(b.y, b.z), new R2Vector(c.y, c.z));
        if (ccw == 0 && (ccw = S2.planarOrderedCCW(new R2Vector(a.z, a.x), new R2Vector(b.z, b.x), new R2Vector(c.z, c.x))) == 0) {
            ccw = S2.planarOrderedCCW(new R2Vector(a.x, a.y), new R2Vector(b.x, b.y), new R2Vector(c.x, c.y));
        }
        return ccw;
    }

    public static int planarCCW(R2Vector a, R2Vector b) {
        double db;
        double sab = a.dotProd(b) > 0.0 ? -1.0 : 1.0;
        R2Vector vab = R2Vector.add(a, R2Vector.mul(b, sab));
        double da = a.norm2();
        double sign = da < (db = b.norm2()) || da == db && a.lessThan(b) ? a.crossProd(vab) * sab : vab.crossProd(b);
        if (sign > 0.0) {
            return 1;
        }
        if (sign < 0.0) {
            return -1;
        }
        return 0;
    }

    public static int planarOrderedCCW(R2Vector a, R2Vector b, R2Vector c) {
        int sum = 0;
        sum += S2.planarCCW(a, b);
        sum += S2.planarCCW(b, c);
        if ((sum += S2.planarCCW(c, a)) > 0) {
            return 1;
        }
        if (sum < 0) {
            return -1;
        }
        return 0;
    }

    public static boolean orderedCCW(S2Point a, S2Point b, S2Point c, S2Point o) {
        int sum = 0;
        if (S2.robustCCW(b, o, a) >= 0) {
            ++sum;
        }
        if (S2.robustCCW(c, o, b) >= 0) {
            ++sum;
        }
        if (S2.robustCCW(a, o, c) > 0) {
            ++sum;
        }
        return sum >= 2;
    }

    public static double angle(S2Point a, S2Point b, S2Point c) {
        return S2Point.crossProd(a, b).angle(S2Point.crossProd(c, b));
    }

    public static double turnAngle(S2Point a, S2Point b, S2Point c) {
        double outAngle = S2Point.crossProd(b, a).angle(S2Point.crossProd(c, b));
        return S2.robustCCW(a, b, c) > 0 ? outAngle : -outAngle;
    }

    public static boolean approxEquals(S2Point a, S2Point b, double maxError) {
        return a.angle(b) <= maxError;
    }

    public static boolean approxEquals(S2Point a, S2Point b) {
        return S2.approxEquals(a, b, 1.0E-15);
    }

    public static boolean approxEquals(double a, double b, double maxError) {
        return Math.abs(a - b) <= maxError;
    }

    public static boolean approxEquals(double a, double b) {
        return S2.approxEquals(a, b, 1.0E-15);
    }

    private S2() {
    }

    public strictfp static class Metric {
        private final double deriv;
        private final int dim;

        public Metric(int dim, double deriv) {
            this.deriv = deriv;
            this.dim = dim;
        }

        public double deriv() {
            return this.deriv;
        }

        public double getValue(int level) {
            return StrictMath.scalb(this.deriv, this.dim * (1 - level));
        }

        public int getClosestLevel(double value) {
            return this.getMinLevel(M_SQRT2 * value);
        }

        public int getMinLevel(double value) {
            if (value <= 0.0) {
                return 30;
            }
            int exponent = S2.exp(value / ((double)(1 << this.dim) * this.deriv));
            int level = Math.max(0, Math.min(30, -(exponent - 1 >> this.dim - 1)));
            return level;
        }

        public int getMaxLevel(double value) {
            if (value <= 0.0) {
                return 30;
            }
            int exponent = S2.exp((double)(1 << this.dim) * this.deriv / value);
            int level = Math.max(0, Math.min(30, exponent - 1 >> this.dim - 1));
            return level;
        }
    }
}

