/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.randomizedtesting;

import com.carrotsearch.randomizedtesting.FilterExpressionParser;
import com.carrotsearch.randomizedtesting.RandomizedRunner;
import com.carrotsearch.randomizedtesting.RandomizedTest;
import com.carrotsearch.randomizedtesting.ReproduceErrorMessageBuilder;
import com.carrotsearch.randomizedtesting.SysGlobals;
import com.carrotsearch.randomizedtesting.annotations.TestGroup;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public final class GroupEvaluator {
    private final HashMap<Class<? extends Annotation>, TestGroupInfo> testGroups;
    private final FilterExpressionParser.Node filter;
    private String filterExpression;

    GroupEvaluator(List<RandomizedRunner.TestCandidate> testCandidates) {
        this.testGroups = this.collectGroups(testCandidates);
        this.filterExpression = System.getProperty(SysGlobals.SYSPROP_TESTFILTER());
        if (this.filterExpression != null && this.filterExpression.trim().isEmpty()) {
            this.filterExpression = null;
        }
        this.filter = this.filterExpression != null ? new FilterExpressionParser().parse(this.filterExpression) : null;
    }

    private HashMap<Class<? extends Annotation>, TestGroupInfo> collectGroups(List<RandomizedRunner.TestCandidate> testCandidates) {
        HashMap<Class<? extends Annotation>, TestGroupInfo> groups = new HashMap<Class<? extends Annotation>, TestGroupInfo>();
        HashSet clazzes = new HashSet();
        HashSet<Annotation> annotations = new HashSet<Annotation>();
        for (RandomizedRunner.TestCandidate c : testCandidates) {
            Class<?> testClass = c.getTestClass();
            if (!clazzes.contains(testClass)) {
                clazzes.add(testClass);
                annotations.addAll(Arrays.asList(testClass.getAnnotations()));
            }
            annotations.addAll(Arrays.asList(c.method.getAnnotations()));
        }
        for (Annotation ann : annotations) {
            Class<? extends Annotation> annType = ann.annotationType();
            if (groups.containsKey(ann) || !annType.isAnnotationPresent(TestGroup.class)) continue;
            groups.put(annType, new TestGroupInfo(annType));
        }
        return groups;
    }

    void appendGroupFilteringOptions(ReproduceErrorMessageBuilder builder) {
        for (TestGroupInfo info : this.testGroups.values()) {
            if (System.getProperty(info.sysProperty) == null) continue;
            builder.appendOpt(info.sysProperty, System.getProperty(info.sysProperty));
        }
        if (this.hasFilteringExpression()) {
            builder.appendOpt(SysGlobals.SYSPROP_TESTFILTER(), this.filterExpression);
        }
    }

    boolean hasFilteringExpression() {
        return this.filterExpression != null;
    }

    public String getIgnoreReason(AnnotatedElement ... elements) {
        final HashMap<String, Annotation> annotations = new HashMap<String, Annotation>();
        for (AnnotatedElement element : elements) {
            for (Annotation ann : element.getAnnotations()) {
                Class<? extends Annotation> annType = ann.annotationType();
                if (!annType.isAnnotationPresent(TestGroup.class)) continue;
                if (!this.testGroups.containsKey(annType)) {
                    this.testGroups.put(annType, new TestGroupInfo(annType));
                }
                annotations.put(this.testGroups.get(annType).name, ann);
            }
        }
        String defaultState = null;
        for (Annotation ann : annotations.values()) {
            TestGroupInfo g = this.testGroups.get(ann.annotationType());
            if (g.enabled) continue;
            defaultState = "'" + g.name + "' test group is disabled (" + this.toString(ann) + ")";
            break;
        }
        if (this.hasFilteringExpression()) {
            final String defaultStateCopy = defaultState;
            boolean enabled = this.filter.evaluate(new FilterExpressionParser.IContext(){

                @Override
                public boolean defaultValue() {
                    return defaultStateCopy == null;
                }

                @Override
                public boolean hasGroup(String value) {
                    if (value.startsWith("@")) {
                        value = value.substring(1);
                    }
                    for (Annotation ann : annotations.values()) {
                        if (!value.equalsIgnoreCase(((TestGroupInfo)((GroupEvaluator)GroupEvaluator.this).testGroups.get(ann.annotationType())).name)) continue;
                        return true;
                    }
                    return false;
                }
            });
            return enabled ? null : "Test filter condition: " + this.filterExpression;
        }
        return defaultState;
    }

    private String toString(Annotation ann) {
        if (ann == null) {
            return "@null?";
        }
        return ann.toString().replace(ann.annotationType().getName(), ann.annotationType().getSimpleName());
    }

    public boolean isGroupEnabled(Class<? extends Annotation> testGroupAnnotation) {
        if (!this.testGroups.containsKey(testGroupAnnotation)) {
            if (!testGroupAnnotation.isAnnotationPresent(TestGroup.class)) {
                throw new IllegalArgumentException("This annotation is not marked with @" + TestGroup.class.getName() + ": " + testGroupAnnotation.getName());
            }
            this.testGroups.put(testGroupAnnotation, new TestGroupInfo(testGroupAnnotation));
        }
        return this.testGroups.get(testGroupAnnotation).enabled;
    }

    private static class TestGroupInfo {
        final TestGroup group;
        final String name;
        final String sysProperty;
        final boolean enabled;

        TestGroupInfo(Class<? extends Annotation> annType) {
            boolean enabled;
            this.group = annType.getAnnotation(TestGroup.class);
            this.name = TestGroup.Utilities.getGroupName(annType);
            this.sysProperty = TestGroup.Utilities.getSysProperty(annType);
            try {
                enabled = RandomizedTest.systemPropertyAsBoolean(this.sysProperty, this.group.enabled());
            }
            catch (IllegalArgumentException e) {
                enabled = false;
            }
            this.enabled = enabled;
        }
    }
}

