/*
 * Decompiled with CFR 0.152.
 */
package edu.ucsb.nceas.ezid;

import edu.ucsb.nceas.ezid.EZIDException;
import edu.ucsb.nceas.ezid.EZIDService;
import edu.ucsb.nceas.ezid.EZIDServiceRequest;
import java.util.HashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EZIDClient {
    private String USERNAME = "apitest";
    private String PASSWORD = "apitest";
    private EZIDService ezid = null;
    private ExecutorService executor = null;
    protected static Log log = LogFactory.getLog(EZIDClient.class);

    public EZIDClient(String baseURL) {
        this.ezid = new EZIDService(baseURL);
        this.startExecutorLoop();
    }

    public EZIDClient() {
        this(null);
    }

    public boolean login(String username, String password) {
        boolean loginSuccess = false;
        this.USERNAME = username;
        this.PASSWORD = password;
        try {
            this.ezid.login(this.USERNAME, this.PASSWORD);
            loginSuccess = true;
        }
        catch (EZIDException e) {
            loginSuccess = false;
        }
        return loginSuccess;
    }

    public void create(String identifier, HashMap<String, String> metadata) throws InterruptedException {
        EZIDServiceRequest request = new EZIDServiceRequest(this.ezid, 1, identifier, metadata);
        this.executor.execute(request);
    }

    public void delete(String identifier) throws InterruptedException {
        EZIDServiceRequest request = new EZIDServiceRequest(this.ezid, 3, identifier);
        this.executor.execute(request);
    }

    public void setMetadata(String identifier, HashMap<String, String> metadata) throws InterruptedException {
        EZIDServiceRequest request = new EZIDServiceRequest(this.ezid, 2, identifier, metadata);
        this.executor.execute(request);
    }

    public void createOrUpdate(String identifier, HashMap<String, String> metadata) throws InterruptedException {
        EZIDServiceRequest request = new EZIDServiceRequest(this.ezid, 4, identifier, metadata);
        this.executor.execute(request);
    }

    public String mintIdentifier(String shoulder, HashMap<String, String> metadata) throws EZIDException {
        String identifier = this.ezid.mintIdentifier(shoulder, metadata);
        return identifier;
    }

    private void startExecutorLoop() {
        Runtime runtime = Runtime.getRuntime();
        int numCores = runtime.availableProcessors();
        log.debug((Object)("Number of cores available: " + numCores));
        this.executor = Executors.newFixedThreadPool(numCores);
    }

    public void shutdown() {
        log.debug((Object)"Shutting down executor...");
        this.executor.shutdown();
        while (!this.executor.isTerminated()) {
        }
    }
}

