/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.parser;

import java.util.HashMap;
import java.util.TreeSet;
import org.ecoinformatics.datamanager.database.DelimitedReader;
import org.ecoinformatics.datamanager.download.DownloadHandler;
import org.ecoinformatics.datamanager.download.EcogridEndPointInterface;
import org.ecoinformatics.datamanager.download.GZipDataHandler;
import org.ecoinformatics.datamanager.download.TarDataHandler;
import org.ecoinformatics.datamanager.download.ZipDataHandler;
import org.ecoinformatics.datamanager.parser.Attribute;
import org.ecoinformatics.datamanager.parser.AttributeList;
import org.ecoinformatics.datamanager.parser.Constraint;
import org.ecoinformatics.datamanager.parser.DataObjectDescription;
import org.ecoinformatics.datamanager.parser.TextComplexDataFormat;
import org.ecoinformatics.datamanager.quality.EntityReport;
import org.ecoinformatics.datamanager.quality.QualityCheck;
import org.ecoinformatics.datamanager.quality.QualityReport;

public class Entity
extends DataObjectDescription {
    public static String ROWMAJOR = "ROWMAJOR";
    public static String COLUMNMAJOR = "COLUMNMAJOR";
    public static String ZIP = "zip";
    public static String TAR = "application/x-tar";
    public static String GZIP = "gzip";
    public static String SPATIALRASTERENTITY = "SPATIALRASTERENTITY";
    public static String SPATIALVECTORENTITY = "SPATIALVECTORENTITY";
    public static String STOREDPROCEDUREENTITY = "STOREDPROCEDUREENTITY";
    public static String VIEWENTITY = "VIEWENTITY";
    public static String OTHERENTITY = "OTHERENTITY";
    private AttributeList attributeList = new AttributeList();
    private Boolean caseSensitive;
    private String orientation;
    private int numRecords = 0;
    private Integer numHeaderLines = null;
    private Integer numFooterLines = null;
    private String fieldDelimiter = null;
    private String recordDelimiter = null;
    private String metadataRecordDelimiter = null;
    private boolean multiple = false;
    private String fileName = "";
    private String url;
    private String urlFunction;
    private String urlContentType;
    private String format;
    private String dbTableName;
    private String compressionMethod = null;
    private boolean externallyDefinedFormat = false;
    private String firstKilobyte = null;
    private boolean hasDistributionOnline = false;
    private boolean hasDistributionOffline = false;
    private boolean hasDistributionInline = false;
    private boolean isImageEntity = false;
    private boolean isOtherEntity = false;
    private boolean hasGZipDataFile = false;
    private boolean hasZipDataFile = false;
    private boolean hasTarDataFile = false;
    private boolean simpleDelimited = true;
    private boolean textFixed = false;
    private TextComplexDataFormat[] dataFormatArray = null;
    private String physicalLineDelimiter = null;
    private boolean collapseDelimiters = false;
    private String packageId = null;
    private String quoteCharacter = null;
    private String literalCharacter = null;
    private EntityReport entityReport = null;
    private String entityAccessXML = null;

    public Entity(String id, String name, String description, Boolean caseSensitive, String orientation, int numRecords) {
        this(id, name, description, null);
        this.attributeList = new AttributeList();
        if (caseSensitive != null) {
            this.caseSensitive = caseSensitive;
        }
        if (orientation != null) {
            this.orientation = orientation;
        }
        this.numRecords = numRecords;
    }

    public Entity(String id, String name, String description, AttributeList attributeList) {
        super(id, name, description);
        this.attributeList = attributeList;
        this.caseSensitive = new Boolean(false);
        this.orientation = "";
        this.entityReport = new EntityReport(this);
        this.checkEntityName(name);
        this.checkEntityDescription(description);
    }

    public void add(Attribute a) {
        this.attributeList.add(a);
    }

    public void addQualityCheck(QualityCheck qualityCheck) {
        if (this.entityReport != null) {
            this.entityReport.addQualityCheck(qualityCheck);
            System.err.printf("  Entity: %s  Quality Check: %23s  Status: %5s\n", this, qualityCheck.getIdentifier(), qualityCheck.getStatus());
        }
    }

    public Attribute[] getAttributes() {
        Attribute[] attrList = this.attributeList.getAttributes();
        return attrList;
    }

    public Boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public String getFirstKilobyte() {
        return this.firstKilobyte;
    }

    public String getOrientation() {
        return this.orientation;
    }

    public int getNumRecords() {
        return this.numRecords;
    }

    public void setNumHeaderLines(Integer numHeaderLines) {
        this.numHeaderLines = numHeaderLines;
        String identifier = "numHeaderLinesPresent";
        QualityCheck qualityCheckTemplate = QualityReport.getQualityCheckTemplate(identifier);
        QualityCheck qualityCheck = new QualityCheck(identifier, qualityCheckTemplate);
        if (QualityCheck.shouldRunQualityCheck(this, qualityCheck)) {
            boolean hasNumHeaderLines = numHeaderLines != null;
            String found = null;
            if (hasNumHeaderLines) {
                found = String.format("'numHeaderLines' element: %s", numHeaderLines.toString());
                qualityCheck.setExplanation("");
                qualityCheck.setSuggestion("");
            } else {
                found = "No 'numHeaderLines' element found";
            }
            qualityCheck.setFound(found);
            this.addQualityCheck(qualityCheck);
        }
    }

    public void setNumFooterLines(Integer numFooterLines) {
        this.numFooterLines = numFooterLines;
        String identifier = "numFooterLinesPresent";
        QualityCheck qualityCheckTemplate = QualityReport.getQualityCheckTemplate(identifier);
        QualityCheck qualityCheck = new QualityCheck(identifier, qualityCheckTemplate);
        if (QualityCheck.shouldRunQualityCheck(this, qualityCheck)) {
            boolean hasNumFooterLines = numFooterLines != null;
            String found = null;
            if (hasNumFooterLines) {
                found = String.format("'numFooterLines' element: %s", numFooterLines.toString());
                qualityCheck.setExplanation("");
                qualityCheck.setSuggestion("");
            } else {
                found = "No 'numFooterLines' element found";
            }
            qualityCheck.setFound(found);
            this.addQualityCheck(qualityCheck);
        }
    }

    public int getNumHeaderLines() {
        if (this.numHeaderLines == null) {
            return 0;
        }
        return this.numHeaderLines;
    }

    public int getNumFooterLines() {
        if (this.numFooterLines == null) {
            return 0;
        }
        return this.numFooterLines;
    }

    public void setFieldDelimiter(String delimiter) {
        this.fieldDelimiter = delimiter;
        String fieldDelimiterIdentifier = "fieldDelimiterValid";
        QualityCheck fieldDelimiterTemplate = QualityReport.getQualityCheckTemplate(fieldDelimiterIdentifier);
        QualityCheck fieldDelimiterQualityCheck = new QualityCheck(fieldDelimiterIdentifier, fieldDelimiterTemplate);
        if (QualityCheck.shouldRunQualityCheck(this, fieldDelimiterQualityCheck)) {
            boolean isValidDelimiter = true;
            String found = delimiter;
            String explanation = fieldDelimiterQualityCheck.getExplanation();
            if (!this.isTextFixed()) {
                if (delimiter == null || delimiter.equals("")) {
                    isValidDelimiter = false;
                    explanation = explanation + " The fieldDelimiter value is null or empty string.";
                } else {
                    String unescapedDelimiter;
                    int delimiterLength = delimiter.length();
                    if (delimiterLength > 1 && delimiter.equals(unescapedDelimiter = DelimitedReader.unescapeDelimiter(delimiter))) {
                        isValidDelimiter = false;
                        explanation = explanation + " The specified delimiter, '" + delimiter + "', is not a recognized fieldDelimiter value.";
                    }
                }
            }
            fieldDelimiterQualityCheck.setFound(found);
            if (this.isTextFixed()) {
                explanation = "A fieldDelimiter value is not used when describing fixed text entities";
                fieldDelimiterQualityCheck.setStatus(QualityCheck.Status.info);
                fieldDelimiterQualityCheck.setSuggestion("");
            } else if (isValidDelimiter) {
                explanation = "A valid fieldDelimiter value was found";
                fieldDelimiterQualityCheck.setStatus(QualityCheck.Status.valid);
                fieldDelimiterQualityCheck.setSuggestion("");
            } else if (this.getIsImageEntity() || this.isOtherEntity() || this.isExternallyDefinedFormat()) {
                explanation = "A fieldDelimiter value is not checked for binary entities or entities with an externally defined format";
                fieldDelimiterQualityCheck.setStatus(QualityCheck.Status.info);
                fieldDelimiterQualityCheck.setSuggestion("");
            } else {
                fieldDelimiterQualityCheck.setFailedStatus();
            }
            fieldDelimiterQualityCheck.setExplanation(explanation);
            this.addQualityCheck(fieldDelimiterQualityCheck);
        }
    }

    public String getFieldDelimiter() {
        return this.fieldDelimiter;
    }

    public String getQuoteCharacter() {
        return this.quoteCharacter;
    }

    public void setQuoteCharacter(String quoteCharacter) {
        this.quoteCharacter = quoteCharacter;
    }

    public String getLiteralCharacter() {
        return this.literalCharacter;
    }

    public void setLiteralCharacter(String literalCharacter) {
        this.literalCharacter = literalCharacter;
    }

    public void setRecordDelimiter(String delim) {
        this.recordDelimiter = delim;
    }

    public String getMetadataRecordDelimiter() {
        return this.metadataRecordDelimiter;
    }

    public void setMetadataRecordDelimiter(String metadataRecordDelimiter) {
        this.metadataRecordDelimiter = metadataRecordDelimiter;
        this.checkRecordDelimiter(metadataRecordDelimiter);
    }

    private void checkEntityDescription(String description) {
        String qualityCheckIdentifier = "entityDescriptionPresent";
        QualityCheck qualityCheckTemplate = QualityReport.getQualityCheckTemplate(qualityCheckIdentifier);
        QualityCheck qualityCheck = new QualityCheck(qualityCheckIdentifier, qualityCheckTemplate);
        if (QualityCheck.shouldRunQualityCheck(this, qualityCheck)) {
            Boolean hasEntityDescription = description != null && description.length() > 0;
            qualityCheck.setFound(hasEntityDescription.toString());
            if (hasEntityDescription.booleanValue()) {
                qualityCheck.setStatus(QualityCheck.Status.valid);
            } else {
                qualityCheck.setFailedStatus();
            }
            this.addQualityCheck(qualityCheck);
        }
    }

    private void checkEntityName(String entityName) {
        int ENTITY_NAME_MAX_LENGTH = 100;
        String entityNameIdentifier = "entityNameLength";
        QualityCheck entityNameTemplate = QualityReport.getQualityCheckTemplate(entityNameIdentifier);
        QualityCheck entityNameQualityCheck = new QualityCheck(entityNameIdentifier, entityNameTemplate);
        if (QualityCheck.shouldRunQualityCheck(this, entityNameQualityCheck)) {
            boolean isValidLength = false;
            int nameLength = entityName == null ? 0 : entityName.length();
            Integer found = new Integer(nameLength);
            if (found <= 100) {
                isValidLength = true;
            }
            entityNameQualityCheck.setFound(found.toString());
            if (isValidLength) {
                entityNameQualityCheck.setStatus(QualityCheck.Status.valid);
            } else {
                entityNameQualityCheck.setFailedStatus();
            }
            this.addQualityCheck(entityNameQualityCheck);
        }
    }

    public void checkRecordDelimiter(String metadataValue) {
        String recordDelimiterIdentifier = "recordDelimiterPresent";
        QualityCheck recordDelimiterTemplate = QualityReport.getQualityCheckTemplate(recordDelimiterIdentifier);
        QualityCheck recordDelimiterQualityCheck = new QualityCheck(recordDelimiterIdentifier, recordDelimiterTemplate);
        if (QualityCheck.shouldRunQualityCheck(this, recordDelimiterQualityCheck)) {
            boolean isValidDelimiter = true;
            String found = metadataValue;
            String explanation = recordDelimiterQualityCheck.getExplanation();
            if (metadataValue == null || metadataValue.equals("")) {
                isValidDelimiter = false;
                explanation = explanation + " The recordDelimiter value is null or an empty string.";
            } else if (!this.isSuggestedRecordDelimiter(metadataValue)) {
                isValidDelimiter = false;
                explanation = explanation + " The specified recordDelimiter, '" + metadataValue + "', is not in the list of suggested recordDelimiter values.";
            }
            recordDelimiterQualityCheck.setFound(found);
            if (isValidDelimiter) {
                explanation = "A valid recordDelimiter value was found";
                recordDelimiterQualityCheck.setStatus(QualityCheck.Status.valid);
                recordDelimiterQualityCheck.setSuggestion("");
            } else if (this.getIsImageEntity() || this.isOtherEntity() || this.isExternallyDefinedFormat()) {
                explanation = "A recordDelimiter value is not checked for binary entities or entities with an externally defined format";
                recordDelimiterQualityCheck.setStatus(QualityCheck.Status.info);
                recordDelimiterQualityCheck.setSuggestion("");
            } else {
                recordDelimiterQualityCheck.setFailedStatus();
            }
            recordDelimiterQualityCheck.setExplanation(explanation);
            this.addQualityCheck(recordDelimiterQualityCheck);
        }
    }

    public boolean isSuggestedRecordDelimiter(String recordDelimiter) {
        boolean isSuggested = false;
        if (recordDelimiter != null) {
            TreeSet<String> treeSet = this.suggestedRecordDelimiters();
            isSuggested = treeSet.contains(recordDelimiter);
        }
        return isSuggested;
    }

    private TreeSet<String> suggestedRecordDelimiters() {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("\\n");
        treeSet.add("\\r");
        treeSet.add("\\r\\n");
        treeSet.add("#x0A");
        treeSet.add("#x0D");
        treeSet.add("#x0D#x0A");
        return treeSet;
    }

    public String getRecordDelimiter() {
        return this.recordDelimiter;
    }

    public void setURL(String url) {
        this.url = url;
    }

    public void setUrlContentType(String urlContentType) {
        this.urlContentType = urlContentType;
    }

    public void setURLFunction(String urlFunction) {
        this.urlFunction = urlFunction;
    }

    public String getURL() {
        return this.url;
    }

    public String getUrlContentType() {
        return this.urlContentType;
    }

    public String getUrlFunction() {
        return this.urlFunction;
    }

    public void setDataFormat(String format) {
        this.format = format;
    }

    public String getDataFormat() {
        return this.format;
    }

    public String[] getDBFieldNames() {
        if (this.attributeList != null) {
            return this.attributeList.getDBFieldNames();
        }
        return null;
    }

    public void setDBTableName(String dbTableName) {
        this.dbTableName = dbTableName;
    }

    public String getDBTableName() {
        return this.dbTableName;
    }

    public boolean getCollapseDelimiters() {
        return this.collapseDelimiters;
    }

    public void setCollapseDelimiters(boolean collapseDelimiters) {
        this.collapseDelimiters = collapseDelimiters;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setMultiple() {
        this.multiple = true;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public String getMappedName() {
        return this.dbTableName;
    }

    public Attribute[] getFields() {
        return this.attributeList.getAttributes();
    }

    public Constraint getPrimaryKey() {
        return null;
    }

    public String getCompressionMethod() {
        return this.compressionMethod;
    }

    public void setCompressionMethod(String compressionMethod) {
        this.compressionMethod = compressionMethod;
    }

    public boolean hasDistributionOnline() {
        return this.hasDistributionOnline;
    }

    public void setHasDistributionOnline(boolean distributionOnline) {
        this.hasDistributionOnline = distributionOnline;
    }

    public boolean hasDistributionOffline() {
        return this.hasDistributionOffline;
    }

    public void setHasDistributionOffline(boolean distributionOffline) {
        this.hasDistributionOffline = distributionOffline;
    }

    public boolean hasDistributionInline() {
        return this.hasDistributionInline;
    }

    public void setHasDistributionInline(boolean distributionInline) {
        this.hasDistributionInline = distributionInline;
    }

    public boolean getIsImageEntity() {
        return this.isImageEntity;
    }

    public void setIsImageEntity(boolean isImageEntity) {
        this.isImageEntity = isImageEntity;
    }

    public boolean isOtherEntity() {
        return this.isOtherEntity;
    }

    public void setIsOtherEntity(boolean isOtherEntity) {
        this.isOtherEntity = isOtherEntity;
    }

    public boolean getHasZipDataFile() {
        return this.hasZipDataFile;
    }

    public void setHasZipDataFile(boolean isZipDataFile) {
        this.hasZipDataFile = isZipDataFile;
    }

    public boolean getHasGZipDataFile() {
        return this.hasGZipDataFile;
    }

    public void setHasGZipDataFile(boolean hasGZipDataFile) {
        this.hasGZipDataFile = hasGZipDataFile;
    }

    public boolean getHasTarDataFile() {
        return this.hasTarDataFile;
    }

    public void setHasTarDataFile(boolean hasTarDataFile) {
        this.hasTarDataFile = hasTarDataFile;
    }

    public String getEntityAccessXML() {
        return this.entityAccessXML;
    }

    public void setEntityAccessXML(String xmlString) {
        this.entityAccessXML = xmlString;
    }

    public String getEntityIdentifier() {
        return this.url;
    }

    public EntityReport getEntityReport() {
        return this.entityReport;
    }

    public void setEntityIdentifier(String url) {
        this.url = url;
    }

    public void setFirstKilobyte(String firstKilobyte) {
        QualityCheck urlDataTemplate;
        String urlDataIdentifier;
        QualityCheck urlDataQualityCheck;
        this.firstKilobyte = firstKilobyte;
        String displayDownloadIdentifier = "displayDownloadData";
        QualityCheck displayDownloadTemplate = QualityReport.getQualityCheckTemplate(displayDownloadIdentifier);
        QualityCheck displayDownloadQualityCheck = new QualityCheck(displayDownloadIdentifier, displayDownloadTemplate);
        if (QualityCheck.shouldRunQualityCheck(this, displayDownloadQualityCheck)) {
            String foundString = null;
            foundString = this.isBinaryData() ? "*** BINARY DATA ***" : "<![CDATA[\n" + firstKilobyte.trim() + "]]>";
            displayDownloadQualityCheck.setFound(foundString);
            displayDownloadQualityCheck.setStatus(QualityCheck.Status.info);
            this.addQualityCheck(displayDownloadQualityCheck);
        }
        if (QualityCheck.shouldRunQualityCheck(this, urlDataQualityCheck = new QualityCheck(urlDataIdentifier = "urlReturnsData", urlDataTemplate = QualityReport.getQualityCheckTemplate(urlDataIdentifier)))) {
            boolean isHTML = this.isHTML(firstKilobyte);
            if (isHTML) {
                String found = "The download URL for this entity returns HTML";
                urlDataQualityCheck.setFound(found);
                String explanation = "Either an HTML declaration string or an 'html' element was detected in the data";
                urlDataQualityCheck.setExplanation(explanation);
                String suggestion = "Specify function=\"information\" in the 'url' element when the URL links to an HTML page";
                urlDataQualityCheck.setSuggestion(suggestion);
                urlDataQualityCheck.setFailedStatus();
            } else {
                urlDataQualityCheck.setFound("true");
                urlDataQualityCheck.setStatus(QualityCheck.Status.valid);
                urlDataQualityCheck.setSuggestion("");
            }
            this.addQualityCheck(urlDataQualityCheck);
        }
    }

    private boolean isHTML(String sampleData) {
        boolean isHTML = false;
        if (sampleData != null) {
            String htmlDeclaration = "<!doctype html";
            String htmlElement1 = "<html ";
            String htmlElement2 = "<html>";
            String sampleDataLowerCase = sampleData.toLowerCase();
            if (this.urlContentType != null && this.urlContentType.startsWith("text/html")) {
                isHTML = true;
            } else if (sampleDataLowerCase.contains(htmlDeclaration)) {
                isHTML = true;
            } else if (sampleDataLowerCase.contains(htmlElement1) || sampleDataLowerCase.contains(htmlElement2)) {
                isHTML = true;
            }
        }
        return isHTML;
    }

    public boolean isBinaryData() {
        boolean isBinary = false;
        if (this.isBinaryUrlContentType()) {
            isBinary = true;
        }
        if (this.hasGZipDataFile || this.hasTarDataFile || this.hasZipDataFile || this.isImageEntity || this.isOtherEntity) {
            isBinary = true;
        }
        return isBinary;
    }

    private boolean isBinaryUrlContentType() {
        boolean isBinary = true;
        if (this.urlContentType != null) {
            if (this.urlContentType.startsWith("text/") || this.urlContentType.equals("application/xml")) {
                isBinary = false;
            }
        } else {
            isBinary = false;
        }
        return isBinary;
    }

    public boolean isExternallyDefinedFormat() {
        return this.externallyDefinedFormat;
    }

    public boolean isSimpleDelimited() {
        return this.simpleDelimited;
    }

    public boolean isTextFixed() {
        return this.textFixed;
    }

    public void setExternallyDefinedFormat(boolean externallyDefinedFormat) {
        this.externallyDefinedFormat = externallyDefinedFormat;
    }

    public void setSimpleDelimited(boolean simpleDelimited) {
        this.simpleDelimited = simpleDelimited;
    }

    public void setTextFixed(boolean textFixed) {
        this.textFixed = textFixed;
    }

    public TextComplexDataFormat[] getDataFormatArray() {
        return this.dataFormatArray;
    }

    public void setDataFormatArray(TextComplexDataFormat[] dataFormatArray) {
        this.dataFormatArray = dataFormatArray;
    }

    public String getPhysicalLineDelimiter() {
        return this.physicalLineDelimiter;
    }

    public void setPhysicalLineDelimiter(String physicalLineDelimiter) {
        this.physicalLineDelimiter = physicalLineDelimiter;
    }

    public void setAttributeList(AttributeList list) {
        this.attributeList = list;
        String qualityCheckIdentifier = "attributeNamesUnique";
        QualityCheck qualityCheckTemplate = QualityReport.getQualityCheckTemplate(qualityCheckIdentifier);
        QualityCheck qualityCheck = new QualityCheck(qualityCheckIdentifier, qualityCheckTemplate);
        if (QualityCheck.shouldRunQualityCheck(this, qualityCheck)) {
            String duplicateAttributeNames = this.duplicateAttributeNames(list);
            if (duplicateAttributeNames != null) {
                String found = String.format("Duplicate attributeName values: %s", duplicateAttributeNames);
                qualityCheck.setFound(found);
                qualityCheck.setFailedStatus();
            } else {
                qualityCheck.setFound("true");
                qualityCheck.setStatus(QualityCheck.Status.valid);
                qualityCheck.setSuggestion("");
            }
            this.addQualityCheck(qualityCheck);
        }
    }

    private String duplicateAttributeNames(AttributeList attributeList) {
        String[] attributeNames;
        String duplicates = null;
        if (attributeList != null && (attributeNames = attributeList.getNames()) != null) {
            Integer value;
            StringBuffer stringBuffer = new StringBuffer("");
            HashMap<String, Integer> duplicatesMap = new HashMap<String, Integer>();
            for (int i = 0; i < attributeNames.length; ++i) {
                String attributeName = attributeNames[i];
                value = (Integer)duplicatesMap.get(attributeName);
                if (value == null) {
                    duplicatesMap.put(attributeName, 1);
                    continue;
                }
                value = value + 1;
                duplicatesMap.put(attributeName, value);
            }
            for (String attributeName : duplicatesMap.keySet()) {
                value = (Integer)duplicatesMap.get(attributeName);
                if (value <= 1) continue;
                stringBuffer.append(String.format("'%s', ", attributeName));
            }
            duplicates = stringBuffer.toString();
            duplicates = duplicates.length() > 2 ? duplicates.substring(0, duplicates.length() - 2) : null;
        }
        return duplicates;
    }

    public AttributeList getAttributeList() {
        return this.attributeList;
    }

    public void setPackageId(String packageId) {
        this.packageId = packageId;
    }

    public String getPackageId() {
        return this.packageId;
    }

    public DownloadHandler getDownloadHandler(EcogridEndPointInterface endPointInfo) {
        boolean preserveFormat = false;
        return this.getDownloadHandler(endPointInfo, preserveFormat);
    }

    public DownloadHandler getDownloadHandler(EcogridEndPointInterface endPointInfo, boolean preserveFormat) {
        DownloadHandler handler = null;
        if (!preserveFormat) {
            if (this.hasZipDataFile) {
                handler = ZipDataHandler.getZipHandlerInstance(this, this.url, endPointInfo);
            } else if (this.hasGZipDataFile) {
                handler = GZipDataHandler.getGZipHandlerInstance(this, this.url, endPointInfo);
            } else if (this.hasTarDataFile) {
                handler = TarDataHandler.getTarHandlerInstance(this, this.url, endPointInfo);
            }
        }
        if (handler == null) {
            handler = DownloadHandler.getInstance(this, this.url, endPointInfo);
        }
        return handler;
    }
}

