/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core;

import java.io.IOException;
import org.rrd4j.ConsolFun;
import org.rrd4j.core.ArcDef;
import org.rrd4j.core.ArcState;
import org.rrd4j.core.DataImporter;
import org.rrd4j.core.FetchData;
import org.rrd4j.core.FetchRequest;
import org.rrd4j.core.Robin;
import org.rrd4j.core.RobinArray;
import org.rrd4j.core.RobinMatrix;
import org.rrd4j.core.RrdAllocator;
import org.rrd4j.core.RrdBackend;
import org.rrd4j.core.RrdDb;
import org.rrd4j.core.RrdDouble;
import org.rrd4j.core.RrdDoubleMatrix;
import org.rrd4j.core.RrdEnum;
import org.rrd4j.core.RrdInt;
import org.rrd4j.core.RrdUpdater;
import org.rrd4j.core.Util;
import org.rrd4j.core.XmlWriter;

public class Archive
implements RrdUpdater<Archive> {
    private final RrdDb parentDb;
    private final RrdEnum<Archive, ConsolFun> consolFun;
    protected final RrdDouble<Archive> xff;
    protected final RrdInt<Archive> steps;
    protected final RrdInt<Archive> rows;
    private final Robin[] robins;
    private final ArcState[] states;

    Archive(RrdDb parentDb, ArcDef arcDef) throws IOException {
        boolean shouldInitialize;
        this.parentDb = parentDb;
        this.consolFun = new RrdEnum<Archive, ConsolFun>(this, false, ConsolFun.class);
        this.xff = new RrdDouble<Archive>(this);
        this.steps = new RrdInt<Archive>(this, true);
        this.rows = new RrdInt<Archive>(this, true);
        boolean bl = shouldInitialize = arcDef != null;
        if (shouldInitialize) {
            this.consolFun.set(arcDef.getConsolFun());
            this.xff.set(arcDef.getXff());
            this.steps.set(arcDef.getSteps());
            this.rows.set(arcDef.getRows());
        }
        int n = parentDb.getHeader().getDsCount();
        int numRows = this.rows.get();
        this.states = new ArcState[n];
        int version = parentDb.getHeader().getVersion();
        if (version == 1) {
            this.robins = new RobinArray[n];
            for (int i = 0; i < n; ++i) {
                this.states[i] = new ArcState(this, shouldInitialize);
                this.robins[i] = new RobinArray(this, numRows, shouldInitialize);
            }
        } else {
            RrdInt[] pointers = new RrdInt[n];
            this.robins = new RobinMatrix[n];
            for (int i = 0; i < n; ++i) {
                pointers[i] = new RrdInt<Archive>(this);
                if (shouldInitialize) {
                    pointers[i].set(0);
                }
                this.states[i] = new ArcState(this, shouldInitialize);
            }
            RrdDoubleMatrix<Archive> values = new RrdDoubleMatrix<Archive>(this, numRows, n, shouldInitialize);
            for (int i = 0; i < n; ++i) {
                this.robins[i] = new RobinMatrix(this, values, pointers[i], i);
            }
        }
    }

    Archive(RrdDb parentDb, DataImporter reader, int arcIndex) throws IOException {
        this(parentDb, new ArcDef(reader.getConsolFun(arcIndex), reader.getXff(arcIndex), reader.getSteps(arcIndex), reader.getRows(arcIndex)));
        int n = parentDb.getHeader().getDsCount();
        for (int i = 0; i < n; ++i) {
            this.states[i].setAccumValue(reader.getStateAccumValue(arcIndex, i));
            this.states[i].setNanSteps(reader.getStateNanSteps(arcIndex, i));
            double[] values = reader.getValues(arcIndex, i);
            this.robins[i].update(values);
        }
    }

    public long getArcStep() throws IOException {
        return this.parentDb.getHeader().getStep() * (long)this.steps.get();
    }

    String dump() throws IOException {
        StringBuilder sb = new StringBuilder("== ARCHIVE ==\n");
        sb.append("RRA:").append(this.consolFun.name()).append(":").append(this.xff.get()).append(":").append(this.steps.get()).append(":").append(this.rows.get()).append("\n").append("interval [").append(this.getStartTime()).append(", ").append(this.getEndTime()).append("]\n");
        for (int i = 0; i < this.robins.length; ++i) {
            sb.append(this.states[i].dump());
            sb.append(this.robins[i].dump());
        }
        return sb.toString();
    }

    RrdDb getParentDb() {
        return this.parentDb;
    }

    void archive(int dsIndex, double value, long numUpdates) throws IOException {
        Robin robin = this.robins[dsIndex];
        ArcState state = this.states[dsIndex];
        long step = this.parentDb.getHeader().getStep();
        long lastUpdateTime = this.parentDb.getHeader().getLastUpdateTime();
        long updateTime = Util.normalize(lastUpdateTime, step) + step;
        long arcStep = this.getArcStep();
        while (numUpdates > 0L) {
            this.accumulate(state, value);
            --numUpdates;
            if (updateTime % arcStep == 0L) {
                this.finalizeStep(state, robin);
                break;
            }
            updateTime += step;
        }
        int bulkUpdateCount = (int)Math.min(numUpdates / (long)this.steps.get(), (long)this.rows.get());
        robin.bulkStore(value, bulkUpdateCount);
        long remainingUpdates = numUpdates % (long)this.steps.get();
        for (long i = 0L; i < remainingUpdates; ++i) {
            this.accumulate(state, value);
        }
    }

    private void accumulate(ArcState state, double value) throws IOException {
        if (Double.isNaN(value)) {
            state.setNanSteps(state.getNanSteps() + 1L);
        } else {
            switch (this.consolFun.get()) {
                case MIN: {
                    state.setAccumValue(Util.min(state.getAccumValue(), value));
                    break;
                }
                case MAX: {
                    state.setAccumValue(Util.max(state.getAccumValue(), value));
                    break;
                }
                case FIRST: {
                    if (!Double.isNaN(state.getAccumValue())) break;
                    state.setAccumValue(value);
                    break;
                }
                case LAST: {
                    state.setAccumValue(value);
                    break;
                }
                case AVERAGE: 
                case TOTAL: {
                    state.setAccumValue(Util.sum(state.getAccumValue(), value));
                }
            }
        }
    }

    private void finalizeStep(ArcState state, Robin robin) throws IOException {
        long arcSteps = this.steps.get();
        double arcXff = this.xff.get();
        long nanSteps = state.getNanSteps();
        double accumValue = state.getAccumValue();
        if ((double)nanSteps <= arcXff * (double)arcSteps && !Double.isNaN(accumValue)) {
            if (this.consolFun.get() == ConsolFun.AVERAGE) {
                accumValue /= (double)(arcSteps - nanSteps);
            }
            robin.store(accumValue);
        } else {
            robin.store(Double.NaN);
        }
        state.setAccumValue(Double.NaN);
        state.setNanSteps(0L);
    }

    public ConsolFun getConsolFun() throws IOException {
        return this.consolFun.get();
    }

    public double getXff() throws IOException {
        return this.xff.get();
    }

    public int getSteps() throws IOException {
        return this.steps.get();
    }

    public int getRows() throws IOException {
        return this.rows.get();
    }

    public long getStartTime() throws IOException {
        long endTime = this.getEndTime();
        long arcStep = this.getArcStep();
        long numRows = this.rows.get();
        return endTime - (numRows - 1L) * arcStep;
    }

    public long getEndTime() throws IOException {
        long arcStep = this.getArcStep();
        long lastUpdateTime = this.parentDb.getHeader().getLastUpdateTime();
        return Util.normalize(lastUpdateTime, arcStep);
    }

    public ArcState getArcState(int dsIndex) {
        return this.states[dsIndex];
    }

    public Robin getRobin(int dsIndex) {
        return this.robins[dsIndex];
    }

    FetchData fetchData(FetchRequest request) throws IOException {
        long arcStep = this.getArcStep();
        long fetchStart = Util.normalize(request.getFetchStart(), arcStep);
        long fetchEnd = Util.normalize(request.getFetchEnd(), arcStep);
        if (fetchEnd < request.getFetchEnd()) {
            fetchEnd += arcStep;
        }
        long startTime = this.getStartTime();
        long endTime = this.getEndTime();
        String[] dsToFetch = request.getFilter();
        if (dsToFetch == null) {
            dsToFetch = this.parentDb.getDsNames();
        }
        int dsCount = dsToFetch.length;
        int ptsCount = (int)((fetchEnd - fetchStart) / arcStep + 1L);
        long[] timestamps = new long[ptsCount];
        double[][] values = new double[dsCount][ptsCount];
        long matchStartTime = Math.max(fetchStart, startTime);
        long matchEndTime = Math.min(fetchEnd, endTime);
        double[][] robinValues = null;
        if (matchStartTime <= matchEndTime) {
            int matchCount = (int)((matchEndTime - matchStartTime) / arcStep + 1L);
            int matchStartIndex = (int)((matchStartTime - startTime) / arcStep);
            robinValues = new double[dsCount][];
            for (int i = 0; i < dsCount; ++i) {
                int dsIndex = this.parentDb.getDsIndex(dsToFetch[i]);
                robinValues[i] = this.robins[dsIndex].getValues(matchStartIndex, matchCount);
            }
        }
        for (int ptIndex = 0; ptIndex < ptsCount; ++ptIndex) {
            long time;
            timestamps[ptIndex] = time = fetchStart + (long)ptIndex * arcStep;
            for (int i = 0; i < dsCount; ++i) {
                double value = Double.NaN;
                if (time >= matchStartTime && time <= matchEndTime) {
                    int robinValueIndex = (int)((time - matchStartTime) / arcStep);
                    assert (robinValues != null);
                    value = robinValues[i][robinValueIndex];
                }
                values[i][ptIndex] = value;
            }
        }
        FetchData fetchData = new FetchData(this, request);
        fetchData.setTimestamps(timestamps);
        fetchData.setValues(values);
        return fetchData;
    }

    void appendXml(XmlWriter writer) throws IOException {
        writer.startTag("rra");
        writer.writeTag("cf", this.consolFun.name());
        writer.writeComment(this.getArcStep() + " seconds");
        writer.writeTag("pdp_per_row", this.steps.get());
        writer.startTag("params");
        writer.writeTag("xff", this.xff.get());
        writer.closeTag();
        writer.startTag("cdp_prep");
        for (ArcState state : this.states) {
            state.appendXml(writer);
        }
        writer.closeTag();
        writer.startTag("database");
        long startTime = this.getStartTime();
        for (int i = 0; i < this.rows.get(); ++i) {
            long time = startTime + (long)i * this.getArcStep();
            writer.writeComment(Util.getDate(time) + " / " + time);
            writer.startTag("row");
            for (Robin robin : this.robins) {
                writer.writeTag("v", robin.getValue(i));
            }
            writer.closeTag();
        }
        writer.closeTag();
        writer.closeTag();
    }

    @Override
    public void copyStateTo(Archive arc) throws IOException {
        if (arc.consolFun.get() != this.consolFun.get()) {
            throw new IllegalArgumentException("Incompatible consolidation functions");
        }
        if (arc.steps.get() != this.steps.get()) {
            throw new IllegalArgumentException("Incompatible number of steps");
        }
        int count = this.parentDb.getHeader().getDsCount();
        for (int i = 0; i < count; ++i) {
            int j = Util.getMatchingDatasourceIndex(this.parentDb, i, arc.parentDb);
            if (j < 0) continue;
            this.states[i].copyStateTo(arc.states[j]);
            this.robins[i].copyStateTo(arc.robins[j]);
        }
    }

    public void setXff(double xff) throws IOException {
        if (xff < 0.0 || xff >= 1.0) {
            throw new IllegalArgumentException("Invalid xff supplied (" + xff + "), must be >= 0 and < 1");
        }
        this.xff.set(xff);
    }

    @Override
    public RrdBackend getRrdBackend() {
        return this.parentDb.getRrdBackend();
    }

    @Override
    public RrdAllocator getRrdAllocator() {
        return this.parentDb.getRrdAllocator();
    }
}

