/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.client.storage;

import edu.uiuc.ncsa.myproxy.oa4mp.client.Asset;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetStore;
import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import java.security.SecureRandom;
import org.apache.commons.codec.binary.Hex;

public class AssetStoreUtil {
    static SecureRandom random;

    protected static SecureRandom getRandom() {
        if (random == null) {
            random = new SecureRandom();
        }
        return random;
    }

    public static Identifier createID() {
        byte[] bytes = new byte[16];
        AssetStoreUtil.getRandom().nextBytes(bytes);
        return BasicIdentifier.newID((String)("oa4mp:asset:/id/" + Hex.encodeHexString((byte[])bytes) + "/" + System.currentTimeMillis()));
    }

    public static Asset get(String identifier, AssetStore assetStore) {
        return (Asset)((Object)assetStore.get(BasicIdentifier.newID((String)identifier)));
    }

    public static void save(String identifier, Asset asset, AssetStore assetStore) {
        boolean newID = false;
        boolean bl = newID = asset.getIdentifier() == null;
        if (!asset.getIdentifierString().equals(identifier)) {
            newID = true;
            assetStore.remove(asset.getIdentifier());
        }
        if (newID) {
            asset.setIdentifier(BasicIdentifier.newID((String)identifier));
        }
        if (asset.getToken() != null) {
            assetStore.putByToken(asset);
        }
        assetStore.save((Identifiable)asset);
    }
}

