/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.oauth_1_0a.client;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.BeanUtils;
import edu.uiuc.ncsa.security.delegation.storage.Client;

public class OAClient
extends Client {
    String signatureMethod;
    static final long serialVersionUID = 54491152593L;

    public OAClient clone() {
        OAClient client = new OAClient(this.getIdentifier());
        client.setSecret(this.getSecret());
        client.setProxyLimited(this.isProxyLimited());
        client.setName(this.getName());
        client.setHomeUri(this.getHomeUri());
        client.setErrorUri(this.getErrorUri());
        client.setEmail(this.getEmail());
        client.setSignatureMethod(this.getSignatureMethod());
        client.setCreationTS(this.getCreationTS());
        return client;
    }

    public OAClient(Identifier identifier) {
        super(identifier);
    }

    public String getSignatureMethod() {
        return this.signatureMethod;
    }

    public void setSignatureMethod(String signatureMethod) {
        if (!signatureMethod.equals("RSA-SHA1")) {
            throw new GeneralException("Error: unsupported signature method. Only RSA-SHA1 is supported. Found " + signatureMethod);
        }
        this.signatureMethod = signatureMethod;
    }

    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        OAClient c = (OAClient)((Object)obj);
        return BeanUtils.checkEquals((Object)this.getSignatureMethod(), (Object)c.getSignatureMethod());
    }

    public String toString() {
        String x = super.toString();
        x = x.substring(0, x.lastIndexOf("]"));
        x = x + ", sig. method=" + this.getSignatureMethod() + "]";
        return x;
    }
}

