/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.tdb.transaction;

import com.hp.hpl.jena.tdb.TDBException;
import com.hp.hpl.jena.tdb.base.block.Block;
import com.hp.hpl.jena.tdb.base.block.BlockMgr;
import com.hp.hpl.jena.tdb.base.file.BufferChannel;
import com.hp.hpl.jena.tdb.base.file.BufferChannelFile;
import com.hp.hpl.jena.tdb.base.file.FileFactory;
import com.hp.hpl.jena.tdb.base.file.Location;
import com.hp.hpl.jena.tdb.base.objectfile.ObjectFile;
import com.hp.hpl.jena.tdb.base.record.RecordFactory;
import com.hp.hpl.jena.tdb.index.IndexMap;
import com.hp.hpl.jena.tdb.store.DatasetGraphTDB;
import com.hp.hpl.jena.tdb.store.StorageConfig;
import com.hp.hpl.jena.tdb.store.nodetable.NodeTable;
import com.hp.hpl.jena.tdb.sys.FileRef;
import com.hp.hpl.jena.tdb.sys.SystemTDB;
import com.hp.hpl.jena.tdb.transaction.Journal;
import com.hp.hpl.jena.tdb.transaction.JournalEntry;
import com.hp.hpl.jena.tdb.transaction.JournalEntryType;
import com.hp.hpl.jena.tdb.transaction.NodeTableTrans;
import com.hp.hpl.jena.tdb.transaction.Transaction;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Iterator;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.FileOps;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JournalControl {
    private static Logger log = LoggerFactory.getLogger(JournalControl.class);

    public static void print(String filename) {
        BufferChannelFile chan = BufferChannelFile.createUnmanaged(filename, "r");
        Journal journal = new Journal(chan);
        JournalControl.print(journal);
        chan.close();
    }

    public static void print(Journal journal) {
        System.out.println("Size: " + journal.size());
        Iterator<JournalEntry> iter = journal.entries();
        while (iter.hasNext()) {
            JournalEntry e = iter.next();
            System.out.println("Posn: " + journal.position() + " : (" + (journal.size() - journal.position()) + ")");
            System.out.println(JournalEntry.format(e));
        }
    }

    public static void recovery(DatasetGraphTDB dsg) {
        if (dsg.getLocation().isMem()) {
            return;
        }
        Journal journal = JournalControl.findJournal(dsg);
        if (journal == null || journal.isEmpty()) {
            return;
        }
        for (FileRef fileRef : dsg.getConfig().nodeTables.keySet()) {
            JournalControl.recoverNodeDat(dsg, fileRef);
        }
        JournalControl.recoverFromJournal(dsg.getConfig(), journal);
        journal.close();
        if (journal.getFilename() != null && FileOps.exists((String)journal.getFilename())) {
            FileOps.delete((String)journal.getFilename());
        }
    }

    private static Journal findJournal(DatasetGraphTDB dsg) {
        Location loc = dsg.getLocation();
        String journalFilename = loc.absolute("journal.jrnl");
        File f = new File(journalFilename);
        if (f.exists() && f.isFile() && f.length() > 0L) {
            return Journal.create(loc);
        }
        return null;
    }

    public static boolean recoverFromJournal(StorageConfig sConf, Journal jrnl) {
        if (jrnl.isEmpty()) {
            return false;
        }
        long posn = 0L;
        while (true) {
            long x;
            try {
                x = JournalControl.scanForCommit(jrnl, posn);
            }
            catch (TDBException ex) {
                x = -1L;
            }
            if (x == -1L) break;
            JournalControl.recoverSegment(jrnl, posn, x, sConf);
            posn = x;
        }
        jrnl.truncate(0L);
        jrnl.sync();
        JournalControl.syncAll(sConf);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long scanForCommit(Journal jrnl, long startPosn) {
        Iterator<JournalEntry> iter = jrnl.entries(startPosn);
        try {
            while (iter.hasNext()) {
                JournalEntry e = iter.next();
                if (e.getType() != JournalEntryType.Commit) continue;
                long l = e.getEndPosition();
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            Iter.close(iter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recoverSegment(Journal jrnl, long startPosn, long endPosn, StorageConfig sConf) {
        Iterator<JournalEntry> iter = jrnl.entries(startPosn);
        iter = jrnl.entries(startPosn);
        try {
            while (iter.hasNext()) {
                JournalEntry e = iter.next();
                if (e.getType() == JournalEntryType.Commit) {
                    if (e.getEndPosition() != endPosn) {
                        log.warn(String.format("Inconsistent: end at %d; expected %d", e.getEndPosition(), endPosn));
                    }
                    return;
                }
                JournalControl.replay(e, sConf);
            }
        }
        finally {
            Iter.close(iter);
        }
    }

    private static void recoverNodeDat(DatasetGraphTDB dsg, FileRef fileRef) {
        RecordFactory recordFactory = new RecordFactory(16, 8);
        NodeTable baseNodeTable = dsg.getConfig().nodeTables.get(fileRef);
        String objFilename = fileRef.getFilename() + "-" + "jrnl";
        objFilename = dsg.getLocation().absolute(objFilename);
        File jrnlFile = new File(objFilename);
        if (jrnlFile.exists() && jrnlFile.length() > 0L) {
            SystemTDB.syslog.info("Recovering node data: " + fileRef.getFilename());
            ObjectFile dataJrnl = FileFactory.createObjectFileDisk(objFilename);
            NodeTableTrans ntt = new NodeTableTrans(null, objFilename, baseNodeTable, new IndexMap(recordFactory), dataJrnl);
            ntt.append();
            ntt.close();
            dataJrnl.close();
            baseNodeTable.sync();
        }
        if (jrnlFile.exists()) {
            FileOps.delete((String)objFilename);
        }
    }

    public static void replay(Transaction transaction) {
        if (SystemTDB.syslog.isDebugEnabled()) {
            SystemTDB.syslog.debug("Replay " + transaction.getLabel());
        }
        Journal journal = transaction.getJournal();
        DatasetGraphTDB dsg = transaction.getBaseDataset();
        JournalControl.replay(journal, dsg.getConfig());
    }

    public static void replay(Journal journal, DatasetGraphTDB dsg) {
        JournalControl.replay(journal, dsg.getConfig());
    }

    private static void replay(Journal journal, StorageConfig sConf) {
        if (journal.size() == 0L) {
            return;
        }
        journal.position(0L);
        try {
            Iterator<JournalEntry> iter = journal.entries();
            while (iter.hasNext()) {
                JournalEntry e = iter.next();
                JournalControl.replay(e, sConf);
            }
        }
        catch (RuntimeException ex) {
            SystemTDB.syslog.error("Exception during journal replay", (Throwable)ex);
            throw ex;
        }
        Collection<BlockMgr> x = sConf.blockMgrs.values();
        for (BlockMgr blkMgr : x) {
            blkMgr.syncForce();
        }
        journal.truncate(0L);
    }

    private static boolean replay(JournalEntry e, StorageConfig sConf) {
        switch (e.getType()) {
            case Block: {
                BlockMgr blkMgr = sConf.blockMgrs.get(e.getFileRef());
                Block blk = e.getBlock();
                log.debug("Replay: {} {}", (Object)e.getFileRef(), (Object)blk);
                blk.setModified(true);
                blkMgr.overwrite(blk);
                return true;
            }
            case Buffer: {
                BufferChannel chan = sConf.bufferChannels.get(e.getFileRef());
                ByteBuffer bb = e.getByteBuffer();
                log.debug("Replay: {} {}", (Object)e.getFileRef(), (Object)bb);
                chan.write(bb, 0L);
                return true;
            }
            case Commit: {
                return false;
            }
            case Abort: 
            case Object: 
            case Checkpoint: {
                SystemTDB.errlog.warn("Unexpected block type: " + (Object)((Object)e.getType()));
            }
        }
        return false;
    }

    private static void syncAll(StorageConfig sConf) {
        Collection<BlockMgr> x = sConf.blockMgrs.values();
        for (BlockMgr blkMgr : x) {
            blkMgr.syncForce();
        }
        Collection<BufferChannel> y = sConf.bufferChannels.values();
        for (BufferChannel bChan : y) {
            bChan.sync();
        }
    }
}

