/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr;

import com.hp.hpl.jena.sparql.core.Var;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprTransformCopy;
import com.hp.hpl.jena.sparql.expr.ExprVar;
import java.util.HashMap;
import java.util.Map;

public class ExprTransformSubstitute
extends ExprTransformCopy {
    private Map<String, Expr> replacements = new HashMap<String, Expr>();

    public ExprTransformSubstitute(Var find, Expr replace) {
        if (find == null) {
            throw new IllegalArgumentException("find cannot be null");
        }
        if (replace == null) {
            throw new IllegalArgumentException("replace cannot be null");
        }
        this.replacements.put(find.getVarName(), replace);
    }

    public ExprTransformSubstitute(Map<String, Expr> substitutions) {
        if (substitutions == null) {
            throw new IllegalArgumentException("replacements cannot be null");
        }
        this.replacements.putAll(substitutions);
        for (String key : this.replacements.keySet()) {
            if (this.replacements.get(key) != null) continue;
            throw new IllegalArgumentException("Variable ?" + key + " cannot be mapped to a null expression");
        }
    }

    @Override
    public Expr transform(ExprVar exprVar) {
        if (this.replacements.containsKey(exprVar.getVarName())) {
            return this.replacements.get(exprVar.getVarName());
        }
        return super.transform(exprVar);
    }
}

