/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.update;

import com.hp.hpl.jena.query.Syntax;
import com.hp.hpl.jena.sparql.core.Prologue;
import com.hp.hpl.jena.sparql.modify.UpdateCompare;
import com.hp.hpl.jena.sparql.modify.request.UpdateSerializer;
import com.hp.hpl.jena.sparql.modify.request.UpdateWriter;
import com.hp.hpl.jena.sparql.serializer.SerializerRegistry;
import com.hp.hpl.jena.sparql.serializer.UpdateSerializerFactory;
import com.hp.hpl.jena.update.Update;
import com.hp.hpl.jena.update.UpdateFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.io.PrintUtils;
import org.apache.jena.atlas.io.Printable;

public class UpdateRequest
extends Prologue
implements Printable,
Iterable<Update> {
    private List<Update> operations = new ArrayList<Update>();
    private List<Update> operationsView = Collections.unmodifiableList(this.operations);

    public UpdateRequest() {
    }

    public UpdateRequest(Update update2) {
        this();
        this.add(update2);
    }

    public UpdateRequest add(Update update2) {
        this.operations.add(update2);
        return this;
    }

    public UpdateRequest add(String string) {
        UpdateFactory.parse(this, string);
        return this;
    }

    public List<Update> getOperations() {
        return this.operationsView;
    }

    @Override
    public Iterator<Update> iterator() {
        return this.operationsView.iterator();
    }

    public String toString() {
        return PrintUtils.toString(this);
    }

    @Override
    public void output(IndentedWriter out) {
        UpdateSerializerFactory factory = SerializerRegistry.get().getUpdateSerializerFactory(Syntax.defaultUpdateSyntax);
        if (factory != null) {
            UpdateSerializer serializer = factory.create(Syntax.defaultUpdateSyntax, this, out);
            serializer.open();
            serializer.update(this);
            serializer.close();
        } else {
            UpdateWriter.output(this, out);
        }
    }

    public boolean equalTo(UpdateRequest other) {
        return UpdateCompare.isomorphic(this, other);
    }
}

