/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.database;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.ecoinformatics.datamanager.DataManager;
import org.ecoinformatics.datamanager.database.DatabaseAdapter;
import org.ecoinformatics.datamanager.database.DatabaseLoader;
import org.ecoinformatics.datamanager.database.HSQLAdapter;
import org.ecoinformatics.datamanager.database.OracleAdapter;
import org.ecoinformatics.datamanager.database.PostgresAdapter;
import org.ecoinformatics.datamanager.database.TableMonitor;
import org.ecoinformatics.datamanager.download.DataStorageInterface;
import org.ecoinformatics.datamanager.download.DownloadHandler;
import org.ecoinformatics.datamanager.download.EcogridEndPointInterface;
import org.ecoinformatics.datamanager.parser.AttributeList;
import org.ecoinformatics.datamanager.parser.DataPackage;
import org.ecoinformatics.datamanager.parser.Entity;
import org.ecoinformatics.datamanager.quality.QualityCheck;
import org.ecoinformatics.datamanager.quality.QualityReport;

public class DatabaseHandler {
    private TableMonitor tableMonitor = null;
    private String dbAdapterName = null;
    private DatabaseAdapter databaseAdapter;

    public DatabaseHandler(String dbAdapterName) throws Exception {
        this.dbAdapterName = dbAdapterName;
        if (dbAdapterName.equals("PostgresAdapter")) {
            this.databaseAdapter = new PostgresAdapter();
        } else if (dbAdapterName.equals("HSQLAdapter")) {
            this.databaseAdapter = new HSQLAdapter();
        } else if (dbAdapterName.equals("OracleAdapter")) {
            this.databaseAdapter = new OracleAdapter();
        }
        this.tableMonitor = new TableMonitor(this.databaseAdapter);
    }

    boolean dropTable(String tableName) throws SQLException {
        Connection connection = DataManager.getConnection();
        boolean success = false;
        if (tableName != null && !tableName.trim().equals("")) {
            if (this.tableMonitor.isTableInDB(tableName)) {
                Statement stmt = null;
                String sqlString = this.databaseAdapter.generateDropTableSQL(tableName);
                try {
                    stmt = connection.createStatement();
                    stmt.executeUpdate(sqlString);
                    success = true;
                    success = success && this.tableMonitor.dropTableEntry(tableName);
                }
                catch (SQLException e) {
                    System.err.println("SQLException: " + e.getMessage());
                    throw e;
                }
                finally {
                    if (stmt != null) {
                        stmt.close();
                    }
                    DataManager.returnConnection(connection);
                }
            } else {
                this.tableMonitor.dropTableEntry(tableName);
                success = true;
            }
        }
        return success;
    }

    public boolean dropTable(Entity entity) throws SQLException {
        boolean success = false;
        String tableName = entity.getDBTableName();
        if (tableName == null || tableName.equals("")) {
            throw new SQLException("Entity does not have a valid name. " + tableName);
        }
        success = this.dropTable(tableName);
        return success;
    }

    public boolean dropTables(DataPackage dataPackage) throws SQLException {
        boolean success = true;
        Entity[] entities = dataPackage.getEntityList();
        for (int i = 0; i < entities.length; ++i) {
            Entity entity = entities[i];
            success = success && this.dropTable(entity);
        }
        return success;
    }

    public boolean dropTables(String packageId) throws SQLException {
        boolean success = true;
        ArrayList<String> tableNames = this.tableMonitor.getDBTableNames(packageId);
        if (tableNames != null) {
            for (String tableName : tableNames) {
                success = this.dropTable(tableName) && success;
            }
        }
        return success;
    }

    public boolean generateTable(Entity entity) throws SQLException {
        boolean success = true;
        QualityCheck databaseTableQualityCheck = null;
        String qualityCheckIdentifier = "databaseTableCreated";
        QualityCheck qualityCheckTemplate = QualityReport.getQualityCheckTemplate(qualityCheckIdentifier);
        databaseTableQualityCheck = new QualityCheck(qualityCheckIdentifier, qualityCheckTemplate);
        String tableName = this.tableMonitor.addTableEntry(entity);
        if (tableName == null || tableName.trim().equals("")) {
            String message = "Entity has not been assigned a valid name.";
            if (QualityCheck.shouldRunQualityCheck(entity, databaseTableQualityCheck)) {
                databaseTableQualityCheck.setFailedStatus();
                databaseTableQualityCheck.setFound("An error occurred while creating the database table");
                databaseTableQualityCheck.setExplanation(message);
                entity.addQualityCheck(databaseTableQualityCheck);
            }
            throw new SQLException(message);
        }
        boolean doesExist = this.isTableInDB(tableName);
        AttributeList attributeList = entity.getAttributeList();
        String ddlString = this.databaseAdapter.generateDDL(attributeList, tableName);
        String ddlStringEscaped = String.format("<![CDATA[%s]]>", ddlString);
        if (!doesExist) {
            Statement stmt = null;
            Connection connection = DataManager.getConnection();
            try {
                stmt = connection.createStatement();
                stmt.executeUpdate(ddlString);
                if (QualityCheck.shouldRunQualityCheck(entity, databaseTableQualityCheck)) {
                    databaseTableQualityCheck.setStatus(QualityCheck.Status.valid);
                    databaseTableQualityCheck.setFound("A database table was generated from the attributes description");
                    databaseTableQualityCheck.setExplanation(ddlStringEscaped);
                    entity.addQualityCheck(databaseTableQualityCheck);
                }
            }
            catch (SQLException e) {
                this.tableMonitor.dropTableEntry(tableName);
                String message = "SQLException while generating data table '" + tableName + "' for entity '" + entity.getName() + "': " + e.getMessage() + "\n" + ddlStringEscaped;
                System.err.println(message);
                e.printStackTrace();
                if (QualityCheck.shouldRunQualityCheck(entity, databaseTableQualityCheck)) {
                    databaseTableQualityCheck.setFailedStatus();
                    databaseTableQualityCheck.setFound("An error occurred while creating the database table");
                    databaseTableQualityCheck.setExplanation(message);
                    entity.addQualityCheck(databaseTableQualityCheck);
                }
                SQLException se = new SQLException(message);
                throw se;
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
                DataManager.returnConnection(connection);
            }
        }
        return success;
    }

    public boolean generateTables(DataPackage dataPackage) throws SQLException {
        boolean success = true;
        Entity[] entities = dataPackage.getEntityList();
        for (int i = 0; i < entities.length; ++i) {
            Entity entity = entities[i];
            success = success && this.generateTable(entity);
        }
        return success;
    }

    public boolean isTableInDB(String tableName) {
        boolean isPresent = false;
        try {
            isPresent = this.tableMonitor.isTableInDB(tableName);
        }
        catch (SQLException e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
        return isPresent;
    }

    public boolean loadDataToDB(DataPackage dataPackage, EcogridEndPointInterface endInfo) {
        Entity[] entities = dataPackage.getEntityList();
        boolean success = true;
        for (int i = 0; i < entities.length; ++i) {
            Entity entity = entities[i];
            success = success && this.loadDataToDB(entity, endInfo);
        }
        return success;
    }

    public boolean loadDataToDB(Entity entity, EcogridEndPointInterface endPointInfo) {
        boolean success = false;
        if (entity != null) {
            DownloadHandler downloadHandler = entity.getDownloadHandler(endPointInfo);
            DatabaseLoader dbLoader = null;
            try {
                dbLoader = new DatabaseLoader(this.dbAdapterName, entity);
                DataStorageInterface[] storage = new DataStorageInterface[]{dbLoader};
                success = downloadHandler.download(storage);
            }
            catch (Exception e) {
                success = false;
            }
        }
        return success;
    }

    public ResultSet selectData(String ANSISQL, DataPackage[] packages) throws SQLException {
        Connection connection = DataManager.getConnection();
        ResultSet rs = null;
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
            rs = stmt.executeQuery(ANSISQL);
        }
        catch (SQLException e) {
            System.err.println("SQLException: " + e.getMessage());
            throw e;
        }
        finally {
            DataManager.returnConnection(connection);
        }
        return rs;
    }
}

