/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.util.configuration;

import edu.uiuc.ncsa.security.core.exceptions.UnknownOptionException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;

public class CLITools {
    static OutputStream outputStream;
    static PrintWriter printWriter;

    public static String prompt(String prompt, Object defaultValue) {
        System.out.print(prompt + " (" + (defaultValue == null ? "none" : defaultValue.toString()) + "):");
        Scanner scanner = new Scanner(System.in);
        String rawInput = scanner.nextLine();
        if (rawInput == null || rawInput.length() == 0) {
            return defaultValue == null ? null : defaultValue.toString();
        }
        return rawInput;
    }

    public static OutputStream getOutputStream() {
        if (outputStream == null) {
            outputStream = System.out;
        }
        return outputStream;
    }

    public static void setOutputStream(OutputStream outputStream) {
        CLITools.outputStream = outputStream;
    }

    protected static PrintWriter getPrintWriter() {
        if (printWriter == null) {
            printWriter = new PrintWriter(CLITools.getOutputStream());
        }
        return printWriter;
    }

    public static void say(String x) {
        CLITools.getPrintWriter().println(x);
        CLITools.getPrintWriter().flush();
    }

    public static void say(Object obj, String x) {
        String head = "(null)";
        if (obj != null) {
            head = obj.getClass().getName();
        }
        CLITools.say(head + " (" + new Date() + "): " + x);
    }

    public static int listChoose(String head, Object[] options) {
        return CLITools.listChoose(head, options, 0);
    }

    public static int listChoose(String head, Object[] options, int defaultChoice) {
        CLITools.say(head);
        for (int i = 0; i < options.length; ++i) {
            CLITools.say(i + ". " + options[i].toString());
        }
        String choice = CLITools.prompt("Enter the number of your choice", Integer.toString(defaultChoice));
        try {
            return Integer.parseInt(choice);
        }
        catch (NumberFormatException nx) {
            throw new UnknownOptionException();
        }
    }

    public static int listChoose(String head, List options, int defaultChoice) {
        Object[] labels = new String[options.size()];
        Iterator iterator = options.iterator();
        for (int i = 0; i < options.size(); ++i) {
            labels[i] = iterator.next().toString();
        }
        return CLITools.listChoose(head, labels, defaultChoice);
    }
}

