/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client.types;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.dataone.service.types.v1.Identifier;

public class ObsoletesChain {
    private Identifier startingPid;
    private List<Object[]> infoTable;
    private TreeMap<Long, Integer> byDateIndex;
    private Map<Identifier, Integer> byIdIndex;
    private static final int PID = 0;
    private static final int PUBLISH_DATE = 1;
    private static final int OBSOLETES = 2;
    private static final int OBSOLETEDBY = 3;
    private static final int IS_ARCHIVED = 4;

    public ObsoletesChain(Identifier pid) {
        this.startingPid = pid;
        this.infoTable = new LinkedList<Object[]>();
        this.byDateIndex = new TreeMap();
        this.byIdIndex = new HashMap<Identifier, Integer>();
    }

    public Identifier getStartingPoint() {
        return this.startingPid;
    }

    public void addObject(Identifier pid, Date publishDate, Identifier obsoletes, Identifier obsoletedBy, Boolean isArchived) {
        if (publishDate == null) {
            throw new NullPointerException("publishDate parameter cannot be null.");
        }
        this.infoTable.add(new Object[]{pid, publishDate, obsoletes, obsoletedBy, isArchived});
        this.byDateIndex.put(publishDate.getTime(), this.infoTable.size() - 1);
        this.byIdIndex.put(pid, this.infoTable.size() - 1);
    }

    public Identifier getVersionAsOf(Date asOfDate) {
        Long asOf = asOfDate.getTime();
        Iterator<Long> it = this.byDateIndex.keySet().iterator();
        Long time = null;
        while (it.hasNext()) {
            Long nextTime = it.next();
            if (asOf < nextTime) break;
            time = nextTime;
        }
        if (time == null) {
            return null;
        }
        int tableIndex = this.byDateIndex.get(time);
        return (Identifier)this.infoTable.get(tableIndex)[0];
    }

    public Identifier nextVersion(Identifier pid) {
        int tableIndex = this.byIdIndex.get(pid);
        return (Identifier)this.infoTable.get(tableIndex)[3];
    }

    public Identifier previousVersion(Identifier pid) {
        int tableIndex = this.byIdIndex.get(pid);
        return (Identifier)this.infoTable.get(tableIndex)[2];
    }

    public Identifier getLatestVersion() {
        return this.getByPosition(this.size() - 1);
    }

    public Identifier getOriginalVersion() {
        return this.getByPosition(0);
    }

    public Identifier getByPosition(int index) {
        if (index < 0 || index >= this.infoTable.size()) {
            throw new IndexOutOfBoundsException("The provided index does not exist");
        }
        Iterator<Long> it = this.byDateIndex.keySet().iterator();
        Long time = null;
        int i = -1;
        while (it.hasNext()) {
            time = it.next();
            if (index != ++i) continue;
        }
        int tableIndex = this.byDateIndex.get(time);
        return (Identifier)this.infoTable.get(tableIndex)[0];
    }

    public int size() {
        return this.infoTable.size();
    }

    public boolean isComplete() {
        return this.infoTable.get(this.byIdIndex.get(this.getOriginalVersion()))[2] == null && this.infoTable.get(this.byIdIndex.get(this.getLatestVersion()))[3] == null;
    }

    public Boolean isArchived(Identifier pid) {
        int tableIndex = this.byIdIndex.get(pid);
        Object[] oa = this.infoTable.get(tableIndex);
        return oa[4] == null ? Boolean.FALSE : (Boolean)oa[4];
    }

    public Boolean latestIsArchived() {
        return this.isArchived(this.getLatestVersion());
    }

    public Date getPublishDate(Identifier pid) {
        int tableIndex = this.byIdIndex.get(pid);
        return (Date)this.infoTable.get(tableIndex)[1];
    }

    public boolean isLatestVersion(Identifier pid) {
        return this.infoTable.get(this.byIdIndex.get(pid))[3] == null;
    }
}

