/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class ExceptionalInputStream
extends PushbackInputStream {
    private static final String D1_XML_ERROR = "<error";
    private static final String D1_TYPE_INDICATOR = "xmlns:d1=\"http://ns.dataone.org/service/types";
    private static int lookAheadBytes = 1000;
    private static int lookAheadIncrement = 50;
    private Boolean isException = null;
    private int bracketCount = 0;

    public ExceptionalInputStream(InputStream inputStream) {
        super(inputStream, lookAheadBytes);
    }

    public boolean isException() throws IOException {
        if (this.isException == null) {
            byte[] b = new byte[lookAheadBytes];
            int totalRead = this.read(b, 0, 5);
            if (totalRead < 1) {
                this.isException = new Boolean(false);
                return this.isException;
            }
            String readString = new String(b, "UTF-8");
            if (readString.startsWith(D1_XML_ERROR)) {
                this.isException = new Boolean(true);
            } else {
                this.isException = new Boolean(true);
                int newlyRead = 0;
                while (newlyRead != -1 && this.bracketCount < 2 && totalRead < lookAheadBytes - lookAheadIncrement) {
                    newlyRead = this.read(b, totalRead, lookAheadIncrement);
                    if (newlyRead <= -1) continue;
                    totalRead += newlyRead;
                    readString = new String(b, "UTF-8");
                    if (readString.contains(D1_TYPE_INDICATOR)) {
                        this.isException = new Boolean(false);
                        break;
                    }
                    if (!readString.contains(">")) continue;
                    ++this.bracketCount;
                }
            }
            this.unread(b, 0, totalRead);
        }
        return this.isException;
    }
}

