/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.util.cli;

import edu.uiuc.ncsa.security.util.cli.ArgumentNotFoundException;
import edu.uiuc.ncsa.security.util.cli.CommandNotFoundException;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class InputLine {
    public static final String COMMAND_DELIMITER = "";
    List<String> parsedInput;

    public InputLine(Vector v) {
        this.parsedInput = v;
    }

    public String[] argsToStringArray() {
        String[] out = null;
        if (this.parsedInput != null && !this.parsedInput.isEmpty()) {
            out = new String[this.parsedInput.size() - 1];
            for (int i = 1; i < this.parsedInput.size(); ++i) {
                out[i - 1] = this.parsedInput.get(i);
            }
        }
        return out;
    }

    public List<String> getArgs() {
        if (this.parsedInput.isEmpty() || this.parsedInput.size() == 1) {
            return new LinkedList<String>();
        }
        return this.parsedInput.subList(1, this.parsedInput.size());
    }

    public String getCommand() {
        if (this.parsedInput.isEmpty()) {
            throw new CommandNotFoundException();
        }
        return this.parsedInput.get(0).toLowerCase();
    }

    public String getLastArg() {
        if (this.size() == 0) {
            throw new ArgumentNotFoundException();
        }
        return this.getArg(this.size() - 1);
    }

    public String getArg(int index) {
        if (0 <= this.parsedInput.size() && index + 1 <= this.parsedInput.size()) {
            return this.parsedInput.get(index);
        }
        throw new ArgumentNotFoundException();
    }

    public int getIntArg(int index) {
        try {
            return Integer.parseInt(this.getArg(index));
        }
        catch (NumberFormatException nfx) {
            throw new ArgumentNotFoundException("Error: the argument /" + this.getArg(index) + "/ cannot be parsed as an integer");
        }
    }

    public boolean isEmpty() {
        return this.parsedInput.isEmpty();
    }

    public int size() {
        return this.parsedInput.size();
    }

    public boolean hasArg(String arg) {
        return -1 != this.indexOf(arg);
    }

    public boolean hasArgs() {
        return 1 < this.size();
    }

    public int indexOf(String arg) {
        int index = 0;
        for (String x : this.getArgs()) {
            if (x.equals(arg)) {
                return index;
            }
            ++index;
        }
        return -1;
    }
}

