/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client.rest;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.dataone.client.auth.AuthTokenSession;
import org.dataone.client.auth.CertificateManager;
import org.dataone.client.auth.X509Session;
import org.dataone.client.exception.ClientSideException;
import org.dataone.client.rest.MultipartRestClient;
import org.dataone.client.rest.RestClient;
import org.dataone.client.utils.HttpUtils;
import org.dataone.configuration.Settings;
import org.dataone.exceptions.MarshallingException;
import org.dataone.mimemultipart.SimpleMultipartEntity;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.util.ExceptionHandler;

public class HttpMultipartRestClient
implements MultipartRestClient {
    protected static Log log = LogFactory.getLog(HttpMultipartRestClient.class);
    protected RestClient rc;
    protected RequestConfig baseRequestConfig;
    protected X509Session x509Session;
    public static final String DEFAULT_TIMEOUT_PARAM = "D1Client.http.default.timeouts.ms";
    public static final Integer DEFAULT_TIMEOUT_VALUE = 30000;

    public HttpMultipartRestClient(HttpClient httpClient, X509Session x509session) {
        this.rc = new RestClient(httpClient);
        this.x509Session = x509session;
        this.setDefaultTimeout(DEFAULT_TIMEOUT_VALUE);
    }

    public HttpMultipartRestClient(HttpClientBuilder httpClientBuilder, X509Session x509session) throws ClientSideException {
        PoolingHttpClientConnectionManager connMan = null;
        try {
            connMan = new PoolingHttpClientConnectionManager(HttpUtils.buildConnectionRegistry(x509session));
        }
        catch (IOException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new ClientSideException("Could not build the ConnectionRegistry", e);
        }
        this.rc = new RestClient((HttpClient)httpClientBuilder.setConnectionManager((HttpClientConnectionManager)connMan).build());
        this.x509Session = x509session;
        this.setDefaultTimeout(DEFAULT_TIMEOUT_VALUE);
    }

    public HttpMultipartRestClient() throws IOException, ClientSideException {
        this((String)null);
    }

    public HttpMultipartRestClient(String subjectString) throws IOException, ClientSideException {
        this(CertificateManager.getInstance().selectSession(subjectString));
    }

    public HttpMultipartRestClient(X509Session x509Session) throws IOException, ClientSideException {
        try {
            this.rc = new RestClient(HttpUtils.createHttpClient(x509Session));
        }
        catch (IllegalAccessException | InstantiationException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException | MarshallingException e) {
            e.printStackTrace();
            throw new ClientSideException("Could not create HttpClient.", e);
        }
        this.x509Session = x509Session;
        this.setDefaultTimeout(DEFAULT_TIMEOUT_VALUE);
    }

    public HttpMultipartRestClient(AuthTokenSession authTokenSession) {
        this.rc = new RestClient(HttpUtils.createHttpClient(authTokenSession.getAuthToken()));
    }

    public HttpClient getHttpClient() {
        return this.rc.getHttpClient();
    }

    @Override
    public String getLatestRequestUrl() {
        return this.rc.getLatestRequestUrl();
    }

    public String getLatestRequestUrl(Thread t) {
        return this.rc.getLatestRequestUrl(t);
    }

    @Deprecated
    public void closeIdleConnections() {
        this.getHttpClient().getConnectionManager().closeIdleConnections(0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public InputStream doGetRequest(String url, Integer timeoutMillisecs) throws BaseException, ClientSideException {
        return this.doGetRequest(url, timeoutMillisecs, false);
    }

    @Override
    public InputStream doGetRequest(String url, Integer timeoutMillisecs, boolean followRedirect) throws BaseException, ClientSideException {
        try {
            HttpResponse response = this.rc.doGetRequest(url, this.determineRequestConfig(timeoutMillisecs, followRedirect));
            return ExceptionHandler.filterErrors((HttpResponse)response, (!followRedirect ? 1 : 0) != 0);
        }
        catch (IllegalStateException e) {
            throw new ClientSideException("", e);
        }
        catch (ClientProtocolException e) {
            throw new ClientSideException("", e);
        }
        catch (IOException e) {
            throw new ClientSideException("", e);
        }
        catch (HttpException e) {
            throw new ClientSideException("", e);
        }
    }

    @Override
    public Header[] doGetRequestForHeaders(String url, Integer timeoutMillisecs) throws BaseException, ClientSideException {
        this.determineTimeoutConfig(timeoutMillisecs);
        try {
            return ExceptionHandler.filterErrorsHeader((HttpResponse)this.rc.doGetRequest(url, this.determineTimeoutConfig(timeoutMillisecs)), (String)"GET");
        }
        catch (IllegalStateException e) {
            throw new ClientSideException("", e);
        }
        catch (ClientProtocolException e) {
            throw new ClientSideException("", e);
        }
        catch (IOException e) {
            throw new ClientSideException("", e);
        }
        catch (HttpException e) {
            throw new ClientSideException("", e);
        }
    }

    @Override
    public InputStream doDeleteRequest(String url, Integer timeoutMillisecs) throws BaseException, ClientSideException {
        this.determineTimeoutConfig(timeoutMillisecs);
        try {
            return ExceptionHandler.filterErrors((HttpResponse)this.rc.doDeleteRequest(url, this.determineTimeoutConfig(timeoutMillisecs)));
        }
        catch (IllegalStateException e) {
            throw new ClientSideException("", e);
        }
        catch (ClientProtocolException e) {
            throw new ClientSideException("", e);
        }
        catch (IOException e) {
            throw new ClientSideException("", e);
        }
        catch (HttpException e) {
            throw new ClientSideException("", e);
        }
    }

    @Override
    public Header[] doHeadRequest(String url, Integer timeoutMillisecs) throws BaseException, ClientSideException {
        try {
            return ExceptionHandler.filterErrorsHeader((HttpResponse)this.rc.doHeadRequest(url, this.determineTimeoutConfig(timeoutMillisecs)), (String)"HEAD");
        }
        catch (IllegalStateException e) {
            throw new ClientSideException("", e);
        }
        catch (ClientProtocolException e) {
            throw new ClientSideException("", e);
        }
        catch (IOException e) {
            throw new ClientSideException("", e);
        }
        catch (HttpException e) {
            throw new ClientSideException("", e);
        }
    }

    @Override
    public InputStream doPutRequest(String url, SimpleMultipartEntity entity, Integer timeoutMillisecs) throws BaseException, ClientSideException {
        this.determineTimeoutConfig(timeoutMillisecs);
        try {
            return ExceptionHandler.filterErrors((HttpResponse)this.rc.doPutRequest(url, entity, this.determineTimeoutConfig(timeoutMillisecs)));
        }
        catch (IllegalStateException e) {
            throw new ClientSideException("", e);
        }
        catch (ClientProtocolException e) {
            throw new ClientSideException("", e);
        }
        catch (IOException e) {
            throw new ClientSideException("", e);
        }
        catch (HttpException e) {
            throw new ClientSideException("", e);
        }
    }

    @Override
    public InputStream doPostRequest(String url, SimpleMultipartEntity entity, Integer timeoutMillisecs) throws BaseException, ClientSideException {
        this.determineTimeoutConfig(timeoutMillisecs);
        try {
            return ExceptionHandler.filterErrors((HttpResponse)this.rc.doPostRequest(url, entity, this.determineTimeoutConfig(timeoutMillisecs)));
        }
        catch (IllegalStateException e) {
            throw new ClientSideException("", e);
        }
        catch (ClientProtocolException e) {
            throw new ClientSideException("", e);
        }
        catch (IOException e) {
            throw new ClientSideException("", e);
        }
        catch (HttpException e) {
            throw new ClientSideException("", e);
        }
    }

    @Deprecated
    public void setHeader(String name, String value) {
        this.rc.setHeader(name, value);
    }

    @Deprecated
    public HashMap<String, String> getAddedHeaders() {
        return this.rc.getAddedHeaders();
    }

    private RequestConfig determineTimeoutConfig(Integer milliseconds) {
        return this.determineRequestConfig(milliseconds, true);
    }

    private RequestConfig determineRequestConfig(Integer timeoutMillis, Boolean followRedirect) {
        RequestConfig.Builder rcBuilder = null;
        rcBuilder = this.baseRequestConfig != null ? RequestConfig.copy((RequestConfig)this.baseRequestConfig) : RequestConfig.custom();
        if (timeoutMillis == null) {
            timeoutMillis = Settings.getConfiguration().getInteger(DEFAULT_TIMEOUT_PARAM, null);
        }
        if (timeoutMillis != null) {
            rcBuilder.setConnectTimeout(timeoutMillis.intValue()).setConnectionRequestTimeout(timeoutMillis.intValue()).setSocketTimeout(timeoutMillis.intValue());
        }
        if (followRedirect != null) {
            rcBuilder.setRedirectsEnabled(followRedirect.booleanValue());
        }
        return rcBuilder.build();
    }

    @Override
    public X509Session getSession() {
        return this.x509Session;
    }

    public void setDefaultTimeout(Integer timeout) {
        Settings.getConfiguration().setProperty(DEFAULT_TIMEOUT_PARAM, (Object)timeout);
    }

    public void clearDefaultTimeout() {
        Settings.getConfiguration().clearProperty(DEFAULT_TIMEOUT_PARAM);
    }
}

