/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.types.v2.util;

import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidSystemMetadata;
import org.dataone.service.types.v1.Service;
import org.dataone.service.types.v2.Node;
import org.dataone.service.types.v2.NodeList;
import org.dataone.service.types.v2.SystemMetadata;
import org.dataone.service.types.v2.util.NodelistUtil;

public class AuthUtils
extends org.dataone.service.types.v1.util.AuthUtils {
    public static boolean isCNAuthorityForSystemMetadataUpdate(NodeList nodelist, SystemMetadata systemMetadata) throws InvalidSystemMetadata, InvalidRequest {
        Node authMN = NodelistUtil.findNode(nodelist, systemMetadata.getAuthoritativeMemberNode());
        boolean v1MNStorageAvailable = false;
        if (authMN == null) {
            throw new InvalidSystemMetadata("0:AuthUtils", "authoritativeMN in systemMetadata was not found in the Nodelist");
        }
        if (authMN.getServices() == null) {
            throw new InvalidRequest("0:AuthUtils", String.format("The authoritative MN %s does not have any services!", authMN.getIdentifier().getValue()));
        }
        for (Service service : authMN.getServices().getServiceList()) {
            if (!service.getAvailable().booleanValue()) continue;
            if (service.getVersion().equalsIgnoreCase("v1")) {
                if (!service.getName().equalsIgnoreCase("MNStorage")) continue;
                v1MNStorageAvailable = true;
                continue;
            }
            if (!service.getVersion().matches("^[v|V](\\d+)$")) continue;
            return false;
        }
        return v1MNStorageAvailable;
    }
}

