/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.emltest;

import edu.ucsb.nceas.utilities.config.ConfigXML;
import java.io.File;
import java.io.FileReader;
import java.net.URL;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.ecoinformatics.eml.EMLParserServlet;
import org.ecoinformatics.eml.SAXValidate;
import org.xml.sax.SAXParseException;

public class SaxValidateTest
extends TestCase {
    private static final String DEFAULT_PARSER = "org.apache.xerces.parsers.SAXParser";
    private static final String TEST_DIR = "./src/test/resources/";
    private static final String MODULES_DIR = "./src/test/resources//moduleEML/";

    public SaxValidateTest(String name) {
        super(name);
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public void initialize() {
        SaxValidateTest.assertTrue((boolean)true);
    }

    public void testSchemaValid() {
        String namespaces;
        SAXValidate test = new SAXValidate(true);
        SaxValidateTest.assertTrue((test != null ? 1 : 0) != 0);
        URL configFile = ((Object)((Object)this)).getClass().getResource("/config.xml");
        try {
            ConfigXML config = new ConfigXML(configFile.openStream());
            namespaces = config.get("namespaces", 0);
            String EML_VERSION = System.getenv("EML_VERSION");
            if (EML_VERSION != null) {
                String systemId = "https://knb.ecoinformatics.org/emlparser/schema/eml-" + EML_VERSION + "/eml.xsd";
                namespaces = namespaces.replaceAll(systemId, "xsd/eml.xsd");
            }
        }
        catch (Exception e) {
            namespaces = "misssing namespaces";
        }
        System.out.println("Using configured schemaLocation namespaces: " + namespaces);
        Vector fileList = this.getXmlFiles(TEST_DIR);
        Vector modsList = this.getXmlFiles(MODULES_DIR);
        fileList.addAll(modsList);
        for (int i = 0; i < fileList.size(); ++i) {
            File testFile = (File)fileList.elementAt(i);
            try {
                System.err.println("Validating file: " + testFile.getName());
                FileReader reader = new FileReader(testFile);
                String namespace = EMLParserServlet.findNamespace(reader);
                reader.close();
                test.runTest(new FileReader(testFile), "DEFAULT", namespaces, namespace);
                continue;
            }
            catch (Exception e) {
                if (e instanceof SAXParseException) {
                    SAXParseException spe = (SAXParseException)e;
                    System.err.println("Error on line: " + spe.getLineNumber());
                }
                e.printStackTrace(System.err);
                SaxValidateTest.fail((String)("Document NOT valid!\n\n" + e.getClass().getName() + "(" + e.getMessage() + ")"));
            }
        }
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new SaxValidateTest("initialize"));
        suite.addTest((Test)new SaxValidateTest("testSchemaValid"));
        return suite;
    }

    private Vector getXmlFiles(String dirname) {
        File directory = new File(dirname);
        String[] files = directory.list();
        Vector<File> fileList = new Vector<File>();
        for (int i = 0; i < files.length; ++i) {
            String filename = files[i];
            File currentFile = new File(directory, filename);
            if (!currentFile.isFile() || !filename.endsWith(".xml")) continue;
            fileList.addElement(currentFile);
        }
        return fileList;
    }
}

