/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.emltest;

import java.io.File;
import java.util.Vector;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.ecoinformatics.eml.EMLParser;

public class EMLParserTest
extends TestCase {
    private static final String TEST_DIR = "./src/test/resources";
    private static final String INVALID_DIR = "./src/test/resources/invalidEML";
    private static final String ERROR1 = "./src/test/resources/invalidEML/eml-error1.xml";
    private static final String ERROR3 = "./src/test/resources/invalidEML/eml-error3.xml";
    private static final String ERROR4 = "./src/test/resources/invalidEML/eml-error4.xml";
    private EMLParser emlp;

    public EMLParserTest(String name) {
        super(name);
    }

    public void setUp() {
    }

    public void tearDown() {
    }

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new EMLParserTest("initialize"));
        suite.addTest((Test)new EMLParserTest("testParse"));
        suite.addTest((Test)new EMLParserTest("testParseString"));
        return suite;
    }

    public void initialize() {
        EMLParserTest.assertTrue((boolean)true);
    }

    public void testParse() {
        File f;
        File testDir = new File(TEST_DIR);
        Vector fileList = this.getXmlFiles(testDir);
        for (int i = 0; i < fileList.size(); ++i) {
            File testFile = (File)fileList.elementAt(i);
            try {
                System.err.println("Validating file: " + testFile.getName());
                this.emlp = new EMLParser(testFile);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                EMLParserTest.fail((String)("Document NOT valid!\n\n" + e.getClass().getName() + "(" + e.getMessage() + ")"));
            }
        }
        try {
            f = new File(ERROR1);
            System.err.println("Validating file: " + f.getName());
            this.emlp = new EMLParser(f);
            EMLParserTest.fail((String)"Error 1. An EMLParserException should have been thrown.");
        }
        catch (Exception e) {
            EMLParserTest.assertTrue((e.getMessage().indexOf("valid") != -1 ? 1 : 0) != 0);
        }
        try {
            f = new File(ERROR3);
            System.err.println("Validating file: " + f.getName());
            this.emlp = new EMLParser(f);
            EMLParserTest.fail((String)"Error 3. An EMLParserException should have been thrown.");
        }
        catch (Exception e) {
            EMLParserTest.assertTrue((e.getMessage().indexOf("valid") != -1 ? 1 : 0) != 0);
        }
        try {
            f = new File(ERROR4);
            System.err.println("Validating file: " + f.getName());
            this.emlp = new EMLParser(f);
            EMLParserTest.fail((String)"Error 4. An EMLParserException should have been thrown.");
        }
        catch (Exception e) {
            EMLParserTest.assertTrue((e.getMessage().indexOf("valid") != -1 ? 1 : 0) != 0);
        }
    }

    public void testParseString() {
        File testDir = new File(TEST_DIR);
        File testFile = new File(TEST_DIR, "eml-sample.xml");
        try {
            System.err.println("Validating file: " + testFile.getName());
            EMLParser eMLParser = new EMLParser(testFile);
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            EMLParserTest.fail((String)("Document NOT valid!\n\n" + e.getClass().getName() + "(" + e.getMessage() + ")"));
        }
    }

    private Vector getXmlFiles(File directory) {
        String[] files = directory.list();
        Vector<File> fileList = new Vector<File>();
        for (int i = 0; i < files.length; ++i) {
            String filename = files[i];
            File currentFile = new File(directory, filename);
            if (!currentFile.isFile() || !filename.endsWith(".xml")) continue;
            fileList.addElement(currentFile);
        }
        return fileList;
    }
}

