/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.parser.document;

import edu.ucsb.nceas.utilities.OrderedMap;
import edu.ucsb.nceas.utilities.XMLUtilities;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xpath.CachedXPathAPI;
import org.ecoinformatics.datamanager.parser.Attribute;
import org.ecoinformatics.datamanager.parser.AttributeList;
import org.ecoinformatics.datamanager.parser.DataPackage;
import org.ecoinformatics.datamanager.parser.Domain;
import org.ecoinformatics.datamanager.parser.Entity;
import org.ecoinformatics.datamanager.parser.NumericDomain;
import org.ecoinformatics.datamanager.parser.TextDomain;
import org.ecoinformatics.datamanager.parser.document.DocumentDataPackage;
import org.ecoinformatics.datamanager.parser.generic.DataPackageParserInterface;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class DocumentDataPackageParser
implements DataPackageParserInterface {
    private static Log log = LogFactory.getLog(DocumentDataPackageParser.class);
    protected String packageIdPath = "//*/@packageId";
    protected String packageId = null;
    private DocumentDataPackage dataPackage = null;
    private Map attributeXPathMap = null;
    private Map record = new HashMap();
    private Document doc = null;

    public DocumentDataPackageParser() {
    }

    public void setAttributeXPathMap(Map xpaths) {
        this.attributeXPathMap = xpaths;
    }

    private Vector getRecordRow() {
        Vector row = new Vector();
        row.addAll(this.record.values());
        return row;
    }

    public DocumentDataPackageParser(String packageId) {
        this();
        this.packageId = packageId;
    }

    @Override
    public void parse(InputSource source) throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.doc = builder.parse(source);
        this.parseDocument();
    }

    @Override
    public void parse(InputStream is) throws Exception {
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        this.doc = builder.parse(is);
        this.parseDocument();
    }

    private void parseDocument() throws Exception {
        if (this.packageId == null) {
            CachedXPathAPI xpathapi = new CachedXPathAPI();
            try {
                Node packageIdNode = xpathapi.selectSingleNode((Node)this.doc, this.packageIdPath);
                if (packageIdNode != null) {
                    this.packageId = packageIdNode.getNodeValue();
                }
            }
            catch (Exception e) {
                throw new Exception("Error extracting packageId from root of document.");
            }
        }
        this.dataPackage = new DocumentDataPackage(this.packageId);
    }

    public void generateEntity() throws Exception {
        if (this.attributeXPathMap == null) {
            throw new Exception("Must specify attribute xPaths for document->record parsing.");
        }
        this.record = DocumentDataPackageParser.document2Map(this.doc, this.attributeXPathMap);
        Entity entity = DocumentDataPackageParser.map2Entity(this.record, this.dataPackage.getPackageId());
        this.dataPackage.clearEntityList();
        this.dataPackage.add(entity);
        this.dataPackage.setRecordRow(this.getRecordRow());
    }

    @Override
    public DataPackage getDataPackage() {
        return this.dataPackage;
    }

    public static Entity map2Entity(Map record, String entityId) {
        AttributeList attributeList = new AttributeList();
        Iterator iter = record.keySet().iterator();
        while (iter.hasNext()) {
            String id;
            String name = id = (String)iter.next();
            Object value = record.get(id);
            Domain domain = new TextDomain();
            if (value instanceof Number) {
                domain = new NumericDomain("real", null, null);
            }
            Attribute a = new Attribute(id, name, domain);
            attributeList.add(a);
        }
        Entity entity = new Entity(entityId, entityId, entityId, attributeList);
        entity.setPackageId(entity.getId());
        entity.setEntityIdentifier(entity.getId());
        return entity;
    }

    public static Map document2Map(Document doc, Map attributeXPaths) {
        OrderedMap record = new OrderedMap();
        try {
            for (String attributeLabel : attributeXPaths.keySet()) {
                String attributeXPath = (String)attributeXPaths.get(attributeLabel);
                NodeList attributeNodeList = XMLUtilities.getNodeListWithXPath((Node)doc.getDocumentElement(), (String)attributeXPath);
                if (attributeNodeList == null) {
                    log.debug((Object)("no nodes found for xPath: " + attributeXPath));
                    record.put(attributeLabel, null);
                    log.debug((Object)("added null placeholder for attribute: " + attributeLabel));
                    continue;
                }
                for (int i = 0; i < attributeNodeList.getLength(); ++i) {
                    Node attributeNode = attributeNodeList.item(i);
                    String nodeTextContent = null;
                    nodeTextContent = attributeNode.getTextContent();
                    String columnLabel = attributeLabel;
                    if (record.containsKey(columnLabel)) {
                        if (i == 1) {
                            Object firstValue = record.get(columnLabel);
                            record.put(columnLabel + "_" + i, firstValue);
                        }
                        columnLabel = columnLabel + "_" + (i + 1);
                    }
                    record.put(columnLabel, nodeTextContent);
                    log.debug((Object)("added flat attribute: " + columnLabel + "=" + nodeTextContent));
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("could not flatten attributes in document: " + e.getMessage()));
            e.printStackTrace();
        }
        return record;
    }
}

