/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.database;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.ecoinformatics.datamanager.database.DatabaseAdapter;
import org.ecoinformatics.datamanager.parser.Attribute;
import org.ecoinformatics.datamanager.parser.AttributeList;
import org.ecoinformatics.datamanager.parser.DateTimeDomain;
import org.ecoinformatics.datamanager.parser.Domain;
import org.ecoinformatics.datamanager.parser.EnumeratedDomain;
import org.ecoinformatics.datamanager.parser.NumericDomain;
import org.ecoinformatics.datamanager.parser.TextDomain;

public class HSQLAdapter
extends DatabaseAdapter {
    private static final String IFEXISTS = "IF EXISTS";
    private static final String CREATETABLE = "CREATE CACHED TABLE";

    public static Timestamp to_timestamp(String value, String formatString) throws ParseException {
        formatString = formatString.replaceAll("Y", "y");
        formatString = formatString.replaceAll("D", "d");
        formatString = formatString.replaceAll("W", "M");
        formatString = formatString.replaceAll("A", "a");
        formatString = formatString.replaceAll("P", "p");
        formatString = formatString.replaceAll("T", "'T'");
        value = value.replaceAll("\"", "");
        Timestamp timestamp = null;
        SimpleDateFormat sdf = new SimpleDateFormat(formatString);
        Date temp = null;
        try {
            temp = sdf.parse(value);
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw e;
        }
        timestamp = new Timestamp(temp.getTime());
        return timestamp;
    }

    public HSQLAdapter() {
        this.TO_DATE_FUNCTION = "\"" + this.getClass().getName() + ".to_timestamp\"";
    }

    @Override
    public String generateDDL(AttributeList attributeList, String tableName) throws SQLException {
        String attributeSQL = null;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(CREATETABLE);
        stringBuffer.append(" ");
        stringBuffer.append(tableName);
        stringBuffer.append("(");
        attributeSQL = this.parseAttributeList(attributeList);
        stringBuffer.append(attributeSQL);
        stringBuffer.append(")");
        stringBuffer.append(";");
        String sqlStr = stringBuffer.toString();
        return sqlStr;
    }

    @Override
    public String generateDropTableSQL(String tableName) {
        String sql = "DROP TABLE " + tableName + " " + IFEXISTS + ";";
        return sql;
    }

    @Override
    protected String getAttributeType(Attribute attribute) {
        String attributeType = null;
        attributeType = attribute.getAttributeType();
        if (attributeType != null) {
            return attributeType;
        }
        String className = this.getClass().getName();
        attributeType = this.getAttributeTypeFromStorageType(attribute, className);
        if (attributeType != null) {
            attribute.setAttributeType(attributeType);
            return attributeType;
        }
        attributeType = "string";
        Domain domain = attribute.getDomain();
        if (domain instanceof DateTimeDomain) {
            attributeType = "datetime";
        } else if (domain instanceof EnumeratedDomain || domain instanceof TextDomain) {
            attributeType = "string";
        } else if (domain instanceof NumericDomain) {
            NumericDomain numericDomain = (NumericDomain)domain;
            attributeType = numericDomain.getNumberType();
        }
        if (attribute != null) {
            attribute.setAttributeType(attributeType);
        }
        return attributeType;
    }

    @Override
    protected String mapDataType(String attributeType) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("string", "LONGVARCHAR");
        map.put("integer", "INTEGER");
        map.put("real", "FLOAT");
        map.put("whole", "INTEGER");
        map.put("natural", "INTEGER");
        map.put("datetime", "TIMESTAMP");
        String dbDataType = (String)map.get(attributeType.toLowerCase());
        return dbDataType;
    }

    @Override
    public String transformSelectionSQL(String ANSISQL) {
        return null;
    }

    @Override
    public String getCountingRowNumberSQL(String tableName) {
        String selectString = "SELECT COUNT(*) \"count\" FROM " + tableName;
        return selectString;
    }
}

