/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.params;

import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.StrUtils;

public class MultiMapSolrParams
extends SolrParams {
    protected final Map<String, String[]> map;

    public static void addParam(String name, String val, Map<String, String[]> map) {
        String[] arr = map.get(name);
        if (arr == null) {
            arr = new String[]{val};
        } else {
            String[] newarr = new String[arr.length + 1];
            System.arraycopy(arr, 0, newarr, 0, arr.length);
            newarr[arr.length] = val;
            arr = newarr;
        }
        map.put(name, arr);
    }

    public static void addParam(String name, String[] vals, Map<String, String[]> map) {
        String[] arr = map.put(name, vals);
        if (arr == null) {
            return;
        }
        String[] newarr = new String[arr.length + vals.length];
        System.arraycopy(arr, 0, newarr, 0, arr.length);
        System.arraycopy(vals, 0, newarr, arr.length, vals.length);
        arr = newarr;
        map.put(name, arr);
    }

    public MultiMapSolrParams(Map<String, String[]> map) {
        this.map = map;
    }

    @Override
    public String get(String name) {
        String[] arr = this.map.get(name);
        return arr == null ? null : arr[0];
    }

    @Override
    public String[] getParams(String name) {
        return this.map.get(name);
    }

    @Override
    public Iterator<String> getParameterNamesIterator() {
        return this.map.keySet().iterator();
    }

    public Map<String, String[]> getMap() {
        return this.map;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(128);
        try {
            boolean first = true;
            for (Map.Entry<String, String[]> entry : this.map.entrySet()) {
                String[] valarr;
                String key = entry.getKey();
                for (String val : valarr = entry.getValue()) {
                    if (!first) {
                        sb.append('&');
                    }
                    first = false;
                    sb.append(key);
                    sb.append('=');
                    StrUtils.partialURLEncodeVal(sb, val == null ? "" : val);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sb.toString();
    }

    public static Map<String, String[]> asMultiMap(SolrParams params) {
        return MultiMapSolrParams.asMultiMap(params, false);
    }

    public static Map<String, String[]> asMultiMap(SolrParams params, boolean newCopy) {
        if (params instanceof MultiMapSolrParams) {
            Map<String, String[]> map = ((MultiMapSolrParams)params).getMap();
            if (newCopy) {
                return new HashMap<String, String[]>(map);
            }
            return map;
        }
        if (params instanceof ModifiableSolrParams) {
            Map<String, String[]> map = ((ModifiableSolrParams)params).getMap();
            if (newCopy) {
                return new HashMap<String, String[]>(map);
            }
            return map;
        }
        HashMap<String, String[]> map = new HashMap<String, String[]>();
        Iterator<String> iterator = params.getParameterNamesIterator();
        while (iterator.hasNext()) {
            String name = iterator.next();
            map.put(name, params.getParams(name));
        }
        return map;
    }
}

