/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.tidy.merge;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.cn.dao.exceptions.DataAccessException;
import org.dataone.configuration.Settings;
import org.dataone.service.types.TypeCompareUtil;
import org.dataone.service.types.tidy.TidyAccessMap;
import org.dataone.service.types.tidy.TidyReplicaList;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.SystemMetadata;
import org.dataone.tidy.concurrent.AbstractTidyJob;
import org.dataone.tidy.concurrent.TidyJob;
import org.dataone.tidy.dao.ChangeRecord;
import org.dataone.tidy.dao.MergeStatus;
import org.dataone.tidy.merge.MergeReport;
import org.dataone.tidy.merge.strategy.MergeSystemMetadata;

public class MergeJob
extends AbstractTidyJob
implements TidyJob {
    private static Log logger = LogFactory.getLog(MergeJob.class);
    private static final String ORC_NODE_ID = Settings.getConfiguration().getString("tidy.dao.orc.nodeid");
    private static final String UCSB_NODE_ID = Settings.getConfiguration().getString("tidy.dao.ucsb.nodeid");
    private static final String UNM_NODE_ID = Settings.getConfiguration().getString("tidy.dao.unm.nodeid");

    public MergeJob(Identifier pid) {
        this.pid = pid;
    }

    public MergeJob() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Boolean call() throws Exception {
        logger.info((Object)("Running MergeJob for " + this.getPid().getValue()));
        Boolean returnValue = true;
        MergeReport report = new MergeReport(this.pid);
        try {
            Map<String, SystemMetadata> cnSysmetaMap = this.fetchCNSysmetas();
            if (cnSysmetaMap != null && !cnSysmetaMap.isEmpty()) {
                MergeSystemMetadata mergeStrategy = new MergeSystemMetadata(report, this.getMnReadClient());
                mergeStrategy.mend(cnSysmetaMap);
                this.buildSysmetaChangesReport(cnSysmetaMap, report);
            } else {
                logger.info((Object)("No CN systemmetadata to work with for pid: " + this.pid));
                report.setReview("No CN systemmetadata: probable delete");
            }
        }
        catch (DataAccessException daox) {
            report.setProcessingException((Exception)((Object)daox));
        }
        catch (RuntimeException rte) {
            report.setProcessingException(rte);
        }
        finally {
            if (report.getProcessingException() != null) {
                report.setResultingSystemMetadata(null);
                this.setFailure(report.getProcessingException());
                returnValue = false;
            }
            try {
                this.persistMergeReport(report);
            }
            catch (Exception e) {
                logger.error((Object)e.getMessage(), (Throwable)e);
                this.setFailure(e);
                returnValue = false;
            }
        }
        return returnValue;
    }

    protected Map<String, SystemMetadata> fetchCNSysmetas() throws DataAccessException {
        Map<NodeReference, SystemMetadata> cnSysMetas = this.sysmetaRepo.getSystemMetadata(this.getPid());
        if (cnSysMetas == null || cnSysMetas.isEmpty()) {
            logger.error((Object)("fetchCNSysmetas: sysmetaRepo.getSystemMetadata (pid = " + this.getPid().getValue() + ") returned an empty or null map (" + cnSysMetas + ")"));
        }
        HashMap<String, SystemMetadata> sysmetas = new HashMap<String, SystemMetadata>();
        if (cnSysMetas != null) {
            for (NodeReference nr : cnSysMetas.keySet()) {
                if (cnSysMetas.get(nr) != null) {
                    sysmetas.put(nr.getValue(), cnSysMetas.get(nr));
                    continue;
                }
                logger.warn((Object)(nr.getValue() + " in fetchCNSysmetas cnSysMetas " + "returned a null value (pid = " + this.getPid().getValue() + ")"));
            }
        }
        return sysmetas;
    }

    protected void persistMergeReport(MergeReport report) {
        if (report.getProcessingException() == null) {
            try {
                logger.info((Object)("*****Change Records [repo.Save in] (pid:" + report.getIdentifier().getValue() + "): " + report.getChangeRecordList().size()));
                Iterable cr = this.changesRepo.save(report.getChangeRecordList());
                logger.info((Object)("*****Change Records [repo.Save out] (pid:" + report.getIdentifier().getValue() + "): " + this.countChangeRecordsReturned(cr)));
                if (report.getResultingSystemMetadata() != null) {
                    this.sysmetaRepo.saveSystemMetadata(report.getResultingSystemMetadata());
                }
                report.getMergeResult().setMergeStatus(MergeStatus.SUCCESS);
            }
            catch (Exception e) {
                report.setProcessingException(e);
                e.printStackTrace();
                report.getMergeResult().setMergeStatus(MergeStatus.FAILURE);
                report.setReview(null);
            }
        } else {
            report.getMergeResult().setMergeStatus(MergeStatus.FAILURE);
            report.setReview(null);
        }
        this.resultsRepo.save(report.getMergeResult());
    }

    private Integer countChangeRecordsReturned(Iterable<ChangeRecord> cr) {
        if (cr == null) {
            return null;
        }
        if (cr instanceof Collection) {
            return ((Collection)cr).size();
        }
        int count = 0;
        for (ChangeRecord i : cr) {
            ++count;
        }
        return count;
    }

    public void buildSysmetaChangesReport(Map<String, SystemMetadata> sysmetaMap, MergeReport mergeReport) {
        if (mergeReport.getAuthMnSystemMetadata() != null) {
            SystemMetadata mnSysmeta = mergeReport.getAuthMnSystemMetadata();
            sysmetaMap.put("AuthMN", mnSysmeta);
        }
        if (mergeReport.getResultingSystemMetadata() != null) {
            SystemMetadata resultingSysmeta = mergeReport.getResultingSystemMetadata();
            sysmetaMap.put("resulting", resultingSysmeta);
        }
        HashMap<String, Map<String, String>> d1TypePropMap = new HashMap<String, Map<String, String>>();
        d1TypePropMap.put(ORC_NODE_ID, this.buildSubtypeListing(sysmetaMap.get(ORC_NODE_ID)));
        d1TypePropMap.put(UCSB_NODE_ID, this.buildSubtypeListing(sysmetaMap.get(UCSB_NODE_ID)));
        d1TypePropMap.put(UNM_NODE_ID, this.buildSubtypeListing(sysmetaMap.get(UNM_NODE_ID)));
        d1TypePropMap.put("AuthMN", this.buildSubtypeListing(sysmetaMap.get("AuthMN")));
        d1TypePropMap.put("resulting", this.buildSubtypeListing(sysmetaMap.get("resulting")));
        TreeSet allAttributes = new TreeSet();
        for (String label : d1TypePropMap.keySet()) {
            allAttributes.addAll(((Map)d1TypePropMap.get(label)).keySet());
        }
        for (String attribute : allAttributes) {
            ChangeRecord cr = this.deriveChangeRecord(mergeReport.getIdentifier(), attribute, d1TypePropMap);
            if (cr == null) continue;
            mergeReport.addChangeRecord(cr);
        }
    }

    private ChangeRecord deriveChangeRecord(Identifier pid, String attribute, Map<String, Map<String, String>> subtypeListingsMap) {
        ChangeRecord changeRecord = new ChangeRecord(pid.getValue());
        changeRecord.setAttribute(attribute);
        if (attribute.contains("AccessPolicy") && !attribute.contains("tidy")) {
            return null;
        }
        if (attribute.contains("ReplicaList") && !attribute.contains("tidy")) {
            return null;
        }
        logger.debug((Object)("buildChangeReport for '" + pid.getValue() + "' check property: " + attribute));
        LinkedList<String> distinctValues = new LinkedList<String>();
        Set<String> nodeLabels = subtypeListingsMap.keySet();
        for (String label : nodeLabels) {
            if (subtypeListingsMap.get(label).get("//SystemMetadata").equals("Not Available") && !attribute.equals("//SystemMetadata")) continue;
            String value = (String)((LinkedHashMap)subtypeListingsMap.get(label)).get(attribute);
            if (label.equals(ORC_NODE_ID)) {
                changeRecord.setCnORC(value);
            } else if (label.equals(UNM_NODE_ID)) {
                changeRecord.setCnUNM(value);
            } else if (label.equals(UCSB_NODE_ID)) {
                changeRecord.setCnUCSB(value);
            } else if (label.equals("AuthMN")) {
                changeRecord.setAuthMN(value);
            } else if (label.equals("resulting")) {
                changeRecord.setResulting(value);
            }
            if (attribute.contains("Archived") && (value == null || value.equals("null"))) {
                value = Boolean.FALSE.toString();
            }
            if (value == null) {
                value = "null";
            }
            if (value.equals("")) {
                value = "null";
            }
            if (!distinctValues.contains(value) && !label.equals("AuthMN")) {
                distinctValues.add(value);
                continue;
            }
            if (distinctValues.contains(value) || !label.equals("AuthMN") || !attribute.contains("AccessPolicy")) continue;
            distinctValues.add(value);
        }
        if (distinctValues.size() > 1) {
            return changeRecord;
        }
        return null;
    }

    private Map<String, String> buildSubtypeListing(SystemMetadata smd) {
        LinkedHashMap subtypesMap;
        if (smd != null) {
            TidyAccessMap tam = new TidyAccessMap(smd.getAccessPolicy());
            TidyReplicaList tidyRepls = new TidyReplicaList(smd.getReplicaList());
            subtypesMap = TypeCompareUtil.getD1SubtypesListing((String)"", (Object)smd, (boolean)true);
            LinkedHashMap tamProps = TypeCompareUtil.getD1SubtypesListing((String)"/AccessPolicy/tidy", (Object)tam, (boolean)false);
            LinkedHashMap tidyReplProps = TypeCompareUtil.getD1SubtypesListing((String)"/ReplicaList/tidy", (Object)tidyRepls, (boolean)true);
            subtypesMap.putAll(tamProps);
            subtypesMap.putAll(tidyReplProps);
            subtypesMap.put("//SystemMetadata", "Present");
        } else {
            subtypesMap = new LinkedHashMap();
            subtypesMap.put("//SystemMetadata", "Not Available");
        }
        return subtypesMap;
    }
}

