/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.request;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import javax.servlet.Servlet;
import javax.servlet.jsp.JspFactory;
import org.apache.jasper.Constants;
import org.apache.jasper.JasperException;
import org.apache.jasper.JspCompilationContext;
import org.apache.jasper.Options;
import org.apache.jasper.compiler.Compiler;
import org.apache.jasper.compiler.JavaCompiler;
import org.apache.jasper.compiler.Mangler;
import org.apache.jasper.compiler.SunJavaCompiler;
import org.apache.jasper.runtime.HttpJspBase;
import org.apache.jasper.runtime.JspFactoryImpl;
import org.apache.tomcat.core.BaseInterceptor;
import org.apache.tomcat.core.Context;
import org.apache.tomcat.core.ContextManager;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.core.ServletWrapper;
import org.apache.tomcat.core.TomcatException;
import org.apache.tomcat.request.JspEngineContext1;
import org.apache.tomcat.request.JspInfo;
import org.apache.tomcat.request.JspMangler;
import org.apache.tomcat.request.TomcatOptions;

public class JspInterceptor
extends BaseInterceptor {
    int jspInfoNOTE;
    String javaEncoding = "UTF8";
    static String sep = System.getProperty("path.separator");

    void compile(Request req, JspInfo jspInfo) {
        this.log("Compiling " + jspInfo.realClassPath);
        try {
            File dir = new File(String.valueOf(jspInfo.outputDir) + "/" + jspInfo.pkgDir);
            dir.mkdirs();
            JspMangler mangler = new JspMangler(jspInfo);
            TomcatOptions options = new TomcatOptions();
            JspEngineContext1 ctxt = new JspEngineContext1(req, mangler);
            ctxt.setOptions(options);
            Compiler compiler = new Compiler((JspCompilationContext)ctxt);
            compiler.setMangler((Mangler)mangler);
            compiler.setJavaCompiler(null);
            JspInterceptor jspInterceptor = this;
            synchronized (jspInterceptor) {
                compiler.compile();
            }
            this.javac(this.createJavaCompiler(options), ctxt, mangler);
            if (this.debug > 0) {
                this.log("Compiled to " + jspInfo.realClassPath);
            }
            jspInfo.touch();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void contextInit(Context ctx) throws TomcatException {
        JspFactory.setDefaultFactory((JspFactory)new JspFactoryImpl());
        ctx.getServletLoader().addRepository(ctx.getWorkDir(), ctx.getProtectionDomain());
    }

    public JavaCompiler createJavaCompiler(Options options) throws JasperException {
        SunJavaCompiler javac;
        String compilerPath = options.getJspCompilerPath();
        Class jspCompilerPlugin = options.getJspCompilerPlugin();
        if (jspCompilerPlugin != null) {
            try {
                javac = (JavaCompiler)jspCompilerPlugin.newInstance();
            }
            catch (Exception ex) {
                Constants.message((String)"jsp.warning.compiler.class.cantcreate", (Object[])new Object[]{jspCompilerPlugin, ex}, (int)Integer.MIN_VALUE);
                javac = new SunJavaCompiler();
            }
        } else {
            javac = new SunJavaCompiler();
        }
        if (compilerPath != null) {
            javac.setCompilerPath(compilerPath);
        }
        return javac;
    }

    public void engineInit(ContextManager cm) throws TomcatException {
        super.engineInit(cm);
        this.jspInfoNOTE = cm.getNoteId(3, "tomcat.jspInfoNote");
    }

    public void javac(JavaCompiler javac, JspEngineContext1 ctxt, Mangler mangler) throws JasperException {
        javac.setEncoding(this.javaEncoding);
        String cp = String.valueOf(System.getProperty("java.class.path")) + sep + ctxt.getClassPath() + sep + ctxt.getOutputDir();
        javac.setClasspath(cp);
        if (this.debug > 0) {
            this.log("ClassPath " + cp);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(256);
        javac.setOutputDir(ctxt.getOutputDir());
        javac.setMsgOutput((OutputStream)out);
        String javaFileName = mangler.getJavaFileName();
        boolean status = javac.compile(javaFileName);
        if (!ctxt.keepGenerated()) {
            File javaFile = new File(javaFileName);
            javaFile.delete();
        }
        if (!status) {
            String msg = out.toString();
            throw new JasperException("Unable to compile " + msg);
        }
    }

    void mapJspPage(Request req, JspInfo jspInfo, String servletName, String classN) {
        Context ctx = req.getContext();
        ServletWrapper wrapper = null;
        String servletPath = servletName;
        try {
            wrapper = ctx.getServletByName(servletName);
            if (wrapper == null) {
                wrapper = ctx.addServlet(servletName, classN);
                wrapper.setPath(servletName);
                wrapper.setOrigin(1);
                ctx.addServletMapping(servletPath, servletPath);
                this.log("Added mapping " + servletPath + " path=" + servletPath);
            }
            wrapper.setServletClass(classN);
            wrapper.setNote(this.jspInfoNOTE, jspInfo);
        }
        catch (TomcatException ex) {
            ex.printStackTrace();
            return;
        }
        req.setWrapper(wrapper);
        if (this.debug > 0) {
            this.log("Wrapper " + wrapper);
        }
    }

    public void preServletInit(Context ctx, ServletWrapper sw) throws TomcatException {
        Servlet theServlet = sw.getServlet();
        if (theServlet instanceof HttpJspBase) {
            if (this.debug > 0) {
                this.log("PreServletInit: HttpJspBase.setParentClassLoader" + sw);
            }
            HttpJspBase h = (HttpJspBase)theServlet;
            h.setClassLoader(ctx.getServletLoader().getClassLoader());
        }
    }

    private void precompile() {
    }

    public int requestMap(Request req) {
        ServletWrapper wrapper = req.getWrapper();
        if (wrapper != null && !"jsp".equals(wrapper.getName()) && wrapper.getPath() == null) {
            return 0;
        }
        if (wrapper == null) {
            return 0;
        }
        Context ctx = req.getContext();
        JspInfo jspInfo = (JspInfo)wrapper.getNote(this.jspInfoNOTE);
        if (jspInfo == null) {
            if (this.debug > 0) {
                this.log("New jsp page - no jspInfo ");
            }
            jspInfo = new JspInfo(req);
            this.mapJspPage(req, jspInfo, jspInfo.uri, jspInfo.fullClassN);
        }
        if (jspInfo.jspSource.lastModified() > jspInfo.compileTime) {
            jspInfo.nextVersion();
            this.compile(req, jspInfo);
            this.mapJspPage(req, jspInfo, jspInfo.uri, jspInfo.fullClassN);
        }
        return 0;
    }
}

