/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.session;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.http.HttpSession;
import org.apache.tomcat.core.Request;
import org.apache.tomcat.session.SessionSerializer;
import org.apache.tomcat.session.StandardSession;
import org.apache.tomcat.util.SessionUtil;
import org.apache.tomcat.util.StringManager;

public final class StandardManager
implements Runnable {
    protected boolean distributable;
    protected int maxInactiveInterval = 60;
    protected Vector recycled = new Vector();
    protected Hashtable sessions = new Hashtable();
    private int checkInterval = 60;
    protected int maxActiveSessions = -1;
    private static StringManager sm = StringManager.getManager("org.apache.tomcat.session");
    private Thread thread = null;
    private boolean threadDone = false;
    private String threadName = "StandardManager";

    public void access(HttpSession session) {
        ((StandardSession)session).access();
    }

    void add(StandardSession session) {
        this.sessions.put(session.getId(), session);
    }

    public HttpSession findSession(String id) {
        if (id == null) {
            return null;
        }
        HttpSession s = (HttpSession)this.sessions.get(id);
        if (s == null) {
            return s;
        }
        this.access(s);
        return s;
    }

    public HttpSession[] findSessions() {
        Hashtable hashtable = this.sessions;
        synchronized (hashtable) {
            Vector<String> keys = new Vector<String>();
            Enumeration ids = this.sessions.keys();
            while (ids.hasMoreElements()) {
                String id = (String)ids.nextElement();
                keys.addElement(id);
            }
            HttpSession[] results = new HttpSession[keys.size()];
            int i = 0;
            while (i < results.length) {
                String key = (String)keys.elementAt(i);
                results[i] = (HttpSession)this.sessions.get(key);
                ++i;
            }
            HttpSession[] httpSessionArray = results;
            Object var3_8 = null;
            return httpSessionArray;
        }
    }

    public int getCheckInterval() {
        return this.checkInterval;
    }

    public boolean getDistributable() {
        return this.distributable;
    }

    public int getMaxActiveSessions() {
        return this.maxActiveSessions;
    }

    public int getMaxInactiveInterval() {
        return this.maxInactiveInterval;
    }

    public HttpSession getNewSession(String jsIdent) {
        if (this.maxActiveSessions >= 0 && this.sessions.size() >= this.maxActiveSessions) {
            throw new IllegalStateException(sm.getString("standardManager.createSession.ise"));
        }
        StandardSession session = null;
        Vector vector = this.recycled;
        synchronized (vector) {
            int size = this.recycled.size();
            if (size > 0) {
                session = (StandardSession)this.recycled.elementAt(size - 1);
                this.recycled.removeElementAt(size - 1);
            }
        }
        if (session == null) {
            session = new StandardSession(this);
        }
        session.setNew(true);
        session.setValid(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(this.maxInactiveInterval);
        session.setId(SessionUtil.generateSessionId(jsIdent));
        return session;
    }

    public Hashtable getSessions() {
        return this.sessions;
    }

    public void handleReload(Request req, ClassLoader newLoader) {
        SessionSerializer.doSerialization(req, newLoader, this);
    }

    private void processExpires() {
        long timeNow = System.currentTimeMillis();
        HttpSession[] sessions = this.findSessions();
        int i = 0;
        while (i < sessions.length) {
            int timeIdle;
            int maxInactiveInterval;
            StandardSession session = (StandardSession)sessions[i];
            if (session.isValid() && (maxInactiveInterval = session.getMaxInactiveInterval()) >= 0 && (timeIdle = (int)((timeNow - session.getLatestAccessedTime()) / 1000L)) >= maxInactiveInterval) {
                session.expire();
            }
            ++i;
        }
    }

    void recycle(StandardSession session) {
        this.recycled.addElement(session);
    }

    public void release(HttpSession session) {
    }

    void remove(StandardSession session) {
        this.sessions.remove(session.getId());
    }

    public void run() {
        while (!this.threadDone) {
            this.threadSleep();
            this.processExpires();
        }
    }

    public void setCheckInterval(int checkInterval) {
        this.checkInterval = checkInterval;
    }

    public void setDistributable(boolean distributable) {
        this.distributable = distributable;
    }

    public void setMaxActiveSessions(int max) {
        this.maxActiveSessions = max;
    }

    public void setMaxInactiveInterval(int interval) {
        this.maxInactiveInterval = interval;
    }

    public void setSessionTimeOut(int minutes) {
        if (minutes != -1) {
            this.setMaxInactiveInterval(minutes * 60);
        }
    }

    public void setSessions(Hashtable sessions) {
        Enumeration e = sessions.keys();
        while (e.hasMoreElements()) {
            StandardSession sess = (StandardSession)sessions.get(e.nextElement());
            sess.setManager(this);
        }
        this.sessions = sessions;
    }

    public void start() {
        String sDummy = SessionUtil.generateSessionId(null);
        this.threadStart();
    }

    public void stop() {
        this.threadStop();
        HttpSession[] sessions = this.findSessions();
        int i = 0;
        while (i < sessions.length) {
            StandardSession session = (StandardSession)sessions[i];
            if (session.isValid()) {
                session.expire();
            }
            ++i;
        }
    }

    private void threadSleep() {
        try {
            Thread.sleep((long)this.checkInterval * 1000L);
        }
        catch (InterruptedException interruptedException) {}
    }

    private void threadStart() {
        if (this.thread != null) {
            return;
        }
        this.threadDone = false;
        this.thread = new Thread((Runnable)this, this.threadName);
        this.thread.setDaemon(true);
        this.thread.start();
    }

    private void threadStop() {
        if (this.thread == null) {
            return;
        }
        this.threadDone = true;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {}
        this.thread = null;
    }
}

