/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.util.test;

import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.util.CollectionFactory;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import junit.framework.TestSuite;

public class TestCollectionFactory
extends ModelTestBase {
    public TestCollectionFactory(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestCollectionFactory.class);
    }

    public void testHashMapExists() {
        Map map = CollectionFactory.createHashedMap();
        TestCollectionFactory.assertInstanceOf(Map.class, map);
    }

    public void testHashMapSized() {
        Map map = CollectionFactory.createHashedMap((int)42);
        TestCollectionFactory.assertInstanceOf(Map.class, map);
    }

    public void testHashMapCopy() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("here", "Bristol");
        map.put("there", "Oxford");
        Map copy = CollectionFactory.createHashedMap(map);
        TestCollectionFactory.assertEquals(map, (Object)copy);
    }

    public void testHashSetExists() {
        Set set = CollectionFactory.createHashedSet();
        TestCollectionFactory.assertInstanceOf(Set.class, set);
    }

    public void testHashSetCopy() {
        HashSet<String> s = new HashSet<String>();
        s.add("jelly");
        s.add("concrete");
        Set copy = CollectionFactory.createHashedSet(s);
        TestCollectionFactory.assertEquals(s, (Object)copy);
    }
}

