/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.xmloutput.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.xmloutput.impl.BaseXMLWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

public class TestEntityOutput
extends ModelTestBase {
    public TestEntityOutput(String name) {
        super(name);
    }

    public void testSettingWriterEntityProperty() {
        FakeBaseWriter w = new FakeBaseWriter();
        TestEntityOutput.assertEquals((boolean)false, (boolean)w.getShowDoctypeDeclaration());
        TestEntityOutput.assertEquals((Object)"false", (Object)w.setProperty("showDoctypeDeclaration", "true"));
        TestEntityOutput.assertEquals((boolean)true, (boolean)w.getShowDoctypeDeclaration());
        TestEntityOutput.assertEquals((Object)"true", (Object)w.setProperty("showDoctypeDeclaration", "false"));
        TestEntityOutput.assertEquals((boolean)false, (boolean)w.getShowDoctypeDeclaration());
        TestEntityOutput.assertEquals((Object)"false", (Object)w.setProperty("showDoctypeDeclaration", Boolean.TRUE));
        TestEntityOutput.assertEquals((boolean)true, (boolean)w.getShowDoctypeDeclaration());
        TestEntityOutput.assertEquals((Object)"true", (Object)w.setProperty("showDoctypeDeclaration", Boolean.FALSE));
        TestEntityOutput.assertEquals((boolean)false, (boolean)w.getShowDoctypeDeclaration());
    }

    public void testKnownEntityNames() {
        FakeBaseWriter w = new FakeBaseWriter();
        TestEntityOutput.assertEquals((boolean)true, (boolean)w.isPredefinedEntityName("lt"));
        TestEntityOutput.assertEquals((boolean)true, (boolean)w.isPredefinedEntityName("gt"));
        TestEntityOutput.assertEquals((boolean)true, (boolean)w.isPredefinedEntityName("amp"));
        TestEntityOutput.assertEquals((boolean)true, (boolean)w.isPredefinedEntityName("apos"));
        TestEntityOutput.assertEquals((boolean)true, (boolean)w.isPredefinedEntityName("quot"));
        TestEntityOutput.assertEquals((boolean)false, (boolean)w.isPredefinedEntityName("alt"));
        TestEntityOutput.assertEquals((boolean)false, (boolean)w.isPredefinedEntityName("amper"));
        TestEntityOutput.assertEquals((boolean)false, (boolean)w.isPredefinedEntityName("tapost"));
        TestEntityOutput.assertEquals((boolean)false, (boolean)w.isPredefinedEntityName("gte"));
        TestEntityOutput.assertEquals((boolean)false, (boolean)w.isPredefinedEntityName("rdf"));
        TestEntityOutput.assertEquals((boolean)false, (boolean)w.isPredefinedEntityName("smerp"));
        TestEntityOutput.assertEquals((boolean)false, (boolean)w.isPredefinedEntityName("nl"));
        TestEntityOutput.assertEquals((boolean)false, (boolean)w.isPredefinedEntityName("acute"));
    }

    public void testRDFNamespaceMissing() {
        Model m = TestEntityOutput.createMemModel();
        TestEntityOutput.modelAdd(m, "x R fake:uri#bogus");
        m.setNsPrefix("spoo", "fake:uri#");
        m.setNsPrefix("eh", "eh:/");
        String s = this.checkedModelToString(m);
        this.assertMatches("<!DOCTYPE rdf:RDF \\[", s);
        this.assertMatches("<!ENTITY spoo 'fake:uri#'>", s);
        this.assertMatches("rdf:resource=\"&spoo;bogus\"", s);
    }

    public void testUsesEntityForPrefix() {
        Model m = TestEntityOutput.modelWithStatements("x R fake:uri#bogus");
        m.setNsPrefix("spoo", "fake:uri#");
        m.setNsPrefix("eh", "eh:/");
        String s = this.checkedModelToString(m);
        this.assertMatches("<!DOCTYPE rdf:RDF \\[", s);
        this.assertMatches("<!ENTITY spoo 'fake:uri#'>", s);
        this.assertMatches("rdf:resource=\"&spoo;bogus\"", s);
    }

    public void testCatchesBadEntities() {
        this.testCatchesBadEntity("amp");
        this.testCatchesBadEntity("lt");
        this.testCatchesBadEntity("gt");
        this.testCatchesBadEntity("apos");
        this.testCatchesBadEntity("quot");
    }

    public void testDifficultChars() throws IOException {
        Model m = TestEntityOutput.createMemModel();
        m.read("file:testing/abbreviated/entities.rdf");
        StringWriter w = new StringWriter();
        RDFWriter wr = m.getWriter();
        wr.setProperty("showDoctypeDeclaration", (Object)"true");
        wr.write(m, (Writer)w, "http://example.org/");
        w.close();
        StringReader r = new StringReader(w.toString());
        Model m2 = TestEntityOutput.createMemModel();
        m2.read((Reader)r, "http://example.org/");
        TestEntityOutput.assertIsoModels("showDoctypeDeclaration problem", m, m2);
    }

    private void testCatchesBadEntity(String bad) {
        Model m = TestEntityOutput.modelWithStatements("ampsersand spelt '&'; x R goo:spoo/noo");
        m.setNsPrefix("rdf", RDF.getURI());
        m.setNsPrefix(bad, "goo:spoo");
        m.setNsPrefix("eh", "eh:/");
        String s = this.checkedModelToString(m);
        TestEntityOutput.assertTrue((s.toString().indexOf("<!DOCTYPE rdf:RDF [") >= 0 ? 1 : 0) != 0);
        this.assertMismatches("<!ENTITY " + bad + " ", s);
        this.assertMismatches("rdf:resource=\"&" + bad + ";noo\"", s);
    }

    private void checkModelFromXML(Model shouldBe, String s) {
        Model m = TestEntityOutput.createMemModel();
        m.read((Reader)new StringReader(s), null, "RDF/XML");
        TestEntityOutput.assertIsoModels("model should be read back correctly", shouldBe, m);
    }

    private String checkedModelToString(Model m) {
        String result = this.modelToString(m);
        this.checkModelFromXML(m, result);
        return result;
    }

    private String modelToString(Model m) {
        StringWriter s = new StringWriter();
        RDFWriter w = m.getWriter("RDF/XML-ABBREV");
        w.setProperty("showDoctypeDeclaration", (Object)Boolean.TRUE);
        w.write(m, (Writer)s, null);
        return s.toString();
    }

    private void assertMatches(String pattern, String x) {
        if (!x.matches("(?s).*(" + pattern + ").*")) {
            TestEntityOutput.fail((String)("pattern {" + pattern + "} does not match string {" + x + "}"));
        }
    }

    private void assertMismatches(String pattern, String x) {
        if (x.matches("(?s).*(" + pattern + ").*")) {
            TestEntityOutput.fail((String)("pattern {" + pattern + "} should not match string {" + x + "}"));
        }
    }

    private static final class FakeBaseWriter
    extends BaseXMLWriter {
        private FakeBaseWriter() {
        }

        protected void unblockAll() {
        }

        protected void blockRule(Resource r) {
        }

        protected void writeBody(Model mdl, PrintWriter pw, String baseUri, boolean inclXMLBase) {
        }

        protected boolean getShowDoctypeDeclaration() {
            return this.showDoctypeDeclaration;
        }
    }
}

