/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.shared.test;

import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.shared.PrefixMapping;
import com.hp.hpl.jena.shared.impl.PrefixMappingImpl;
import com.hp.hpl.jena.shared.test.AbstractTestPrefixMapping;
import com.hp.hpl.jena.vocabulary.DC;
import com.hp.hpl.jena.vocabulary.JenaModelSpec;
import com.hp.hpl.jena.vocabulary.OWL;
import com.hp.hpl.jena.vocabulary.RDF;
import com.hp.hpl.jena.vocabulary.RDFS;
import com.hp.hpl.jena.vocabulary.RSS;
import com.hp.hpl.jena.vocabulary.VCARD;
import junit.framework.TestSuite;

public class TestPrefixMapping
extends AbstractTestPrefixMapping {
    public TestPrefixMapping(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestPrefixMapping.class);
    }

    protected PrefixMapping getMapping() {
        return new PrefixMappingImpl();
    }

    public void testStandard() {
        this.testStandard(PrefixMapping.Standard);
    }

    public void testExtended() {
        this.testExtended(PrefixMapping.Extended);
    }

    public void testStandard(PrefixMapping st) {
        TestPrefixMapping.assertEquals((String)RDF.getURI(), (String)st.getNsPrefixURI("rdf"));
        TestPrefixMapping.assertEquals((String)RDFS.getURI(), (String)st.getNsPrefixURI("rdfs"));
        TestPrefixMapping.assertEquals((String)DC.getURI(), (String)st.getNsPrefixURI("dc"));
        TestPrefixMapping.assertEquals((String)OWL.getURI(), (String)st.getNsPrefixURI("owl"));
    }

    public void testExtended(PrefixMapping st) {
        this.testStandard(st);
        TestPrefixMapping.assertEquals((String)"http://www.daml.org/2001/03/daml+oil#", (String)st.getNsPrefixURI("daml"));
        TestPrefixMapping.assertEquals((String)RSS.getURI(), (String)st.getNsPrefixURI("rss"));
        TestPrefixMapping.assertEquals((String)VCARD.getURI(), (String)st.getNsPrefixURI("vcard"));
        TestPrefixMapping.assertEquals((String)JenaModelSpec.getURI(), (String)st.getNsPrefixURI("jms"));
        TestPrefixMapping.assertEquals((String)JA.getURI(), (String)st.getNsPrefixURI("ja"));
        TestPrefixMapping.assertEquals((String)"http://www.example.org/", (String)st.getNsPrefixURI("eg"));
    }
}

