/*
 * Decompiled with CFR 0.152.
 */
package EDU.oswego.cs.dl.util.concurrent.misc;

import java.io.Serializable;

public class Fraction
implements Cloneable,
Comparable,
Serializable {
    protected final long numerator_;
    protected final long denominator_;

    public Fraction(long num, long den) {
        boolean numNonnegative = num >= 0L;
        boolean denNonnegative = den >= 0L;
        long a = numNonnegative ? num : -num;
        long b = denNonnegative ? den : -den;
        long g = Fraction.gcd(a, b);
        this.numerator_ = numNonnegative == denNonnegative ? a / g : -a / g;
        this.denominator_ = b / g;
    }

    public Fraction(Fraction f) {
        this.numerator_ = f.numerator();
        this.denominator_ = f.denominator();
    }

    public double asDouble() {
        return (double)this.numerator() / (double)this.denominator();
    }

    public Object clone() {
        return new Fraction(this);
    }

    public int compareTo(long n) {
        long ad;
        long bn;
        long r;
        long bd;
        long an = this.numerator();
        long l = an * (bd = 1L);
        return l < (r = (bn = n) * (ad = this.denominator())) ? -1 : (l == r ? 0 : 1);
    }

    public int compareTo(Object other) {
        long r;
        Fraction b = (Fraction)other;
        long an = this.numerator();
        long ad = this.denominator();
        long bn = b.numerator();
        long bd = b.denominator();
        long l = an * bd;
        return l < (r = bn * ad) ? -1 : (l == r ? 0 : 1);
    }

    public final long denominator() {
        return this.denominator_;
    }

    public Fraction dividedBy(long n) {
        long an = this.numerator();
        long ad = this.denominator();
        long bn = n;
        long bd = 1L;
        return new Fraction(an * bd, ad * bn);
    }

    public Fraction dividedBy(Fraction b) {
        long an = this.numerator();
        long ad = this.denominator();
        long bn = b.numerator();
        long bd = b.denominator();
        return new Fraction(an * bd, ad * bn);
    }

    public boolean equals(long n) {
        return this.compareTo(n) == 0;
    }

    public boolean equals(Object other) {
        return this.compareTo((Fraction)other) == 0;
    }

    public static long gcd(long a, long b) {
        long y;
        long x;
        if (a < 0L) {
            a = -a;
        }
        if (b < 0L) {
            b = -b;
        }
        if (a >= b) {
            x = a;
            y = b;
        } else {
            x = b;
            y = a;
        }
        while (y != 0L) {
            long t = x % y;
            x = y;
            y = t;
        }
        return x;
    }

    public int hashCode() {
        return (int)(this.numerator_ ^ this.denominator_);
    }

    public Fraction inverse() {
        long an = this.numerator();
        long ad = this.denominator();
        return new Fraction(ad, an);
    }

    public Fraction minus(long n) {
        long an = this.numerator();
        long ad = this.denominator();
        long bn = n;
        long bd = 1L;
        return new Fraction(an * bd - bn * ad, ad * bd);
    }

    public Fraction minus(Fraction b) {
        long an = this.numerator();
        long ad = this.denominator();
        long bn = b.numerator();
        long bd = b.denominator();
        return new Fraction(an * bd - bn * ad, ad * bd);
    }

    public Fraction negative() {
        long an = this.numerator();
        long ad = this.denominator();
        return new Fraction(-an, ad);
    }

    public final long numerator() {
        return this.numerator_;
    }

    public Fraction plus(long n) {
        long an = this.numerator();
        long ad = this.denominator();
        long bn = n;
        long bd = 1L;
        return new Fraction(an * bd + bn * ad, ad * bd);
    }

    public Fraction plus(Fraction b) {
        long an = this.numerator();
        long ad = this.denominator();
        long bn = b.numerator();
        long bd = b.denominator();
        return new Fraction(an * bd + bn * ad, ad * bd);
    }

    public Fraction times(long n) {
        long an = this.numerator();
        long ad = this.denominator();
        long bn = n;
        long bd = 1L;
        return new Fraction(an * bn, ad * bd);
    }

    public Fraction times(Fraction b) {
        long an = this.numerator();
        long ad = this.denominator();
        long bn = b.numerator();
        long bd = b.denominator();
        return new Fraction(an * bn, ad * bd);
    }

    public String toString() {
        if (this.denominator() == 1L) {
            return String.valueOf(this.numerator());
        }
        return String.valueOf(this.numerator()) + "/" + this.denominator();
    }
}

