/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je;

import com.sleepycat.je.CursorConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseUtil;
import com.sleepycat.je.LockMode;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.je.RunRecoveryException;
import com.sleepycat.je.Transaction;
import com.sleepycat.je.dbi.CursorImpl;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.GetMode;
import com.sleepycat.je.dbi.PutMode;
import com.sleepycat.je.latch.Latch;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.DBIN;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.Node;
import com.sleepycat.je.txn.Locker;
import com.sleepycat.je.utilint.InternalException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Cursor {
    CursorImpl cursorImpl;
    CursorConfig config;
    private boolean updateOperationsProhibited;
    private Database dbHandle;
    private DatabaseImpl dbImpl;
    static final /* synthetic */ boolean $assertionsDisabled;

    Cursor(Database dbHandle, Transaction txn, CursorConfig cursorConfig) throws DatabaseException {
        this(dbHandle, txn != null ? txn.getLocker() : null, cursorConfig);
    }

    Cursor(Database dbHandle, Locker locker, CursorConfig cursorConfig) throws DatabaseException {
        if (locker != null && !locker.isTransactional()) {
            locker = null;
        }
        locker = DatabaseUtil.getReadableLocker(dbHandle.getEnvironment(), dbHandle, locker, false);
        this.init(dbHandle, dbHandle.getDatabaseImpl(), locker, dbHandle.isWritable(), cursorConfig);
    }

    Cursor(DatabaseImpl dbImpl, Locker locker, CursorConfig cursorConfig) throws DatabaseException {
        this.init(null, dbImpl, locker, true, cursorConfig);
    }

    private void init(Database dbHandle, DatabaseImpl dbImpl, Locker locker, boolean isWritable, CursorConfig cursorConfig) throws DatabaseException {
        if (cursorConfig == null) {
            cursorConfig = CursorConfig.DEFAULT;
        }
        this.cursorImpl = new CursorImpl(dbImpl, locker, false, cursorConfig);
        this.updateOperationsProhibited = dbImpl.isTransactional() && !locker.isTransactional() || !isWritable;
        this.dbImpl = dbImpl;
        this.dbHandle = dbHandle;
        if (dbHandle != null) {
            dbHandle.addCursor(this);
        }
        this.config = cursorConfig;
    }

    Cursor(Cursor cursor, boolean samePosition) throws DatabaseException {
        this.cursorImpl = cursor.cursorImpl.dup(samePosition);
        this.dbImpl = cursor.dbImpl;
        this.dbHandle = cursor.dbHandle;
        if (this.dbHandle != null) {
            this.dbHandle.addCursor(this);
        }
        this.config = cursor.config;
    }

    CursorImpl getCursorImpl() {
        return this.cursorImpl;
    }

    public Database getDatabase() {
        return this.dbHandle;
    }

    DatabaseImpl getDatabaseImpl() {
        return this.dbImpl;
    }

    public CursorConfig getConfig() {
        return this.config.cloneConfig();
    }

    public synchronized void close() throws DatabaseException {
        this.checkState(false);
        this.cursorImpl.close();
        if (this.dbHandle != null) {
            this.dbHandle.removeCursor(this);
        }
    }

    public int count() throws DatabaseException {
        this.checkState(true);
        this.trace(Level.FINEST, "Cursor.count: ", null);
        return this.countInternal();
    }

    public Cursor dup(boolean samePosition) throws DatabaseException {
        this.checkState(false);
        return new Cursor(this, samePosition);
    }

    public OperationStatus delete() throws DatabaseException {
        this.checkState(true);
        this.checkUpdatesAllowed("delete");
        this.trace(Level.FINEST, "Cursor.delete: ", null);
        return this.deleteInternal();
    }

    public OperationStatus put(DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
        DatabaseUtil.checkForPartialKey(key);
        this.checkUpdatesAllowed("put");
        this.trace(Level.FINEST, "Cursor.put: ", key, data, null);
        return this.putInternal(key, data, PutMode.OVERWRITE);
    }

    public OperationStatus putNoOverwrite(DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
        DatabaseUtil.checkForPartialKey(key);
        this.checkUpdatesAllowed("putNoOverwrite");
        this.trace(Level.FINEST, "Cursor.putNoOverwrite: ", key, data, null);
        return this.putInternal(key, data, PutMode.NOOVERWRITE);
    }

    public OperationStatus putNoDupData(DatabaseEntry key, DatabaseEntry data) throws DatabaseException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
        DatabaseUtil.checkForPartialKey(key);
        this.checkUpdatesAllowed("putNoDupData");
        this.trace(Level.FINEST, "Cursor.putNoDupData: ", key, data, null);
        return this.putInternal(key, data, PutMode.NODUP);
    }

    public OperationStatus putCurrent(DatabaseEntry data) throws DatabaseException {
        this.checkState(true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
        this.checkUpdatesAllowed("putCurrent");
        this.trace(Level.FINEST, "Cursor.putCurrent: ", null, data, null);
        return this.putInternal(null, data, PutMode.CURRENT);
    }

    public OperationStatus getCurrent(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(true);
        this.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getCurrent: ", lockMode);
        return this.getCurrentInternal(key, data, lockMode);
    }

    public OperationStatus getFirst(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getFirst: ", lockMode);
        return this.position(key, data, lockMode, true);
    }

    public OperationStatus getLast(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getLast: ", lockMode);
        return this.position(key, data, lockMode, false);
    }

    public OperationStatus getNext(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getNext: ", lockMode);
        if (this.cursorImpl.isNotInitialized()) {
            return this.position(key, data, lockMode, true);
        }
        return this.retrieveNext(key, data, lockMode, GetMode.NEXT);
    }

    public OperationStatus getNextDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(true);
        this.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getNextDup: ", lockMode);
        return this.retrieveNext(key, data, lockMode, GetMode.NEXT_DUP);
    }

    public OperationStatus getNextNoDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getNextNoDup: ", lockMode);
        if (this.cursorImpl.isNotInitialized()) {
            return this.position(key, data, lockMode, true);
        }
        return this.retrieveNext(key, data, lockMode, GetMode.NEXT_NODUP);
    }

    public OperationStatus getPrev(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getPrev: ", lockMode);
        if (this.cursorImpl.isNotInitialized()) {
            return this.position(key, data, lockMode, false);
        }
        return this.retrieveNext(key, data, lockMode, GetMode.PREV);
    }

    public OperationStatus getPrevDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(true);
        this.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getPrevDup: ", lockMode);
        return this.retrieveNext(key, data, lockMode, GetMode.PREV_DUP);
    }

    public OperationStatus getPrevNoDup(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsNoValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getPrevNoDup: ", lockMode);
        if (this.cursorImpl.isNotInitialized()) {
            return this.position(key, data, lockMode, false);
        }
        return this.retrieveNext(key, data, lockMode, GetMode.PREV_NODUP);
    }

    public OperationStatus getSearchKey(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.trace(Level.FINEST, "Cursor.getSearchKey: ", key, null, lockMode);
        return this.search(key, data, lockMode, CursorImpl.SearchMode.SET);
    }

    public OperationStatus getSearchKeyRange(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", false);
        this.trace(Level.FINEST, "Cursor.getSearchKeyRange: ", key, null, lockMode);
        return this.search(key, data, lockMode, CursorImpl.SearchMode.SET_RANGE);
    }

    public OperationStatus getSearchBoth(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getSearchBoth: ", key, data, lockMode);
        return this.search(key, data, lockMode, CursorImpl.SearchMode.BOTH);
    }

    public OperationStatus getSearchBothRange(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        this.checkState(false);
        this.checkArgsValRequired(key, data);
        this.trace(Level.FINEST, "Cursor.getSearchBothRange: ", key, data, lockMode);
        return this.search(key, data, lockMode, CursorImpl.SearchMode.BOTH_RANGE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int countInternal() throws DatabaseException {
        int n;
        CursorImpl dup;
        block3: {
            CursorImpl original = null;
            dup = null;
            try {
                int count;
                original = this.cursorImpl;
                original.latchBINs();
                dup = original.cloneCursor();
                dup.addCursor();
                original.releaseBINs();
                n = count = dup.count();
                Object var6_5 = null;
                if (original == null) break block3;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (original != null) {
                    original.releaseBINs();
                }
                dup.close();
                throw throwable;
            }
            original.releaseBINs();
        }
        dup.close();
        return n;
    }

    OperationStatus deleteInternal() throws DatabaseException {
        OperationStatus status;
        boolean doNotifyTriggers;
        DatabaseEntry oldKey = null;
        DatabaseEntry oldData = null;
        boolean bl = doNotifyTriggers = this.dbHandle != null && this.dbHandle.hasTriggers();
        if (doNotifyTriggers && (status = this.getCurrentInternal(oldKey = new DatabaseEntry(), oldData = new DatabaseEntry(), LockMode.RMW)) != OperationStatus.SUCCESS) {
            return OperationStatus.KEYEMPTY;
        }
        if (doNotifyTriggers) {
            this.dbHandle.notifyTriggers(this.cursorImpl.getLocker(), oldKey, oldData, null);
        }
        status = this.deleteNoNotify();
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationStatus deleteNoNotify() throws DatabaseException {
        OperationStatus operationStatus;
        OperationStatus status;
        CursorImpl dup;
        CursorImpl original;
        block9: {
            original = null;
            dup = null;
            status = OperationStatus.KEYEMPTY;
            try {
                original = this.cursorImpl;
                original.latchBINs();
                dup = original.cloneCursor();
                dup.addCursor();
                original.releaseBINs();
                dup.latchBINs();
                operationStatus = status = dup.delete();
                Object var6_5 = null;
                if (original == null) break block9;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (original != null) {
                    original.releaseBINs();
                }
                if (dup != null) {
                    dup.releaseBINs();
                }
                if (status == OperationStatus.SUCCESS) {
                    original.close();
                    this.cursorImpl = dup;
                } else {
                    dup.close();
                }
                throw throwable;
            }
            original.releaseBINs();
        }
        if (dup != null) {
            dup.releaseBINs();
        }
        if (status == OperationStatus.SUCCESS) {
            original.close();
            this.cursorImpl = dup;
        } else {
            dup.close();
        }
        return operationStatus;
    }

    OperationStatus putInternal(DatabaseEntry key, DatabaseEntry data, PutMode putMode) throws DatabaseException {
        boolean doNotifyTriggers;
        DatabaseEntry oldData = null;
        boolean bl = doNotifyTriggers = this.dbHandle != null && this.dbHandle.hasTriggers();
        if (doNotifyTriggers && (putMode == PutMode.CURRENT || putMode == PutMode.OVERWRITE)) {
            oldData = new DatabaseEntry();
            if (key == null && putMode == PutMode.CURRENT) {
                key = new DatabaseEntry();
            }
        }
        OperationStatus commitStatus = this.putNoNotify(key, data, putMode, oldData);
        if (doNotifyTriggers && commitStatus == OperationStatus.SUCCESS) {
            if (oldData != null && oldData.getData() == null) {
                oldData = null;
            }
            this.dbHandle.notifyTriggers(this.cursorImpl.getLocker(), key, oldData, data);
        }
        return commitStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationStatus putNoNotify(DatabaseEntry key, DatabaseEntry data, PutMode putMode, DatabaseEntry returnOldData) throws DatabaseException {
        OperationStatus operationStatus;
        CursorImpl dup;
        OperationStatus status;
        CursorImpl original;
        block17: {
            if (data == null) {
                throw new NullPointerException("put passed a null DatabaseEntry arg");
            }
            if (putMode != PutMode.CURRENT && key == null) {
                throw new IllegalArgumentException("put passed a null DatabaseEntry arg");
            }
            original = null;
            status = OperationStatus.NOTFOUND;
            dup = null;
            try {
                original = this.cursorImpl;
                original.latchBINs();
                dup = original.cloneCursor();
                if (putMode == PutMode.CURRENT) {
                    dup.addCursor();
                }
                original.releaseBINs();
                if (putMode == PutMode.CURRENT) {
                    status = dup.putCurrent(data, key, returnOldData);
                } else if (putMode == PutMode.OVERWRITE) {
                    status = dup.put(key, data, returnOldData);
                } else if (putMode == PutMode.NOOVERWRITE) {
                    status = dup.putNoOverwrite(key, data);
                } else if (putMode == PutMode.NODUP) {
                    status = dup.putNoDupData(key, data);
                } else {
                    throw new InternalException("unknown PutMode");
                }
                operationStatus = status;
                Object var10_9 = null;
                if (original == null) break block17;
            }
            catch (Throwable throwable) {
                block19: {
                    block18: {
                        Object var10_10 = null;
                        if (original != null) {
                            original.releaseBINs();
                        }
                        if (status != OperationStatus.SUCCESS) break block18;
                        original.close();
                        this.cursorImpl = dup;
                        break block19;
                    }
                    if (dup == null) break block19;
                    dup.close();
                }
                throw throwable;
            }
            original.releaseBINs();
        }
        if (status == OperationStatus.SUCCESS) {
            original.close();
            this.cursorImpl = dup;
        } else if (dup != null) {
            dup.close();
        }
        return operationStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationStatus position(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, boolean first) throws DatabaseException {
        OperationStatus operationStatus;
        if (key == null || data == null) {
            throw new NullPointerException("getFirst()/getLast() called with a null DatabaseEntry arg");
        }
        OperationStatus status = OperationStatus.NOTFOUND;
        CursorImpl dup = null;
        try {
            dup = this.beginRead(false);
            if (!dup.positionFirstOrLast(first, null)) {
                status = OperationStatus.NOTFOUND;
                if (!$assertionsDisabled && Latch.countLatchesHeld() != 0) {
                    throw new AssertionError((Object)Latch.latchesHeldToString());
                }
            } else {
                if (!$assertionsDisabled && Latch.countLatchesHeld() != 1) {
                    throw new AssertionError((Object)Latch.latchesHeldToString());
                }
                status = dup.getCurrentAlreadyLatched(key, data, lockMode, first);
                if (status != OperationStatus.SUCCESS) {
                    status = dup.getNext(key, data, lockMode, first, false);
                }
            }
            operationStatus = status;
        }
        catch (Throwable throwable) {
            this.cursorImpl.releaseBINs();
            this.endRead(dup, status == OperationStatus.SUCCESS);
            throw throwable;
        }
        this.cursorImpl.releaseBINs();
        this.endRead(dup, status == OperationStatus.SUCCESS);
        return operationStatus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationStatus search(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, CursorImpl.SearchMode searchMode) throws DatabaseException {
        OperationStatus operationStatus;
        if (key == null || data == null) {
            throw new NullPointerException("getSearch passed a null DatabaseEntry arg");
        }
        OperationStatus status = OperationStatus.NOTFOUND;
        CursorImpl dup = null;
        try {
            dup = this.beginRead(false);
            int searchResult = dup.searchAndPosition(key, data, searchMode, lockMode);
            if ((searchResult & 1) != 0) {
                DatabaseEntry useKey;
                boolean exactMatch = (searchResult & 2) != 0;
                boolean exactDataMatch = (searchResult & 4) != 0;
                boolean rangeMatch = false;
                if (searchMode == CursorImpl.SearchMode.SET_RANGE && !exactMatch) {
                    rangeMatch = true;
                }
                if (searchMode == CursorImpl.SearchMode.BOTH_RANGE && !exactDataMatch) {
                    rangeMatch = true;
                }
                DatabaseEntry databaseEntry = useKey = searchMode == CursorImpl.SearchMode.SET ? null : key;
                if (rangeMatch || (status = dup.getCurrentAlreadyLatched(useKey, data, lockMode, true)) == OperationStatus.KEYEMPTY) {
                    if (searchMode == CursorImpl.SearchMode.SET_RANGE) {
                        status = dup.getNext(key, data, lockMode, true, rangeMatch);
                    } else if (searchMode == CursorImpl.SearchMode.SET) {
                        status = dup.getNextDuplicate(key, data, lockMode, true, rangeMatch);
                    } else if (searchMode == CursorImpl.SearchMode.BOTH_RANGE) {
                        if (exactMatch) {
                            boolean alreadyLatched = status != OperationStatus.KEYEMPTY;
                            if ((status = dup.getNextDuplicate(key, data, lockMode, true, alreadyLatched)) == OperationStatus.NOTFOUND && !exactDataMatch) {
                                status = dup.getCurrentAlreadyLatched(useKey, data, lockMode, true);
                            }
                        } else {
                            status = dup.getNext(key, data, lockMode, true, rangeMatch);
                        }
                    }
                }
            }
            operationStatus = status;
            Object var14_14 = null;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            this.cursorImpl.releaseBINs();
            if (status != OperationStatus.SUCCESS && dup != this.cursorImpl) {
                dup.releaseBINs();
            }
            this.endRead(dup, status == OperationStatus.SUCCESS);
            throw throwable;
        }
        this.cursorImpl.releaseBINs();
        if (status != OperationStatus.SUCCESS && dup != this.cursorImpl) {
            dup.releaseBINs();
        }
        this.endRead(dup, status == OperationStatus.SUCCESS);
        return operationStatus;
    }

    /*
     * WARNING - void declaration
     */
    OperationStatus retrieveNext(DatabaseEntry key, DatabaseEntry data, LockMode lockMode, GetMode getMode) throws DatabaseException {
        void var6_6;
        CursorImpl dup;
        if (key == null || data == null) {
            throw new NullPointerException("getNext passed a null DatabaseEntry arg");
        }
        while (true) {
            block12: {
                if (!$assertionsDisabled && Latch.countLatchesHeld() != 0) {
                    throw new AssertionError();
                }
                dup = this.beginRead(true);
                try {
                    OperationStatus ret;
                    if (getMode == GetMode.NEXT) {
                        ret = dup.getNext(key, data, lockMode, true, false);
                        break block12;
                    }
                    if (getMode == GetMode.PREV) {
                        ret = dup.getNext(key, data, lockMode, false, false);
                        break block12;
                    }
                    if (getMode == GetMode.NEXT_DUP) {
                        ret = dup.getNextDuplicate(key, data, lockMode, true, false);
                        break block12;
                    }
                    if (getMode == GetMode.PREV_DUP) {
                        ret = dup.getNextDuplicate(key, data, lockMode, false, false);
                        break block12;
                    }
                    if (getMode == GetMode.NEXT_NODUP) {
                        ret = dup.getNextNoDup(key, data, lockMode, true);
                        break block12;
                    }
                    if (getMode == GetMode.PREV_NODUP) {
                        ret = dup.getNextNoDup(key, data, lockMode, false);
                        break block12;
                    }
                    throw new InternalException("unknown GetMode");
                }
                catch (DatabaseException DBE) {
                    DBE.printStackTrace();
                    this.endRead(dup, false);
                    throw DBE;
                }
            }
            if (!this.checkForInsertion(getMode, this.cursorImpl, dup)) break;
            this.endRead(dup, false);
        }
        this.endRead(dup, var6_6 == OperationStatus.SUCCESS);
        if (!$assertionsDisabled && Latch.countLatchesHeld() != 0) {
            throw new AssertionError();
        }
        return var6_6;
    }

    OperationStatus getCurrentInternal(DatabaseEntry key, DatabaseEntry data, LockMode lockMode) throws DatabaseException {
        return this.cursorImpl.getCurrent(key, data, lockMode);
    }

    private boolean checkForInsertion(GetMode getMode, CursorImpl origCursor, CursorImpl dupCursor) throws DatabaseException {
        BIN origBIN = origCursor.getBIN();
        BIN dupBIN = dupCursor.getBIN();
        DBIN origDBIN = origCursor.getDupBIN();
        boolean forward = true;
        if (getMode == GetMode.PREV || getMode == GetMode.PREV_DUP || getMode == GetMode.PREV_NODUP) {
            forward = false;
        }
        boolean ret = false;
        if (origBIN != dupBIN) {
            origCursor.latchBINs();
            if (origDBIN == null) {
                if (forward) {
                    if (origBIN.getNEntries() - 1 > origCursor.getIndex()) {
                        DatabaseImpl database = origBIN.getDatabase();
                        for (int i = origCursor.getIndex() + 1; i < origBIN.getNEntries(); ++i) {
                            LN ln;
                            Node n;
                            ChildReference entry = origBIN.getEntry(i);
                            if (entry.isKnownDeleted() || (n = entry.fetchTarget(database, origBIN)).containsDuplicates() || (ln = (LN)n).isDeleted()) continue;
                            ret = true;
                            break;
                        }
                    }
                } else if (origCursor.getIndex() > 0) {
                    DatabaseImpl database = origBIN.getDatabase();
                    for (int i = 0; i < origCursor.getIndex(); ++i) {
                        LN ln;
                        Node n;
                        ChildReference entry = origBIN.getEntry(i);
                        if (entry.isKnownDeleted() || (n = entry.fetchTarget(database, origBIN)).containsDuplicates() || (ln = (LN)n).isDeleted()) continue;
                        ret = true;
                        break;
                    }
                }
            }
            origCursor.releaseBINs();
            return ret;
        }
        if (origDBIN != dupCursor.getDupBIN() && origCursor.getIndex() == dupCursor.getIndex() && getMode != GetMode.NEXT_NODUP && getMode != GetMode.PREV_NODUP) {
            origCursor.latchBINs();
            if (forward) {
                if (origDBIN.getNEntries() - 1 > origCursor.getDupIndex()) {
                    DatabaseImpl database = origDBIN.getDatabase();
                    for (int i = origCursor.getDupIndex() + 1; i < origDBIN.getNEntries(); ++i) {
                        Node n;
                        LN ln;
                        ChildReference entry = origDBIN.getEntry(i);
                        if (entry.isKnownDeleted() || (ln = (LN)(n = entry.fetchTarget(database, origDBIN))).isDeleted()) continue;
                        ret = true;
                        break;
                    }
                }
            } else if (origCursor.getDupIndex() > 0) {
                DatabaseImpl database = origDBIN.getDatabase();
                for (int i = 0; i < origCursor.getDupIndex(); ++i) {
                    Node n;
                    LN ln;
                    ChildReference entry = origDBIN.getEntry(i);
                    if (entry.isKnownDeleted() || (ln = (LN)(n = entry.fetchTarget(database, origDBIN))).isDeleted()) continue;
                    ret = true;
                    break;
                }
            }
            origCursor.releaseBINs();
            return ret;
        }
        return false;
    }

    private CursorImpl beginRead(boolean addCursor) throws DatabaseException {
        CursorImpl dup;
        if (this.cursorImpl.isNotInitialized()) {
            dup = this.cursorImpl;
        } else {
            this.cursorImpl.latchBINs();
            dup = this.cursorImpl.cloneCursor();
            if (addCursor) {
                dup.addCursor();
            }
            this.cursorImpl.releaseBINs();
        }
        return dup;
    }

    private void endRead(CursorImpl dup, boolean success) throws DatabaseException {
        if (dup == this.cursorImpl) {
            if (!success) {
                this.cursorImpl.reset();
            }
        } else if (success) {
            this.cursorImpl.close();
            this.cursorImpl = dup;
        } else {
            dup.close();
        }
    }

    private void checkUpdatesAllowed(String operation) throws DatabaseException {
        if (this.updateOperationsProhibited) {
            throw new DatabaseException("A transaction was not supplied when opening this cursor: " + operation);
        }
    }

    private void checkArgsNoValRequired(DatabaseEntry key, DatabaseEntry data) {
        DatabaseUtil.checkForNullDbt(key, "key", false);
        DatabaseUtil.checkForNullDbt(data, "data", false);
    }

    private void checkArgsValRequired(DatabaseEntry key, DatabaseEntry data) {
        DatabaseUtil.checkForNullDbt(key, "key", true);
        DatabaseUtil.checkForNullDbt(data, "data", true);
    }

    void checkState(boolean mustBeInitialized) throws DatabaseException {
        this.checkEnv();
        this.cursorImpl.checkCursorState(mustBeInitialized);
    }

    void checkEnv() throws RunRecoveryException {
        this.cursorImpl.checkEnv();
    }

    void trace(Level level, String methodName, DatabaseEntry key, DatabaseEntry data, LockMode lockMode) {
        Logger logger = this.dbImpl.getDbEnvironment().getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(methodName);
            this.traceCursorImpl(sb);
            if (key != null) {
                sb.append(" key=").append(key.dumpData());
            }
            if (data != null) {
                sb.append(" data=").append(data.dumpData());
            }
            if (lockMode != null) {
                sb.append(" lockMode=").append(lockMode);
            }
            logger.log(level, sb.toString());
        }
    }

    void trace(Level level, String methodName, LockMode lockMode) {
        Logger logger = this.dbImpl.getDbEnvironment().getLogger();
        if (logger.isLoggable(level)) {
            StringBuffer sb = new StringBuffer();
            sb.append(methodName);
            this.traceCursorImpl(sb);
            if (lockMode != null) {
                sb.append(" lockMode=").append(lockMode);
            }
            logger.log(level, sb.toString());
        }
    }

    private void traceCursorImpl(StringBuffer sb) {
        sb.append(" locker=").append(this.cursorImpl.getLocker().getId());
        if (this.cursorImpl.getBIN() != null) {
            sb.append(" bin=").append(this.cursorImpl.getBIN().getNodeId());
        }
        sb.append(" idx=").append(this.cursorImpl.getIndex());
        if (this.cursorImpl.getDupBIN() != null) {
            sb.append(" Dbin=").append(this.cursorImpl.getDupBIN().getNodeId());
        }
        sb.append(" dupIdx=").append(this.cursorImpl.getDupIndex());
    }

    static {
        $assertionsDisabled = !Cursor.class.desiredAssertionStatus();
    }
}

