/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra.op;

import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.OpVisitor;
import com.hp.hpl.jena.sparql.algebra.Transform;
import com.hp.hpl.jena.sparql.algebra.op.Op1;
import com.hp.hpl.jena.sparql.expr.E_LogicalAnd;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.util.NodeIsomorphismMap;

public class OpFilter
extends Op1 {
    private static boolean canonicalize = false;
    ExprList expressions;

    public static Op filter(Expr expr, Op op) {
        if (op instanceof OpFilter) {
            OpFilter f = (OpFilter)op;
            f.getExprs().add(expr);
            return f;
        }
        ExprList exprList = OpFilter.asExprList(expr);
        return new OpFilter(exprList, op);
    }

    public static Op filter(ExprList exprs, Op op) {
        if (exprs.isEmpty()) {
            return op;
        }
        if (op instanceof OpFilter) {
            OpFilter f = (OpFilter)op;
            f.getExprs().addAll(exprs);
            return f;
        }
        return new OpFilter(exprs, op);
    }

    private static ExprList asExprList(Expr expr) {
        ExprList exprList = new ExprList();
        OpFilter.mergeExprList(exprList, expr);
        return exprList;
    }

    private static void mergeExprList(ExprList exprList, Expr expr) {
        if (canonicalize) {
            while (expr instanceof E_LogicalAnd) {
                E_LogicalAnd x = (E_LogicalAnd)expr;
                Expr left = x.getArg1();
                Expr right = x.getArg2();
                OpFilter.mergeExprList(exprList, left);
                expr = right;
            }
        }
        exprList.add(expr);
    }

    private OpFilter(Expr expr, Op sub) {
        super(sub);
        this.expressions = new ExprList();
        this.expressions.add(expr);
    }

    private OpFilter(ExprList exprs, Op sub) {
        super(sub);
        this.expressions = exprs;
    }

    public static OpFilter tidy(OpFilter base) {
        ExprList exprs = new ExprList();
        Op op = base;
        while (op instanceof OpFilter) {
            OpFilter f = op;
            exprs.addAll(f.getExprs());
            op = f.getSubOp();
        }
        return new OpFilter(exprs, op);
    }

    public ExprList getExprs() {
        return this.expressions;
    }

    public String getName() {
        return "filter";
    }

    public Op apply(Transform transform, Op subOp) {
        return transform.transform(this, subOp);
    }

    public void visit(OpVisitor opVisitor) {
        opVisitor.visit(this);
    }

    public Op copy(Op subOp) {
        return new OpFilter(this.expressions, subOp);
    }

    public int hashCode() {
        return this.expressions.hashCode();
    }

    public boolean equalTo(Op other, NodeIsomorphismMap labelMap) {
        if (!(other instanceof OpFilter)) {
            return false;
        }
        OpFilter opFilter = (OpFilter)other;
        if (!this.expressions.equals(opFilter.expressions)) {
            return false;
        }
        return this.getSubOp().equalTo(opFilter.getSubOp(), labelMap);
    }
}

