/*
 * Decompiled with CFR 0.152.
 */
package org.iq80.snappy;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.iq80.snappy.BufferRecycler;
import org.iq80.snappy.Crc32C;
import org.iq80.snappy.Snappy;
import org.iq80.snappy.SnappyInternalUtils;

abstract class AbstractSnappyInputStream
extends InputStream {
    private final InputStream in;
    private final byte[] frameHeader;
    private final boolean verifyChecksums;
    private final BufferRecycler recycler;
    private byte[] input;
    private byte[] uncompressed;
    private boolean closed;
    private boolean eof;
    private int valid;
    private int position;
    private byte[] buffer;

    public AbstractSnappyInputStream(InputStream in, int maxBlockSize, int frameHeaderSize, boolean verifyChecksums, byte[] expectedHeader) throws IOException {
        this.in = in;
        this.verifyChecksums = verifyChecksums;
        this.recycler = BufferRecycler.instance();
        this.allocateBuffersBasedOnSize(maxBlockSize + 5);
        this.frameHeader = new byte[frameHeaderSize];
        byte[] actualHeader = new byte[expectedHeader.length];
        int read = SnappyInternalUtils.readBytes(in, actualHeader, 0, actualHeader.length);
        if (read < expectedHeader.length) {
            throw new EOFException("encountered EOF while reading stream header");
        }
        if (!Arrays.equals(expectedHeader, actualHeader)) {
            throw new IOException("invalid stream header");
        }
    }

    private void allocateBuffersBasedOnSize(int size) {
        this.input = this.recycler.allocInputBuffer(size);
        this.uncompressed = this.recycler.allocDecodeBuffer(size);
    }

    @Override
    public int read() throws IOException {
        if (this.closed) {
            return -1;
        }
        if (!this.ensureBuffer()) {
            return -1;
        }
        return this.buffer[this.position++] & 0xFF;
    }

    @Override
    public int read(byte[] output, int offset, int length) throws IOException {
        SnappyInternalUtils.checkNotNull(output, "output is null", new Object[0]);
        SnappyInternalUtils.checkPositionIndexes(offset, offset + length, output.length);
        if (this.closed) {
            throw new IOException("Stream is closed");
        }
        if (length == 0) {
            return 0;
        }
        if (!this.ensureBuffer()) {
            return -1;
        }
        int size = Math.min(length, this.available());
        System.arraycopy(this.buffer, this.position, output, offset, size);
        this.position += size;
        return size;
    }

    @Override
    public int available() throws IOException {
        if (this.closed) {
            return 0;
        }
        return this.valid - this.position;
    }

    @Override
    public void close() throws IOException {
        try {
            this.in.close();
        }
        finally {
            if (!this.closed) {
                this.closed = true;
                this.recycler.releaseInputBuffer(this.input);
                this.recycler.releaseDecodeBuffer(this.uncompressed);
            }
        }
    }

    private boolean ensureBuffer() throws IOException {
        int actualCrc32c;
        int actualRead;
        if (this.available() > 0) {
            return true;
        }
        if (this.eof) {
            return false;
        }
        if (!this.readBlockHeader()) {
            this.eof = true;
            return false;
        }
        FrameMetaData frameMetaData = this.getFrameMetaData(this.frameHeader);
        if (FrameAction.SKIP == frameMetaData.frameAction) {
            SnappyInternalUtils.skip(this.in, frameMetaData.length);
            return this.ensureBuffer();
        }
        if (frameMetaData.length > this.input.length) {
            this.allocateBuffersBasedOnSize(frameMetaData.length);
        }
        if ((actualRead = SnappyInternalUtils.readBytes(this.in, this.input, 0, frameMetaData.length)) != frameMetaData.length) {
            throw new EOFException("unexpectd EOF when reading frame");
        }
        FrameData frameData = this.getFrameData(this.frameHeader, this.input, actualRead);
        if (FrameAction.UNCOMPRESS == frameMetaData.frameAction) {
            int uncompressedLength = Snappy.getUncompressedLength(this.input, frameData.offset);
            if (uncompressedLength > this.uncompressed.length) {
                this.uncompressed = this.recycler.allocDecodeBuffer(uncompressedLength);
            }
            this.valid = Snappy.uncompress(this.input, frameData.offset, actualRead - frameData.offset, this.uncompressed, 0);
            this.buffer = this.uncompressed;
            this.position = 0;
        } else {
            this.position = frameData.offset;
            this.buffer = this.input;
            this.valid = actualRead;
        }
        if (this.verifyChecksums && frameData.checkSum != (actualCrc32c = Crc32C.maskedCrc32c(this.buffer, this.position, this.valid - this.position))) {
            throw new IOException("Corrupt input: invalid checksum");
        }
        return true;
    }

    protected abstract FrameMetaData getFrameMetaData(byte[] var1) throws IOException;

    protected abstract FrameData getFrameData(byte[] var1, byte[] var2, int var3);

    private boolean readBlockHeader() throws IOException {
        int read = SnappyInternalUtils.readBytes(this.in, this.frameHeader, 0, this.frameHeader.length);
        if (read == -1) {
            return false;
        }
        if (read < this.frameHeader.length) {
            throw new EOFException("encountered EOF while reading block header");
        }
        return true;
    }

    public static final class FrameData {
        final int checkSum;
        final int offset;

        public FrameData(int checkSum, int offset) {
            this.checkSum = checkSum;
            this.offset = offset;
        }
    }

    public static final class FrameMetaData {
        final int length;
        final FrameAction frameAction;

        public FrameMetaData(FrameAction frameAction, int length) {
            this.frameAction = frameAction;
            this.length = length;
        }
    }

    static enum FrameAction {
        RAW,
        SKIP,
        UNCOMPRESS;

    }
}

