/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.client.loader;

import edu.uiuc.ncsa.myproxy.oa4mp.client.ClientEnvironment;
import edu.uiuc.ncsa.myproxy.oa4mp.client.OA4MPServiceProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.client.loader.AbstractClientLoader;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetProvider;
import edu.uiuc.ncsa.security.core.exceptions.MyConfigurationException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.delegation.client.DelegationService;
import edu.uiuc.ncsa.security.delegation.storage.Client;
import edu.uiuc.ncsa.security.delegation.token.TokenForge;
import edu.uiuc.ncsa.security.oauth_1_0a.OAuthTokenForge;
import edu.uiuc.ncsa.security.oauth_1_0a.OAuthUtilities;
import edu.uiuc.ncsa.security.oauth_1_0a.client.DelegationServiceImplProvider;
import edu.uiuc.ncsa.security.oauth_1_0a.client.OAClient;
import edu.uiuc.ncsa.security.util.pkcs.KeyUtil;
import edu.uiuc.ncsa.security.util.ssl.VerifyingHTTPClientFactory;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Date;
import java.util.HashMap;
import javax.inject.Provider;
import org.apache.commons.configuration.tree.ConfigurationNode;

public class ClientLoader<T extends ClientEnvironment>
extends AbstractClientLoader<T> {
    AssetProvider assetProvider;

    public String getVersionString() {
        return "OA4MP Client configuration loader, version 3.3";
    }

    public ClientLoader(ConfigurationNode configurationNode) {
        super(configurationNode);
    }

    public T createInstance(Provider<TokenForge> tokenForgeProvider, Provider<Client> clientProvider, HashMap<String, String> constants) {
        ClientEnvironment ce = null;
        try {
            ce = new ClientEnvironment(this.myLogger, constants, this.getAccessTokenURI(), this.getAuthorizeURI(), this.getCallback(), this.getInitiateURI(), this.getAssetURI(), this.checkCertLifetime(), this.getId(), this.checkPrivateKey(), this.checkPublicKey(), this.getSkin(), this.isEnableAssetCleanup(), this.getMaxAssetLifetime(), this.getKeypairLifetime(), this.getAssetProvider(), clientProvider, tokenForgeProvider, this.getDSP(), this.getAssetStoreProvider(), this.isShowRedirectPage(), this.getErrorPagePath(), this.getRedirectPagePath(), this.getSuccessPagePath());
        }
        catch (IOException e) {
            throw new MyConfigurationException("Error; Could not configure environment", (Throwable)e);
        }
        this.init();
        return (T)ce;
    }

    protected void init() {
        VerifyingHTTPClientFactory clientFactory = new VerifyingHTTPClientFactory(this.myLogger, this.getSSLConfiguration());
        OAuthUtilities.setClientFactory((VerifyingHTTPClientFactory)clientFactory);
    }

    public AssetProvider getAssetProvider() {
        if (this.assetProvider == null) {
            this.assetProvider = new AssetProvider();
        }
        return this.assetProvider;
    }

    protected boolean isShowRedirectPage() {
        String temp = this.getCfgValue("showRedirectPage");
        if (temp == null || temp.length() == 0) {
            return false;
        }
        return Boolean.parseBoolean(this.getCfgValue("showRedirectPage"));
    }

    protected String getErrorPagePath() {
        return this.getCfgValue("errorPagePath");
    }

    protected String getSuccessPagePath() {
        return this.getCfgValue("successPagePath");
    }

    protected String getRedirectPagePath() {
        return this.getCfgValue("redirectPagePath");
    }

    public T createInstance() {
        Provider<TokenForge> tokenForgeProvider = new Provider<TokenForge>(){

            public TokenForge get() {
                return new OAuthTokenForge(ClientLoader.this.getId());
            }
        };
        Provider<Client> clientProvider = new Provider<Client>(){

            public Client get() {
                OAClient c = new OAClient(BasicIdentifier.newID((String)ClientLoader.this.getId()));
                c.setSignatureMethod("RSA-SHA1");
                c.setCreationTS(new Date());
                return c;
            }
        };
        HashMap<String, String> constants = new HashMap<String, String>();
        constants.put("oa4mp:callback_uri", "oauth_callback");
        constants.put("oa4mp:form_encoding", "UTF-8");
        constants.put("oa4mp:token", "oauth_token");
        constants.put("oa4mp:verifier", "oauth_verifier");
        return this.createInstance(tokenForgeProvider, clientProvider, constants);
    }

    protected PrivateKey checkPrivateKey() throws IOException {
        String privateKeyFileName = this.getCfgValue("privateKeyFile");
        if (this.trivial(privateKeyFileName)) {
            throw new MyConfigurationException("Error: There is no private key specified.");
        }
        File privateKeyFile = new File(privateKeyFileName);
        if (!privateKeyFile.exists()) {
            throw new MyConfigurationException("Error: The specified private key file \"" + privateKeyFileName + "\" does not exist");
        }
        if (!privateKeyFile.isFile()) {
            throw new MyConfigurationException("Error: The specified private key file \"" + privateKeyFileName + "\" is not actually a file");
        }
        if (!privateKeyFile.canRead()) {
            throw new MyConfigurationException("Error: The specified private key file \"" + privateKeyFileName + "\" is not readable. Check the permissions.");
        }
        return KeyUtil.fromPKCS8PEM((Reader)new FileReader(privateKeyFile));
    }

    protected PublicKey checkPublicKey() throws IOException {
        String publicKeyFileName = this.getCfgValue("publicKeyFile");
        if (this.trivial(publicKeyFileName)) {
            throw new MyConfigurationException("Error: There is no public key specified.");
        }
        File publicKeyFile = new File(publicKeyFileName);
        if (!publicKeyFile.exists()) {
            throw new MyConfigurationException("Error: The specified public key file \"" + publicKeyFileName + "\" does not exist");
        }
        if (!publicKeyFile.isFile()) {
            throw new MyConfigurationException("Error: The specified public key file \"" + publicKeyFileName + "\" is not actually a file");
        }
        if (!publicKeyFile.canRead()) {
            throw new MyConfigurationException("Error: The specified public key file \"" + publicKeyFileName + "\" is not readable. Check the permissions.");
        }
        return KeyUtil.fromX509PEM((Reader)new FileReader(publicKeyFile));
    }

    public OA4MPServiceProvider getServiceProvider() {
        return new OA4MPServiceProvider(this.load());
    }

    protected Provider<DelegationService> getDSP() {
        if (this.dsp == null) {
            this.dsp = new DelegationServiceImplProvider(this.getInitiateURI(), this.getAccessTokenURI(), this.getAssetURI());
        }
        return this.dsp;
    }
}

