/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.expr.aggregate;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.sparql.engine.binding.Binding;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.expr.NodeValue;
import com.hp.hpl.jena.sparql.expr.aggregate.Accumulator;
import com.hp.hpl.jena.sparql.expr.aggregate.AccumulatorDistinctExpr;
import com.hp.hpl.jena.sparql.expr.aggregate.Aggregator;
import com.hp.hpl.jena.sparql.expr.aggregate.AggregatorBase;
import com.hp.hpl.jena.sparql.function.FunctionEnv;
import com.hp.hpl.jena.sparql.graph.NodeConst;

public class AggCountVarDistinct
extends AggregatorBase {
    public AggCountVarDistinct(Expr expr) {
        super("COUNT", true, expr);
    }

    @Override
    public Aggregator copy(ExprList exprs) {
        return new AggCountVarDistinct(exprs.get(0));
    }

    @Override
    public Accumulator createAccumulator() {
        return new AccCountVarDistinct();
    }

    @Override
    public Node getValueEmpty() {
        return NodeConst.nodeZero;
    }

    @Override
    public int hashCode() {
        return 0x174 ^ this.exprList.hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AggCountVarDistinct)) {
            return false;
        }
        AggCountVarDistinct agg = (AggCountVarDistinct)other;
        return agg.getExpr().equals(this.getExpr());
    }

    class AccCountVarDistinct
    extends AccumulatorDistinctExpr {
        private long count;

        public AccCountVarDistinct() {
            super(AggCountVarDistinct.this.getExpr());
            this.count = 0L;
        }

        @Override
        public void accumulateDistinct(NodeValue nv, Binding binding, FunctionEnv functionEnv) {
            ++this.count;
        }

        @Override
        protected void accumulateError(Binding binding, FunctionEnv functionEnv) {
        }

        @Override
        public NodeValue getValue() {
            return this.getAccValue();
        }

        @Override
        public NodeValue getAccValue() {
            return NodeValue.makeInteger(this.count);
        }
    }
}

