/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot;

import com.hp.hpl.jena.util.FileUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.apache.jena.atlas.lib.DS;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.atlas.web.MediaType;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.LangBuilder;
import org.apache.jena.riot.RDFParserRegistry;
import org.apache.jena.riot.RiotException;

public class RDFLanguages {
    public static final String strLangRDFXML = "RDF/XML";
    public static final String strLangTurtle = "Turtle";
    public static final String strLangNTriples = "N-Triples";
    public static final String strLangN3 = "N3";
    public static final String strLangRDFJSON = "RDF/JSON";
    public static final String strLangJSONLD = "JSON-LD";
    public static final String strLangNQuads = "N-Quads";
    public static final String strLangTriG = "TriG";
    public static final String strLangCSV = "CSV";
    public static final String strLangTriX = "TriX";
    public static final String strLangRDFTHRIFT = "RDF-THRIFT";
    public static final Lang RDFXML = LangBuilder.create("RDF/XML", "application/rdf+xml").addAltNames("RDFXML", "RDF/XML-ABBREV", "RDFXML-ABBREV").addFileExtensions("rdf", "owl", "xml").build();
    public static final Lang TURTLE;
    public static final Lang TTL;
    public static final Lang N3;
    public static final Lang NTRIPLES;
    public static final Lang NT;
    public static final Lang JSONLD;
    public static final Lang RDFJSON;
    public static final Lang TRIG;
    public static final Lang NQUADS;
    public static final Lang NQ;
    public static final Lang CSV;
    public static final Lang THRIFT;
    public static final Lang TEXT;
    public static final Lang TRIX;
    public static final Lang RDFNULL;
    private static Map<String, Lang> mapLabelToLang;
    private static Map<String, Lang> mapContentTypeToLang;
    private static Map<String, Lang> mapFileExtToLang;

    public static Collection<Lang> getRegisteredLanguages() {
        return Collections.unmodifiableCollection(mapLabelToLang.values());
    }

    public static void init() {
    }

    private static synchronized void init$() {
        RDFLanguages.initStandard();
        Lang.RDFXML = RDFXML;
        Lang.NTRIPLES = NTRIPLES;
        Lang.NT = NT;
        Lang.N3 = N3;
        Lang.TURTLE = TURTLE;
        Lang.TTL = TTL;
        Lang.JSONLD = JSONLD;
        Lang.RDFJSON = RDFJSON;
        Lang.NQUADS = NQUADS;
        Lang.NQ = NQ;
        Lang.TRIG = TRIG;
        Lang.RDFTHRIFT = THRIFT;
        Lang.CSV = CSV;
        Lang.TRIX = TRIX;
        Lang.RDFNULL = RDFNULL;
    }

    private static void initStandard() {
        RDFLanguages.register(RDFXML);
        RDFLanguages.register(TURTLE);
        RDFLanguages.register(N3);
        RDFLanguages.register(NTRIPLES);
        RDFLanguages.register(JSONLD);
        RDFLanguages.register(RDFJSON);
        RDFLanguages.register(TRIG);
        RDFLanguages.register(NQUADS);
        RDFLanguages.register(THRIFT);
        RDFLanguages.register(CSV);
        RDFLanguages.register(TRIX);
        RDFLanguages.register(RDFNULL);
        String clsName = "com.github.jsonldjava.core.JsonLdProcessor";
        try {
            Class.forName(clsName);
        }
        catch (ClassNotFoundException ex) {
            Log.warn(RDFLanguages.class, "java-jsonld classes not on the classpath - JSON-LD input-output not available.");
            Log.warn(RDFLanguages.class, "Minimum jarfiles are jsonld-java, jackson-core, jackson-annotations");
            Log.warn(RDFLanguages.class, "If using a Jena distribution, put all jars in the lib/ directory on the classpath");
            return;
        }
    }

    public static void register(Lang lang) {
        if (lang == null) {
            throw new IllegalArgumentException("null for language");
        }
        RDFLanguages.checkRegistration(lang);
        mapLabelToLang.put(RDFLanguages.canonicalKey(lang.getLabel()), lang);
        for (String altName : lang.getAltNames()) {
            mapLabelToLang.put(RDFLanguages.canonicalKey(altName), lang);
        }
        mapContentTypeToLang.put(RDFLanguages.canonicalKey(lang.getContentType().getContentType()), lang);
        for (String ct : lang.getAltContentTypes()) {
            mapContentTypeToLang.put(RDFLanguages.canonicalKey(ct), lang);
        }
        for (String ext : lang.getFileExtensions()) {
            if (ext.startsWith(".")) {
                ext = ext.substring(1);
            }
            mapFileExtToLang.put(RDFLanguages.canonicalKey(ext), lang);
        }
    }

    private static void checkRegistration(Lang lang) {
        if (lang == null) {
            return;
        }
        String label = RDFLanguages.canonicalKey(lang.getLabel());
        Lang lang2 = mapLabelToLang.get(label);
        if (lang2 == null) {
            return;
        }
        if (lang.equals(lang2)) {
            return;
        }
        if (mapContentTypeToLang.containsKey(lang.getContentType().getContentType())) {
            String k = lang.getContentType().getContentType();
            RDFLanguages.error("Language overlap: " + lang + " and " + mapContentTypeToLang.get(k) + " on content type " + k);
        }
        for (String altName : lang.getAltNames()) {
            if (!mapLabelToLang.containsKey(altName)) continue;
            RDFLanguages.error("Language overlap: " + lang + " and " + mapLabelToLang.get(altName) + " on name " + altName);
        }
        for (String ct : lang.getAltContentTypes()) {
            if (!mapContentTypeToLang.containsKey(ct)) continue;
            RDFLanguages.error("Language overlap: " + lang + " and " + mapContentTypeToLang.get(ct) + " on content type " + ct);
        }
        for (String ext : lang.getFileExtensions()) {
            if (!mapFileExtToLang.containsKey(ext)) continue;
            RDFLanguages.error("Language overlap: " + lang + " and " + mapFileExtToLang.get(ext) + " on file extension type " + ext);
        }
    }

    public static void unregister(Lang lang) {
        if (lang == null) {
            throw new IllegalArgumentException("null for language");
        }
        RDFLanguages.checkRegistration(lang);
        mapLabelToLang.remove(RDFLanguages.canonicalKey(lang.getLabel()));
        mapContentTypeToLang.remove(RDFLanguages.canonicalKey(lang.getContentType().getContentType()));
        for (String ct : lang.getAltContentTypes()) {
            mapContentTypeToLang.remove(RDFLanguages.canonicalKey(ct));
        }
        for (String ext : lang.getFileExtensions()) {
            mapFileExtToLang.remove(RDFLanguages.canonicalKey(ext));
        }
    }

    public static boolean isRegistered(Lang lang) {
        if (lang == null) {
            throw new IllegalArgumentException("null for language");
        }
        String label = RDFLanguages.canonicalKey(lang.getLabel());
        Lang lang2 = mapLabelToLang.get(label);
        if (lang2 == null) {
            return false;
        }
        RDFLanguages.checkRegistration(lang);
        return true;
    }

    public static boolean isTriples(Lang lang) {
        return RDFParserRegistry.isTriples(lang);
    }

    public static boolean isQuads(Lang lang) {
        return RDFParserRegistry.isQuads(lang);
    }

    public static Lang contentTypeToLang(String contentType) {
        if (contentType == null) {
            return null;
        }
        String key = RDFLanguages.canonicalKey(contentType);
        return mapContentTypeToLang.get(key);
    }

    public static Lang contentTypeToLang(ContentType ct) {
        if (ct == null) {
            return null;
        }
        String key = RDFLanguages.canonicalKey(ct.getContentType());
        return mapContentTypeToLang.get(key);
    }

    public static String getCharsetForContentType(String contentType) {
        MediaType ct = MediaType.create(contentType);
        if (ct.getCharset() != null) {
            return ct.getCharset();
        }
        String mt = ct.getContentType();
        if ("application/n-triples".equals(mt)) {
            return "utf-8";
        }
        if ("text/plain".equals(mt)) {
            return "ascii";
        }
        if ("application/n-quads".equals(mt)) {
            return "utf-8";
        }
        if ("text/n-quads".equals(mt)) {
            return "ascii";
        }
        if ("text/nquads".equals(mt)) {
            return "ascii";
        }
        return "utf-8";
    }

    public static Lang shortnameToLang(String label) {
        if (label == null) {
            return null;
        }
        String key = RDFLanguages.canonicalKey(label);
        return mapLabelToLang.get(key);
    }

    public static Lang fileExtToLang(String ext) {
        if (ext == null) {
            return null;
        }
        if (ext.startsWith(".")) {
            ext = ext.substring(1);
        }
        ext = RDFLanguages.canonicalKey(ext);
        return mapFileExtToLang.get(ext);
    }

    public static Lang resourceNameToLang(String resourceName) {
        return RDFLanguages.filenameToLang(resourceName);
    }

    public static Lang resourceNameToLang(String resourceName, Lang dftLang) {
        return RDFLanguages.filenameToLang(resourceName, dftLang);
    }

    public static Lang filenameToLang(String filename) {
        if (filename == null) {
            return null;
        }
        if (filename.endsWith(".gz")) {
            filename = filename.substring(0, filename.length() - 3);
        }
        return RDFLanguages.fileExtToLang(FileUtils.getFilenameExt((String)filename));
    }

    public static Lang filenameToLang(String filename, Lang dftLang) {
        Lang lang = RDFLanguages.filenameToLang(filename);
        return lang == null ? dftLang : lang;
    }

    public static Lang nameToLang(String langName) {
        if (langName == null) {
            return null;
        }
        Lang lang = RDFLanguages.shortnameToLang(langName);
        if (lang != null) {
            return lang;
        }
        lang = RDFLanguages.contentTypeToLang(langName);
        return lang;
    }

    static String canonicalKey(String x) {
        return x.toLowerCase(Locale.ROOT);
    }

    public static ContentType guessContentType(String resourceName) {
        if (resourceName == null) {
            return null;
        }
        Lang lang = RDFLanguages.filenameToLang(resourceName);
        if (lang == null) {
            return null;
        }
        return lang.getContentType();
    }

    private static void error(String message) {
        throw new RiotException(message);
    }

    public static boolean sameLang(Lang lang1, Lang lang2) {
        if (lang1 == null || lang2 == null) {
            return false;
        }
        if (lang1 == lang2) {
            return true;
        }
        return lang1.getLabel() == lang2.getLabel();
    }

    static {
        TTL = TURTLE = LangBuilder.create(strLangTurtle, "text/turtle").addAltNames("TTL").addAltContentTypes("application/turtle", "application/x-turtle").addFileExtensions("ttl").build();
        N3 = LangBuilder.create(strLangN3, "text/rdf+n3").addAltContentTypes("text/rdf+n3", "application/n3", "text/n3").addFileExtensions("n3").build();
        NT = NTRIPLES = LangBuilder.create(strLangNTriples, "application/n-triples").addAltNames("NT", "NTriples", "NTriple", "N-Triple", strLangNTriples).addAltContentTypes("text/plain").addFileExtensions("nt").build();
        JSONLD = LangBuilder.create(strLangJSONLD, "application/ld+json").addAltNames("JSONLD").addFileExtensions("jsonld").build();
        RDFJSON = LangBuilder.create(strLangRDFJSON, "application/rdf+json").addAltNames("RDFJSON").addFileExtensions("rj", "json").build();
        TRIG = LangBuilder.create(strLangTriG, "text/trig").addAltContentTypes("application/x-trig", "application/trig").addFileExtensions("trig").build();
        NQ = NQUADS = LangBuilder.create(strLangNQuads, "application/n-quads").addAltNames("NQ", "NQuads", "NQuad", "N-Quad", strLangNQuads).addAltContentTypes("text/n-quads", "text/nquads").addFileExtensions("nq").build();
        CSV = LangBuilder.create(strLangCSV, "text/csv").addAltNames("csv").addFileExtensions("csv").build();
        THRIFT = LangBuilder.create(strLangRDFTHRIFT, "application/rdf+thrift").addAltNames("RDF_THRIFT", "RDFTHRIFT", "RDF/THRIFT", "TRDF").addFileExtensions("rt", "trdf").build();
        TEXT = LangBuilder.create("text", "text/plain").addAltNames("TEXT").addFileExtensions("txt").build();
        TRIX = LangBuilder.create(strLangTriX, "application/trix").addAltContentTypes("application/trix+xml").addAltNames("TRIX", "trix").addFileExtensions("trix").build();
        RDFNULL = LangBuilder.create("rdf/null", "null/rdf").addAltNames("NULL", "null").build();
        mapLabelToLang = DS.map();
        mapContentTypeToLang = DS.map();
        mapFileExtToLang = DS.map();
        RDFLanguages.init$();
    }
}

