/*
 * Decompiled with CFR 0.152.
 */
package org.ecoinformatics.datamanager.parser;

import edu.ucsb.nceas.utilities.XMLUtilities;
import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.ecoinformatics.datamanager.parser.Entity;
import org.ecoinformatics.datamanager.parser.Party;
import org.ecoinformatics.datamanager.quality.EntityReport;
import org.ecoinformatics.datamanager.quality.QualityCheck;
import org.ecoinformatics.datamanager.quality.QualityReport;
import org.ecoinformatics.eml.EMLParser;
import org.ecoinformatics.eml.SAXValidate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DataPackage {
    private static final String IDENTIFIER_WITH_LEADING_ZERO_PATTERN = "^[A-Za-z_0-9\\-]+\\.0\\d+\\.\\d+$";
    private static final String REVISION_WITH_LEADING_ZERO_PATTERN = "^[A-Za-z_0-9\\-]+\\.\\d+\\.0\\d+$";
    private static final String METACAT_PACKAGE_ID_PATTERN = "^[A-Za-z_0-9\\-]+\\.\\d+\\.\\d+$";
    private static String scopeRegistry = null;
    private String accessXML = null;
    private String emlNamespace = null;
    private Entity[] entityList = null;
    private boolean parserValid = false;
    private boolean schemaValid = false;
    private int numberOfKeywordElements = 0;
    private int numberOfMethodsElements = 0;
    private int numberOfCoverageElements = 0;
    private int numberOfGeographicCoverageElements = 0;
    private int numberOfTaxonomicCoverageElements = 0;
    private int numberOfTemporalCoverageElements = 0;
    private String packageId = null;
    private String pubDate;
    private QualityReport qualityReport = null;
    private String system = null;
    private String title = null;
    private List<Party> creators = null;
    private String language = null;
    private List<String> keywords = null;
    private String abstract_str = null;
    private Party publisher = null;

    public DataPackage(String packageId) {
        this.packageId = packageId;
        this.qualityReport = new QualityReport(this);
        this.creators = new ArrayList<Party>();
        this.keywords = new ArrayList<String>();
        this.qualityCheckPackageId(packageId);
    }

    public static String dereferenceEML(String originalEmlString) throws IllegalStateException {
        String dereferencedEmlString = "";
        StringWriter stringWriter = new StringWriter();
        String xslPath = QualityReport.getEmlDereferencerXSLTPath();
        File xsltFile = new File(xslPath);
        StringReader stringReader = new StringReader(originalEmlString);
        StreamSource xmlSource = new StreamSource(stringReader);
        StreamSource xsltSource = new StreamSource(xsltFile);
        StreamResult result = new StreamResult(stringWriter);
        String transformerFactoryValue = System.getProperty("javax.xml.transform.TransformerFactory");
        System.out.println("javax.xml.transform.TransformerFactory :" + transformerFactoryValue);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer(xsltSource);
            transformer.transform(xmlSource, result);
            dereferencedEmlString = stringWriter.toString();
        }
        catch (TransformerConfigurationException e) {
            Throwable x = e;
            if (e.getException() != null) {
                x = e.getException();
            }
            ((Throwable)x).printStackTrace();
            throw new IllegalStateException(e);
        }
        catch (TransformerException e) {
            Throwable x = e;
            if (e.getException() != null) {
                x = e.getException();
            }
            ((Throwable)x).printStackTrace();
            throw new IllegalStateException(e);
        }
        return dereferencedEmlString;
    }

    public static void setScopeRegistry(String scopeRegistry) {
        DataPackage.scopeRegistry = scopeRegistry;
    }

    public void addDatasetQualityCheck(QualityCheck qualityCheck) {
        if (this.qualityReport != null) {
            this.qualityReport.addDatasetQualityCheck(qualityCheck);
        }
    }

    public String getAccessXML() {
        return this.accessXML;
    }

    public String getEmlNamespace() {
        return this.emlNamespace;
    }

    public Entity[] getEntities(String name) {
        Vector<Entity> list = new Vector<Entity>();
        if (this.entityList != null) {
            for (int i = 0; i < this.entityList.length; ++i) {
                if (!this.entityList[i].getName().equals(name)) continue;
                list.add(this.entityList[i]);
            }
        }
        return list.toArray(new Entity[0]);
    }

    public Entity getEntity(String name) {
        if (this.getEntities(name).length > 0) {
            return this.getEntities(name)[0];
        }
        return null;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(List<String> keywords) {
        this.keywords = keywords;
    }

    public String getAbstract() {
        return this.abstract_str;
    }

    public void setAbstract(String abstract_str) {
        this.abstract_str = abstract_str;
    }

    public String findDuplicateEntityName() {
        String duplicateName = null;
        Entity[] entityArray = this.getEntityList();
        if (entityArray != null) {
            int len = entityArray.length;
            TreeSet<String> treeSet = new TreeSet<String>();
            for (int i = 0; i < len; ++i) {
                Entity entity = entityArray[i];
                String entityName = entity.getName();
                if (entityName == null) continue;
                if (treeSet.contains(entityName)) {
                    duplicateName = entityName;
                    break;
                }
                treeSet.add(entityName);
            }
        }
        return duplicateName;
    }

    public void add(Entity entity) {
        this.addEntityIntoArray(entity);
    }

    public Entity[] getEntityList() {
        return this.entityList;
    }

    public int getEntityNumber() {
        if (this.entityList == null) {
            return 0;
        }
        return this.entityList.length;
    }

    public QualityReport getQualityReport() {
        return this.qualityReport;
    }

    public String getSystem() {
        return this.system;
    }

    public String getPackageId() {
        return this.packageId;
    }

    private void addEntityIntoArray(Entity entity) {
        if (this.entityList == null) {
            this.entityList = new Entity[1];
            this.entityList[0] = entity;
        } else {
            int size = this.entityList.length;
            Entity[] tmp = new Entity[size + 1];
            for (int i = 0; i < size; ++i) {
                tmp[i] = this.entityList[i];
            }
            tmp[size] = entity;
            this.entityList = tmp;
        }
    }

    public void clearEntityList() {
        this.entityList = null;
    }

    public boolean hasDatasetQualityError() {
        boolean hasError = this.qualityReport != null && this.qualityReport.hasDatasetQualityError();
        return hasError;
    }

    public boolean hasEntityQualityError() {
        boolean hasError = false;
        Entity[] entityArray = this.getEntityList();
        for (int i = 0; i < entityArray.length; ++i) {
            Entity entity = entityArray[i];
            EntityReport entityReport = entity.getEntityReport();
            if (entityReport == null || !entityReport.hasEntityQualityError()) continue;
            hasError = true;
        }
        return hasError;
    }

    public int getNumberOfKeywordElements() {
        return this.numberOfKeywordElements;
    }

    public int getNumberOfMethodsElements() {
        return this.numberOfMethodsElements;
    }

    public boolean hasQualityError() {
        return this.hasDatasetQualityError() || this.hasEntityQualityError();
    }

    private boolean identifierHasLeadingZero(String packageId) {
        boolean hasLeadingZero = false;
        String regexPattern = IDENTIFIER_WITH_LEADING_ZERO_PATTERN;
        hasLeadingZero = Pattern.matches(regexPattern, packageId);
        return hasLeadingZero;
    }

    private boolean revisionHasLeadingZero(String packageId) {
        boolean hasLeadingZero = false;
        String regexPattern = REVISION_WITH_LEADING_ZERO_PATTERN;
        hasLeadingZero = Pattern.matches(regexPattern, packageId);
        return hasLeadingZero;
    }

    public boolean isParserValid() {
        return this.parserValid;
    }

    public boolean isSchemaValid() {
        return this.schemaValid;
    }

    private boolean isValidPackageIdForMetacat(String packageId) {
        boolean isValid = true;
        String regexPattern = METACAT_PACKAGE_ID_PATTERN;
        isValid = Pattern.matches(regexPattern, packageId);
        return isValid;
    }

    private boolean isValidScope(String packageId) {
        boolean isValid = false;
        if (packageId == null) {
            return false;
        }
        if (scopeRegistry == null) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(scopeRegistry, ",");
        int tokenCount = stringTokenizer.countTokens();
        for (int i = 0; i < tokenCount; ++i) {
            String token = stringTokenizer.nextToken();
            if (!packageId.startsWith(token + ".")) continue;
            isValid = true;
            break;
        }
        return isValid;
    }

    public void setAccessXML(String xmlString) {
        this.accessXML = xmlString;
    }

    private void qualityCheckPackageId(String packageId) {
        String packageIdIdentifier = "packageIdPattern";
        QualityCheck packageIdTemplate = QualityReport.getQualityCheckTemplate(packageIdIdentifier);
        QualityCheck packageIdQualityCheck = new QualityCheck(packageIdIdentifier, packageIdTemplate);
        String systemAttribute = packageIdQualityCheck.getSystem();
        if (QualityCheck.shouldRunQualityCheck(this, packageIdQualityCheck)) {
            if (scopeRegistry != null) {
                packageIdQualityCheck.setExpected("'scope.n.m', where 'n' and 'm' are integers and 'scope' is one of an allowed set of values");
            }
            if (packageId != null) {
                packageIdQualityCheck.setFound(packageId);
            }
            if (!this.isValidPackageIdForMetacat(packageId)) {
                packageIdQualityCheck.setStatus(QualityCheck.Status.error);
                packageIdQualityCheck.setExplanation("The packageId value should match the pattern 'scope.identifier.revision'.");
            } else if (this.identifierHasLeadingZero(packageId)) {
                packageIdQualityCheck.setStatus(QualityCheck.Status.error);
                packageIdQualityCheck.setExplanation("A leading zero was found in the identifier. The identifier value must be a whole number.");
                packageIdQualityCheck.setSuggestion("Remove leading zeros from the identifier value.");
            } else if (this.revisionHasLeadingZero(packageId)) {
                packageIdQualityCheck.setStatus(QualityCheck.Status.error);
                packageIdQualityCheck.setExplanation("A leading zero was found in the revision. The revision value must be a whole number.");
                packageIdQualityCheck.setSuggestion("Remove leading zeros from the revision value.");
            } else if (this.isValidScope(packageId)) {
                packageIdQualityCheck.setStatus(QualityCheck.Status.valid);
                packageIdQualityCheck.setSuggestion("");
            } else {
                packageIdQualityCheck.setFailedStatus();
                if (scopeRegistry != null) {
                    packageIdQualityCheck.setExplanation(String.format("A packageId should start with one of the following scope values: %s", scopeRegistry));
                    if (systemAttribute != null && systemAttribute.equals("lter")) {
                        packageIdQualityCheck.setSuggestion("Use a scope value that you are authorized to use for your site or project, or you may request that a new scope value be added to the list of allowed values by contacting tech_support@LTERnet.edu.");
                    }
                }
            }
            this.addDatasetQualityCheck(packageIdQualityCheck);
        }
    }

    public void setEmlNamespace(String emlNamespace) {
        this.emlNamespace = emlNamespace;
        String emlVersionIdentifier = "emlVersion";
        QualityCheck emlVersionTemplate = QualityReport.getQualityCheckTemplate(emlVersionIdentifier);
        QualityCheck emlVersionQualityCheck = new QualityCheck(emlVersionIdentifier, emlVersionTemplate);
        if (QualityCheck.shouldRunQualityCheck(this, emlVersionQualityCheck)) {
            boolean isValidNamespace = false;
            if (emlNamespace != null) {
                emlVersionQualityCheck.setFound(emlNamespace);
                if (emlNamespace.equals("eml://ecoinformatics.org/eml-2.1.0") || emlNamespace.equals("eml://ecoinformatics.org/eml-2.1.1")) {
                    isValidNamespace = true;
                }
            }
            if (isValidNamespace) {
                emlVersionQualityCheck.setStatus(QualityCheck.Status.valid);
                emlVersionQualityCheck.setSuggestion("");
            } else {
                emlVersionQualityCheck.setFailedStatus();
            }
            this.addDatasetQualityCheck(emlVersionQualityCheck);
        }
    }

    public void checkSchemaValid(Document doc, String namespaceInDoc) {
        String schemaValidIdentifier = "schemaValid";
        QualityCheck schemaValidTemplate = QualityReport.getQualityCheckTemplate(schemaValidIdentifier);
        QualityCheck schemaValidQualityCheck = new QualityCheck(schemaValidIdentifier, schemaValidTemplate);
        if (QualityCheck.shouldRunQualityCheck(this, schemaValidQualityCheck)) {
            boolean validateSchema = true;
            String found = "";
            String parserName = "DEFAULT";
            Element documentElement = doc.getDocumentElement();
            String xmlString = XMLUtilities.getDOMTreeAsString((Node)documentElement);
            StringReader stringReader = new StringReader(xmlString);
            SAXValidate saxValidate = new SAXValidate(validateSchema);
            try {
                saxValidate.runTest(stringReader, "DEFAULT", namespaceInDoc);
                found = "Document validated for namespace: '" + namespaceInDoc + "'";
                schemaValidQualityCheck.setStatus(QualityCheck.Status.valid);
                schemaValidQualityCheck.setSuggestion("");
                this.schemaValid = true;
            }
            catch (Exception e) {
                found = "Failed to validate for namespace: '" + namespaceInDoc + "'; " + e.getMessage();
                schemaValidQualityCheck.setFailedStatus();
            }
            schemaValidQualityCheck.setFound(found);
            this.addDatasetQualityCheck(schemaValidQualityCheck);
        }
    }

    public void checkParserValid(Document doc) {
        String parserValidIdentifier = "parserValid";
        QualityCheck parserValidTemplate = QualityReport.getQualityCheckTemplate(parserValidIdentifier);
        QualityCheck parserValidQualityCheck = new QualityCheck(parserValidIdentifier, parserValidTemplate);
        if (QualityCheck.shouldRunQualityCheck(this, parserValidQualityCheck)) {
            String found = "";
            Element documentElement = doc.getDocumentElement();
            String xmlString = XMLUtilities.getDOMTreeAsString((Node)documentElement);
            try {
                EMLParser emlParser = new EMLParser(xmlString);
                found = "EML IDs and references parser succeeded";
                parserValidQualityCheck.setStatus(QualityCheck.Status.valid);
                parserValidQualityCheck.setSuggestion("");
                this.parserValid = true;
            }
            catch (Exception e) {
                found = "Failed to parse IDs and references: " + e.getMessage();
                parserValidQualityCheck.setFailedStatus();
            }
            parserValidQualityCheck.setFound(found);
            this.addDatasetQualityCheck(parserValidQualityCheck);
        }
    }

    public void checkSchemaValidDereferenced(Document doc, String namespaceInDoc) {
        String identifier = "schemaValidDereferenced";
        QualityCheck qualityCheckTemplate = QualityReport.getQualityCheckTemplate(identifier);
        QualityCheck qualityCheck = new QualityCheck(identifier, qualityCheckTemplate);
        if (QualityCheck.shouldRunQualityCheck(this, qualityCheck)) {
            boolean validateSchema = true;
            String found = "";
            String parserName = "DEFAULT";
            Element documentElement = doc.getDocumentElement();
            String xmlString = XMLUtilities.getDOMTreeAsString((Node)documentElement);
            String deferencedXmlString = DataPackage.dereferenceEML(xmlString);
            StringReader stringReader = new StringReader(deferencedXmlString);
            SAXValidate saxValidate = new SAXValidate(validateSchema);
            try {
                saxValidate.runTest(stringReader, "DEFAULT", namespaceInDoc);
                found = "Dereferenced document validated for namespace: '" + namespaceInDoc + "'";
                qualityCheck.setStatus(QualityCheck.Status.valid);
                qualityCheck.setSuggestion("");
                this.schemaValid = true;
            }
            catch (Exception e) {
                found = "Failed to validate dereferenced document for namespace: '" + namespaceInDoc + "'; " + e.getMessage();
                qualityCheck.setFailedStatus();
            }
            qualityCheck.setFound(found);
            this.addDatasetQualityCheck(qualityCheck);
        }
    }

    public void setNumberOfKeywordElements(int n) {
        this.numberOfKeywordElements = n;
        String qualityCheckIdentifier = "keywordPresent";
        QualityCheck qualityCheckTemplate = QualityReport.getQualityCheckTemplate(qualityCheckIdentifier);
        QualityCheck qualityCheck = new QualityCheck(qualityCheckIdentifier, qualityCheckTemplate);
        if (QualityCheck.shouldRunQualityCheck(this, qualityCheck)) {
            String found = this.numberOfKeywordElements + " 'keyword' element(s) found";
            qualityCheck.setFound(found);
            if (this.numberOfKeywordElements > 0) {
                qualityCheck.setStatus(QualityCheck.Status.valid);
                qualityCheck.setExplanation("");
                qualityCheck.setSuggestion("");
            } else {
                qualityCheck.setFailedStatus();
            }
            this.addDatasetQualityCheck(qualityCheck);
        }
    }

    public void setNumberOfMethodsElements(int n) {
        this.numberOfMethodsElements = n;
        String methodsElementIdentifier = "methodsElementPresent";
        QualityCheck methodsElementTemplate = QualityReport.getQualityCheckTemplate(methodsElementIdentifier);
        QualityCheck methodsElementQualityCheck = new QualityCheck(methodsElementIdentifier, methodsElementTemplate);
        if (QualityCheck.shouldRunQualityCheck(this, methodsElementQualityCheck)) {
            String found = this.numberOfMethodsElements + " 'methods' element(s) found";
            methodsElementQualityCheck.setFound(found);
            if (this.numberOfMethodsElements > 0) {
                methodsElementQualityCheck.setStatus(QualityCheck.Status.valid);
                methodsElementQualityCheck.setExplanation("");
                methodsElementQualityCheck.setSuggestion("");
            } else {
                methodsElementQualityCheck.setFailedStatus();
            }
            this.addDatasetQualityCheck(methodsElementQualityCheck);
        }
    }

    public void setNumberOfCoverageElements(int n) {
        this.numberOfCoverageElements = n;
        String identifier = "coveragePresent";
        QualityCheck qualityCheckTemplate = QualityReport.getQualityCheckTemplate(identifier);
        QualityCheck qualityCheck = new QualityCheck(identifier, qualityCheckTemplate);
        if (QualityCheck.shouldRunQualityCheck(this, qualityCheck)) {
            String found = this.numberOfCoverageElements + " 'coverage' element(s) found";
            qualityCheck.setFound(found);
            if (this.numberOfCoverageElements > 0) {
                qualityCheck.setStatus(QualityCheck.Status.valid);
                qualityCheck.setExplanation("");
                qualityCheck.setSuggestion("");
            } else {
                qualityCheck.setFailedStatus();
            }
            this.addDatasetQualityCheck(qualityCheck);
        }
    }

    public void setNumberOfGeographicCoverageElements(int n) {
        this.numberOfGeographicCoverageElements = n;
        String identifier = "geographicCoveragePresent";
        QualityCheck qualityCheckTemplate = QualityReport.getQualityCheckTemplate(identifier);
        QualityCheck qualityCheck = new QualityCheck(identifier, qualityCheckTemplate);
        if (QualityCheck.shouldRunQualityCheck(this, qualityCheck)) {
            String found = this.numberOfGeographicCoverageElements + " 'geographicCoverage' element(s) found";
            qualityCheck.setFound(found);
            this.addDatasetQualityCheck(qualityCheck);
        }
    }

    public void setNumberOfTaxonomicCoverageElements(int n) {
        this.numberOfTaxonomicCoverageElements = n;
        String identifier = "taxonomicCoveragePresent";
        QualityCheck qualityCheckTemplate = QualityReport.getQualityCheckTemplate(identifier);
        QualityCheck qualityCheck = new QualityCheck(identifier, qualityCheckTemplate);
        if (QualityCheck.shouldRunQualityCheck(this, qualityCheck)) {
            String found = this.numberOfTaxonomicCoverageElements + " 'taxonomicCoverage' element(s) found";
            qualityCheck.setFound(found);
            this.addDatasetQualityCheck(qualityCheck);
        }
    }

    public void setNumberOfTemporalCoverageElements(int n) {
        this.numberOfTemporalCoverageElements = n;
        String identifier = "temporalCoveragePresent";
        QualityCheck qualityCheckTemplate = QualityReport.getQualityCheckTemplate(identifier);
        QualityCheck qualityCheck = new QualityCheck(identifier, qualityCheckTemplate);
        if (QualityCheck.shouldRunQualityCheck(this, qualityCheck)) {
            String found = this.numberOfTemporalCoverageElements + " 'temporalCoverage' element(s) found";
            qualityCheck.setFound(found);
            this.addDatasetQualityCheck(qualityCheck);
        }
    }

    public void setPubDate(String pubDate) {
        this.pubDate = pubDate;
        String identifier = "pubDatePresent";
        QualityCheck qualityCheckTemplate = QualityReport.getQualityCheckTemplate(identifier);
        QualityCheck qualityCheck = new QualityCheck(identifier, qualityCheckTemplate);
        if (QualityCheck.shouldRunQualityCheck(this, qualityCheck)) {
            boolean hasPubDate = pubDate != null && pubDate.length() >= 4;
            String found = pubDate;
            if (hasPubDate) {
                qualityCheck.setStatus(QualityCheck.Status.valid);
                qualityCheck.setExplanation("");
                qualityCheck.setSuggestion("");
            } else {
                found = "pubDate not found";
                qualityCheck.setFailedStatus();
            }
            qualityCheck.setFound(found);
            this.addDatasetQualityCheck(qualityCheck);
        }
    }

    public String getPubDate() {
        return this.pubDate;
    }

    public void setSystem(String systemValue) {
        this.system = systemValue;
    }

    public void setTitle(String titleText) {
        this.title = titleText;
        String identifier = "titleLength";
        QualityCheck qualityCheckTemplate = QualityReport.getQualityCheckTemplate(identifier);
        QualityCheck qualityCheck = new QualityCheck(identifier, qualityCheckTemplate);
        if (QualityCheck.shouldRunQualityCheck(this, qualityCheck)) {
            int wordCount = this.wordCount(titleText);
            String found = wordCount + " words found.";
            qualityCheck.setFound(found);
            if (wordCount >= 5) {
                qualityCheck.setStatus(QualityCheck.Status.valid);
                qualityCheck.setExplanation("");
                qualityCheck.setSuggestion("");
            } else {
                qualityCheck.setFailedStatus();
            }
            this.addDatasetQualityCheck(qualityCheck);
        }
    }

    public String getTitle() {
        return this.title;
    }

    public List<Party> getCreators() {
        return this.creators;
    }

    public void setCreators(List<Party> creators) {
        this.creators = creators;
    }

    public Party getPublisher() {
        return this.publisher;
    }

    public void setPublisher(Party publisher) {
        this.publisher = publisher;
    }

    public void checkDatasetAbstract(String abstractText) {
        String identifier = "datasetAbstractLength";
        QualityCheck qualityCheckTemplate = QualityReport.getQualityCheckTemplate(identifier);
        QualityCheck qualityCheck = new QualityCheck(identifier, qualityCheckTemplate);
        if (QualityCheck.shouldRunQualityCheck(this, qualityCheck)) {
            int wordCount = this.wordCount(abstractText);
            String found = wordCount + " words found.";
            qualityCheck.setFound(found);
            if (wordCount >= 20) {
                qualityCheck.setStatus(QualityCheck.Status.valid);
                qualityCheck.setExplanation("");
                qualityCheck.setSuggestion("");
            } else {
                qualityCheck.setFailedStatus();
            }
            this.addDatasetQualityCheck(qualityCheck);
        }
    }

    private int wordCount(String text) {
        int wordCount = 0;
        if (text != null && !text.equals("")) {
            for (String word : text.split("[\\s\\n]")) {
                if (word.length() < 3) continue;
                ++wordCount;
            }
        }
        return wordCount;
    }
}

